/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.FitNesseContext;
import fitnesse.authentication.NegotiateAuthenticator;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.util.Base64;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import util.RegexTestCase;

public class NegotiateAuthenticatorTest {
    private GSSManager manager;
    private Properties properties;
    private final String TOKEN = "xxxxxxxx";

    @Before
    public void setUp() {
        this.manager = (GSSManager)Mockito.mock(GSSManager.class);
        this.properties = new Properties();
    }

    @Test
    public void credentialsShouldBeNullIfNoServiceName() throws Exception {
        NegotiateAuthenticator authenticator = new NegotiateAuthenticator(this.manager, this.properties);
        Assert.assertNull((Object)authenticator.getServerCredentials());
        ((GSSManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.never())).createName(Mockito.anyString(), (Oid)Mockito.anyObject(), (Oid)Mockito.anyObject());
    }

    @Test
    public void credentialsShouldBeNonNullIfServiceNamePresent() throws Exception {
        this.properties.setProperty("NegotiateAuthenticator.serviceName", "service");
        this.properties.setProperty("NegotiateAuthenticator.serviceNameType", "1.1");
        this.properties.setProperty("NegotiateAuthenticator.mechanism", "1.2");
        GSSName gssName = (GSSName)Mockito.mock(GSSName.class);
        GSSCredential gssCredential = (GSSCredential)Mockito.mock(GSSCredential.class);
        Mockito.when((Object)this.manager.createName(Mockito.anyString(), (Oid)Mockito.anyObject(), (Oid)Mockito.anyObject())).thenReturn((Object)gssName);
        Mockito.when((Object)this.manager.createCredential((GSSName)Mockito.anyObject(), Mockito.anyInt(), (Oid)Mockito.anyObject(), Mockito.anyInt())).thenReturn((Object)gssCredential);
        NegotiateAuthenticator authenticator = new NegotiateAuthenticator(this.manager, this.properties);
        Oid serviceNameType = authenticator.getServiceNameType();
        Oid mechanism = authenticator.getMechanism();
        ((GSSManager)Mockito.verify((Object)this.manager)).createName("service", serviceNameType, mechanism);
        Assert.assertEquals((Object)"1.1", (Object)serviceNameType.toString());
        Assert.assertEquals((Object)"1.2", (Object)mechanism.toString());
        ((GSSManager)Mockito.verify((Object)this.manager)).createCredential(gssName, Integer.MAX_VALUE, mechanism, 2);
        Assert.assertEquals((Object)gssCredential, (Object)authenticator.getServerCredentials());
    }

    @Test
    public void negotiationErrorScreenForFailureToComplete() throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        FitNesseContext context = FitNesseUtil.makeTestContext((WikiPage)root);
        NegotiateAuthenticator.UnauthenticatedNegotiateResponder responder = new NegotiateAuthenticator.UnauthenticatedNegotiateResponder("token");
        MockRequest request = new MockRequest();
        SimpleResponse response = (SimpleResponse)responder.makeResponse(context, (Request)request);
        Assert.assertEquals((Object)"Negotiate token", (Object)response.getHeader("WWW-Authenticate"));
        String content = response.getContent();
        RegexTestCase.assertSubString((String)"Negotiated authentication required", (String)content);
        RegexTestCase.assertSubString((String)"Your client failed to complete required authentication", (String)content);
    }

    @Test
    public void negotiationErrorScreenForNeedingAuthentication() throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        FitNesseContext context = FitNesseUtil.makeTestContext((WikiPage)root);
        NegotiateAuthenticator.UnauthenticatedNegotiateResponder responder = new NegotiateAuthenticator.UnauthenticatedNegotiateResponder("token");
        SimpleResponse response = (SimpleResponse)responder.makeResponse(context, null);
        String content = response.getContent();
        RegexTestCase.assertSubString((String)"This request requires authentication", (String)content);
    }

    @Test
    public void noAuthorizationHeaderShouldProduceNullCredentials() throws Exception {
        MockRequest request = new MockRequest();
        NegotiateAuthenticator authenticator = new NegotiateAuthenticator(this.manager, this.properties);
        authenticator.negotiateCredentials((Request)request);
        Assert.assertNull((Object)request.getAuthorizationUsername());
        Assert.assertNull((Object)request.getAuthorizationPassword());
    }

    @Test
    public void invalidAuthorizationHeaderShouldProduceNullCredentials() throws Exception {
        MockRequest request = new MockRequest();
        request.addHeader("Authorization", (Object)"blah");
        NegotiateAuthenticator authenticator = new NegotiateAuthenticator(this.manager, this.properties);
        authenticator.negotiateCredentials((Request)request);
        Assert.assertNull((Object)request.getAuthorizationUsername());
        Assert.assertNull((Object)request.getAuthorizationPassword());
    }

    @Test
    public void validAuthorizationHeaderAndEstablishedContextShouldProduceUserAndPassword() throws Exception {
        String userName = "username";
        String password = "password";
        String encodedPassword = this.base64Encode(password);
        GSSContext gssContext = this.makeMockGssContext(userName, password);
        Mockito.when((Object)gssContext.isEstablished()).thenReturn((Object)true);
        MockRequest request = new MockRequest();
        this.doNegotiation(request);
        Assert.assertEquals((Object)userName, (Object)request.getAuthorizationUsername());
        Assert.assertEquals((Object)encodedPassword, (Object)request.getAuthorizationPassword());
    }

    private void doNegotiation(MockRequest request) throws Exception {
        request.addHeader("Authorization", (Object)"Negotiate xxxxxxxx");
        NegotiateAuthenticator authenticator = new NegotiateAuthenticator(this.manager, this.properties);
        authenticator.negotiateCredentials((Request)request);
    }

    private GSSContext makeMockGssContext(String userName, String password) throws GSSException {
        GSSContext gssContext = (GSSContext)Mockito.mock(GSSContext.class);
        Mockito.when((Object)this.manager.createContext((GSSCredential)Mockito.anyObject())).thenReturn((Object)gssContext);
        Mockito.when((Object)gssContext.acceptSecContext((byte[])Mockito.anyObject(), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)password.getBytes());
        GSSName gssName = (GSSName)Mockito.mock(GSSName.class);
        Mockito.when((Object)gssName.toString()).thenReturn((Object)userName);
        Mockito.when((Object)gssContext.getSrcName()).thenReturn((Object)gssName);
        return gssContext;
    }

    @Test
    public void validAuthorizationHeaderAndNoEstablishedContextShouldProducePasswordButNoUser() throws Exception {
        String userName = "username";
        String password = "password";
        String encodedPassword = this.base64Encode(password);
        GSSContext gssContext = this.makeMockGssContext(userName, password);
        Mockito.when((Object)gssContext.isEstablished()).thenReturn((Object)false);
        MockRequest request = new MockRequest();
        this.doNegotiation(request);
        Assert.assertNull((Object)request.getAuthorizationUsername());
        Assert.assertEquals((Object)encodedPassword, (Object)request.getAuthorizationPassword());
    }

    @Test
    public void realmIsStrippedIfRequested() throws Exception {
        this.properties.setProperty("NegotiateAuthenticator.stripRealm", "true");
        String userName = "username@realm";
        String password = "password";
        String encodedPassword = this.base64Encode(password);
        GSSContext gssContext = this.makeMockGssContext(userName, password);
        Mockito.when((Object)gssContext.isEstablished()).thenReturn((Object)true);
        MockRequest request = new MockRequest();
        this.doNegotiation(request);
        Assert.assertEquals((Object)"username", (Object)request.getAuthorizationUsername());
        Assert.assertEquals((Object)encodedPassword, (Object)request.getAuthorizationPassword());
    }

    private String base64Encode(String s) throws UnsupportedEncodingException {
        return new String(Base64.encode((byte[])s.getBytes("UTF-8")));
    }

    @Test
    public void getTokenShouldReturnDecodedToken() throws Exception {
        byte[] actual = NegotiateAuthenticator.getToken((String)"Negotiate xxxxxxxx");
        byte[] expected = Base64.decode((byte[])"xxxxxxxx".getBytes("UTF-8"));
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }
}

