/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.ClassPathBuilder;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.MockingPageCrawler;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageCrawlerDeadEndStrategy;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import util.FileUtil;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClassPathBuilderTest
extends RegexTestCase {
    private WikiPage root;
    private ClassPathBuilder builder;
    String pathSeparator = System.getProperty("path.separator");
    private PageCrawler crawler;
    private WikiPagePath somePagePath;
    private static final String TEST_DIR = "testDir";

    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.builder = new ClassPathBuilder();
        this.somePagePath = PathParser.parse((String)"SomePage");
    }

    public void testGetClasspath() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"TestPage"), "!path fitnesse.jar\n!path my.jar");
        String expected = "fitnesse.jar" + this.pathSeparator + "my.jar";
        ClassPathBuilderTest.assertEquals((String)expected, (String)this.builder.getClasspath(this.root.getChildPage("TestPage")));
    }

    public void testPathSeparatorVariable() throws Exception {
        WikiPage page = this.crawler.addPage(this.root, PathParser.parse((String)"TestPage"), "!define PATH_SEPARATOR {|}\n!path fitnesse.jar\n!path my.jar");
        PageData data = page.getData();
        page.commit(data);
        String expected = "fitnesse.jar|my.jar";
        ClassPathBuilderTest.assertEquals((String)expected, (String)this.builder.getClasspath(this.root.getChildPage("TestPage")));
    }

    public void testGetPaths_OneLevel() throws Exception {
        String pageContent = "This is some content\n!path aPath\nend of conent\n";
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        WikiPage page = this.crawler.addPage(root, PathParser.parse((String)"ClassPath"), pageContent);
        String path = this.builder.getClasspath(page);
        ClassPathBuilderTest.assertEquals((String)"aPath", (String)path);
    }

    public void testGetClassPathMultiLevel() throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler.addPage(root, PathParser.parse((String)"ProjectOne"), "!path path2\n!path path 3");
        this.crawler.addPage(root, PathParser.parse((String)"ProjectOne.TesT"), "!path path1");
        String cp = this.builder.getClasspath(this.crawler.getPage(root, PathParser.parse((String)"ProjectOne.TesT")));
        ClassPathBuilderTest.assertSubString((String)"path1", (String)cp);
        ClassPathBuilderTest.assertSubString((String)"path2", (String)cp);
        ClassPathBuilderTest.assertSubString((String)"\"path 3\"", (String)cp);
    }

    public void testLinearClassPath() throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        WikiPage superPage = this.crawler.addPage(root, PathParser.parse((String)"SuperPage"), "!path superPagePath");
        WikiPage subPage = this.crawler.addPage(superPage, PathParser.parse((String)"SubPage"), "!path subPagePath");
        String cp = this.builder.getClasspath(subPage);
        ClassPathBuilderTest.assertEquals((String)("subPagePath" + this.pathSeparator + "superPagePath"), (String)cp);
    }

    public void testGetClassPathFromPageThatDoesntExist() throws Exception {
        String classPath = this.makeClassPathFromSimpleStructure("somePath");
        ClassPathBuilderTest.assertEquals((String)"somePath", (String)classPath);
    }

    private String makeClassPathFromSimpleStructure(String path) throws Exception {
        PageData data = this.root.getData();
        data.setContent("!path " + path);
        this.root.commit(data);
        this.crawler = this.root.getPageCrawler();
        this.crawler.setDeadEndStrategy((PageCrawlerDeadEndStrategy)new MockingPageCrawler());
        WikiPage page = this.crawler.getPage(this.root, this.somePagePath);
        String classPath = this.builder.getClasspath(page);
        return classPath;
    }

    public void testThatPathsWithSpacesGetQuoted() throws Exception {
        this.crawler.addPage(this.root, this.somePagePath, "!path Some File.jar");
        this.crawler = this.root.getPageCrawler();
        WikiPage page = this.crawler.getPage(this.root, this.somePagePath);
        ClassPathBuilderTest.assertEquals((String)"\"Some File.jar\"", (String)this.builder.getClasspath(page));
        this.crawler.addPage(this.root, this.somePagePath, "!path somefile.jar\n!path Some Dir/someFile.jar");
        ClassPathBuilderTest.assertEquals((String)("somefile.jar" + this.pathSeparator + "\"Some Dir/someFile.jar\""), (String)this.builder.getClasspath(page));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWildCardExpansion() throws Exception {
        try {
            ClassPathBuilderTest.makeSampleFiles();
            String classPath = this.makeClassPathFromSimpleStructure("testDir/*.jar");
            ClassPathBuilderTest.assertHasRegexp((String)"one\\.jar", (String)classPath);
            ClassPathBuilderTest.assertHasRegexp((String)"two\\.jar", (String)classPath);
            classPath = this.makeClassPathFromSimpleStructure("testDir/*.dll");
            ClassPathBuilderTest.assertHasRegexp((String)"one\\.dll", (String)classPath);
            ClassPathBuilderTest.assertHasRegexp((String)"two\\.dll", (String)classPath);
            classPath = this.makeClassPathFromSimpleStructure("testDir/one*");
            ClassPathBuilderTest.assertHasRegexp((String)"one\\.dll", (String)classPath);
            ClassPathBuilderTest.assertHasRegexp((String)"one\\.jar", (String)classPath);
            ClassPathBuilderTest.assertHasRegexp((String)"oneA", (String)classPath);
            classPath = this.makeClassPathFromSimpleStructure("testDir/**.jar");
            ClassPathBuilderTest.assertHasRegexp((String)"one\\.jar", (String)classPath);
            ClassPathBuilderTest.assertHasRegexp((String)"two\\.jar", (String)classPath);
            ClassPathBuilderTest.assertHasRegexp((String)"subdir(?:\\\\|/)sub1\\.jar", (String)classPath);
            ClassPathBuilderTest.assertHasRegexp((String)"subdir(?:\\\\|/)sub2\\.jar", (String)classPath);
        }
        finally {
            ClassPathBuilderTest.deleteSampleFiles();
        }
    }

    public static void makeSampleFiles() {
        FileUtil.makeDir((String)"testDir");
        FileUtil.createFile((String)"testDir/one.jar", (String)"");
        FileUtil.createFile((String)"testDir/two.jar", (String)"");
        FileUtil.createFile((String)"testDir/one.dll", (String)"");
        FileUtil.createFile((String)"testDir/two.dll", (String)"");
        FileUtil.createFile((String)"testDir/oneA", (String)"");
        FileUtil.createFile((String)"testDir/twoA", (String)"");
        FileUtil.createDir((String)"testDir/subdir");
        FileUtil.createFile((String)"testDir/subdir/sub1.jar", (String)"");
        FileUtil.createFile((String)"testDir/subdir/sub2.jar", (String)"");
        FileUtil.createFile((String)"testDir/subdir/sub1.dll", (String)"");
        FileUtil.createFile((String)"testDir/subdir/sub2.dll", (String)"");
    }

    public static void deleteSampleFiles() {
        FileUtil.deleteFileSystemDirectory((String)"testDir");
    }
}

