/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.CompositePageFinderTestCase;
import fitnesse.components.OrPageFinder;
import fitnesse.components.PageFinder;
import fitnesse.wiki.WikiPage;
import java.util.List;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class OrPageFinderTest
extends CompositePageFinderTestCase {
    @Test
    public void singlePageFinder() throws Exception {
        this.sut = new OrPageFinder();
        this.setupMockWithEmptyReturnValue();
        this.sut.add(this.delegate);
        this.sut.search(this.page);
        ((PageFinder)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)1))).search(this.page);
    }

    @Test
    public void multiplePageFinder() throws Exception {
        this.sut = new OrPageFinder();
        this.setupMockWithEmptyReturnValue();
        this.sut.add(this.delegate);
        this.sut.add(this.delegate);
        this.sut.add(this.delegate);
        this.sut.search(this.page);
        ((PageFinder)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)3))).search(this.page);
    }

    @Test
    public void combinationIsFound() throws Exception {
        this.sut = new OrPageFinder();
        List expected = this.setupWikiPageList(new WikiPage[]{this.pageOne, this.pageTwo, this.pageThree});
        Mockito.when((Object)this.delegate.search((WikiPage)Matchers.any(WikiPage.class))).thenReturn((Object)expected);
        PageFinder delegate2 = (PageFinder)Mockito.mock(PageFinder.class);
        Mockito.when((Object)delegate2.search((WikiPage)Matchers.any(WikiPage.class))).thenReturn((Object)this.setupWikiPageList(new WikiPage[]{this.pageOne, this.pageTwo}));
        this.sut.add(this.delegate);
        this.sut.add(delegate2);
        List results = this.sut.search(this.page);
        this.assertFoundResultsEqualsExpectation(expected, results);
    }

    @Test
    public void multpleIntersections() throws Exception {
        this.sut = new OrPageFinder();
        List expected = this.setupWikiPageList(new WikiPage[]{this.pageOne, this.pageTwo, this.pageThree});
        Mockito.when((Object)this.delegate.search((WikiPage)Matchers.any(WikiPage.class))).thenReturn((Object)this.setupWikiPageList(new WikiPage[]{this.pageOne, this.pageTwo}));
        PageFinder delegate2 = (PageFinder)Mockito.mock(PageFinder.class);
        Mockito.when((Object)delegate2.search((WikiPage)Matchers.any(WikiPage.class))).thenReturn((Object)this.setupWikiPageList(new WikiPage[]{this.pageThree}));
        this.sut.add(this.delegate);
        this.sut.add(delegate2);
        this.sut.add(this.delegate);
        List results = this.sut.search(this.page);
        this.assertFoundResultsEqualsExpectation(expected, results);
    }
}

