/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.fixtures;

import fitnesse.fixtures.FitnesseFixtureContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PagesRunInSuite {
    private String prefix;
    private String testSystemID;

    public PagesRunInSuite(String prefix, String testSystemID) {
        this.prefix = prefix;
        this.testSystemID = testSystemID;
    }

    public List<Object> query() throws Exception {
        return this.buildQueryResponse(this.getPagesRunInSuite());
    }

    private List<String> getPagesRunInSuite() throws Exception {
        String[] testSystems;
        ArrayList<String> testPages = new ArrayList<String>();
        String content = FitnesseFixtureContext.sender.sentData();
        for (String testSystem : testSystems = content.split("slim:")) {
            this.addPagesForThisTestSystem(testPages, testSystem);
        }
        return testPages;
    }

    private void addPagesForThisTestSystem(List<String> testPages, String testSystem) {
        if (testSystem.startsWith(this.testSystemID)) {
            String[] pageString = testSystem.split("test_name\">");
            this.addPages(testPages, pageString);
        }
    }

    private void addPages(List<String> testPages, String[] pageString) {
        for (int i = 1; i < pageString.length; ++i) {
            int fragmentEnd = pageString[i].indexOf("<");
            String testPage = pageString[i].substring(0, fragmentEnd);
            if (!testPage.startsWith(this.prefix)) continue;
            testPages.add(testPage);
        }
    }

    private List<Object> buildQueryResponse(List<String> testPages) {
        ArrayList<Object> rows = new ArrayList<Object>();
        for (int i = 0; i < testPages.size(); ++i) {
            ArrayList<List<String>> columns = new ArrayList<List<String>>();
            List<String> pageNameCell = Arrays.asList("page name", testPages.get(i));
            columns.add(pageNameCell);
            rows.add(columns);
        }
        return rows;
    }
}

