/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html;

import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlTag;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HtmlTagTest {
    public static final String endl = HtmlElement.endl;
    private HtmlTag tag;

    @Before
    public void setUp() throws Exception {
        this.tag = new HtmlTag("aTag");
    }

    @Test
    public void testEmpty() throws Exception {
        Assert.assertEquals((Object)("<aTag/>" + endl), (Object)this.tag.html());
    }

    @Test
    public void givenNonNullHead_HeadIsPrepended() throws Exception {
        this.tag.head = "head";
        Assert.assertEquals((Object)("head<aTag/>" + endl), (Object)this.tag.html());
    }

    @Test
    public void givenNonNullTail_TailIsAppended() throws Exception {
        this.tag.tail = "tail";
        Assert.assertEquals((Object)("<aTag/>tail" + endl), (Object)this.tag.html());
    }

    @Test
    public void testWithText() throws Exception {
        this.tag.add("some text");
        Assert.assertEquals((Object)("<aTag>some text</aTag>" + endl), (Object)this.tag.html());
    }

    @Test
    public void testEmbeddedTag() throws Exception {
        this.tag.add((HtmlElement)new HtmlTag("innertag"));
        String expected = "<aTag>" + endl + "\t<innertag/>" + endl + "</aTag>" + endl;
        Assert.assertEquals((Object)expected, (Object)this.tag.html());
    }

    @Test
    public void testAttribute() throws Exception {
        this.tag.addAttribute("key", "value");
        Assert.assertEquals((Object)("<aTag key=\"value\"/>" + endl), (Object)this.tag.html());
    }

    @Test
    public void testCombination() throws Exception {
        this.tag.addAttribute("mykey", "myValue");
        HtmlTag inner = new HtmlTag("inner");
        inner.add((HtmlElement)new HtmlTag("beforetext"));
        inner.add("inner text");
        inner.add((HtmlElement)new HtmlTag("aftertext"));
        this.tag.add((HtmlElement)inner);
        String expected = "<aTag mykey=\"myValue\">" + endl + "\t<inner>" + endl + "\t\t<beforetext/>" + endl + "inner text" + endl + "\t\t<aftertext/>" + endl + "\t</inner>" + endl + "</aTag>" + endl;
        Assert.assertEquals((Object)expected, (Object)this.tag.html());
    }

    @Test
    public void testNoEndTabWithoutChildrenTags() throws Exception {
        HtmlTag subtag = new HtmlTag("subtag");
        subtag.add("content");
        this.tag.add((HtmlElement)subtag);
        String expected = "<aTag>" + endl + "\t<subtag>content</subtag>" + endl + "</aTag>" + endl;
        Assert.assertEquals((Object)expected, (Object)this.tag.html());
    }

    @Test
    public void whenInline_noLineBreaksOrTabsAreGeneratedForChildren() throws Exception {
        HtmlTag subtag = new HtmlTag("child");
        subtag.add("content");
        this.tag.add((HtmlElement)subtag);
        Assert.assertEquals((Object)("<aTag>\t<child>content</child>" + endl + "</aTag>"), (Object)this.tag.htmlInline());
    }

    @Test
    public void testTwoChildren() throws Exception {
        this.tag.add((HtmlElement)new HtmlTag("tag1"));
        this.tag.add((HtmlElement)new HtmlTag("tag2"));
        String expected = "<aTag>" + endl + "\t<tag1/>" + endl + "\t<tag2/>" + endl + "</aTag>" + endl;
        Assert.assertEquals((Object)expected, (Object)this.tag.html());
    }

    @Test
    public void testUse() throws Exception {
        this.tag.add("original");
        this.tag.use("new");
        Assert.assertEquals((Object)("<aTag>new</aTag>" + endl), (Object)this.tag.html());
    }
}

