/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.ComponentFactory;
import fitnesse.FitNesseContext;
import fitnesse.WikiPageFactory;
import fitnesse.authentication.PromiscuousAuthenticator;
import fitnesse.junit.FitNesseSuite;
import fitnesse.junit.JUnitHelper;
import fitnesse.junit.JUnitRunNotifierResultsListener;
import fitnesse.responders.run.ResultsListener;
import fitnesse.responders.run.SuiteContentsFinder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class FitNesseSuite
extends ParentRunner<String> {
    private final Class<?> suiteClass;
    private final String suiteName;
    private String fitNesseDir;
    private String outputDir;
    private String suiteFilter;
    private String excludeSuiteFilter;
    private boolean debugMode = false;
    private int port = 0;
    private List<String> children;

    public FitNesseSuite(Class<?> suiteClass, RunnerBuilder builder) throws InitializationError {
        super(suiteClass);
        this.suiteClass = suiteClass;
        this.suiteName = FitNesseSuite.getSuiteName(suiteClass);
        this.fitNesseDir = FitNesseSuite.getFitnesseDir(suiteClass);
        this.outputDir = FitNesseSuite.getOutputDir(suiteClass);
        this.suiteFilter = FitNesseSuite.getSuiteFilter(suiteClass);
        this.excludeSuiteFilter = FitNesseSuite.getExcludeSuiteFilter(suiteClass);
        this.debugMode = FitNesseSuite.useDebugMode(suiteClass);
        this.port = FitNesseSuite.getPort(suiteClass);
        try {
            FitNesseContext context = FitNesseSuite.initContext((String)this.fitNesseDir, (int)this.port);
            this.children = this.initChildren(context);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private List<String> initChildren(FitNesseContext context) {
        WikiPagePath path = PathParser.parse((String)this.suiteName);
        PageCrawler crawler = context.root.getPageCrawler();
        WikiPage suiteRoot = crawler.getPage(context.root, path);
        if (!suiteRoot.getData().hasAttribute("Suite")) {
            throw new IllegalArgumentException("page " + this.suiteName + " is not a suite");
        }
        WikiPage root = crawler.getPage(context.root, PathParser.parse((String)"."));
        LinkedList pages = new SuiteContentsFinder(suiteRoot, new fitnesse.responders.run.SuiteFilter(this.suiteFilter, this.excludeSuiteFilter), root).getAllPagesToRunForThisSuite();
        ArrayList<String> testPages = new ArrayList<String>();
        for (WikiPage wp : pages) {
            testPages.add(crawler.getFullPath(wp).toString());
        }
        return testPages;
    }

    protected Description describeChild(String child) {
        return Description.createTestDescription((Class)this.suiteClass, (String)child);
    }

    protected List<String> getChildren() {
        return this.children;
    }

    static String getFitnesseDir(Class<?> klass) throws InitializationError {
        FitnesseDir fitnesseDirAnnotation = klass.getAnnotation(FitnesseDir.class);
        if (fitnesseDirAnnotation == null) {
            throw new InitializationError("There must be a @FitnesseDir annotation");
        }
        return fitnesseDirAnnotation.value();
    }

    static String getSuiteFilter(Class<?> klass) throws InitializationError {
        SuiteFilter suiteFilterAnnotation = klass.getAnnotation(SuiteFilter.class);
        if (suiteFilterAnnotation == null) {
            return null;
        }
        return suiteFilterAnnotation.value();
    }

    static String getExcludeSuiteFilter(Class<?> klass) throws InitializationError {
        ExcludeSuiteFilter excludeSuiteFilterAnnotation = klass.getAnnotation(ExcludeSuiteFilter.class);
        if (excludeSuiteFilterAnnotation == null) {
            return null;
        }
        return excludeSuiteFilterAnnotation.value();
    }

    static String getSuiteName(Class<?> klass) throws InitializationError {
        Name nameAnnotation = klass.getAnnotation(Name.class);
        if (nameAnnotation == null) {
            throw new InitializationError("There must be a @Name annotation");
        }
        return nameAnnotation.value();
    }

    static String getOutputDir(Class<?> klass) throws InitializationError {
        OutputDir outputDirAnnotation = klass.getAnnotation(OutputDir.class);
        if (outputDirAnnotation == null) {
            throw new InitializationError("There must be a @OutputDir annotation");
        }
        if (!"".equals(outputDirAnnotation.value())) {
            return outputDirAnnotation.value();
        }
        if (!"".equals(outputDirAnnotation.systemProperty())) {
            String baseDir = System.getProperty(outputDirAnnotation.systemProperty());
            File outputDir = new File(baseDir, outputDirAnnotation.pathExtension());
            return outputDir.getAbsolutePath();
        }
        throw new InitializationError("In annotation @OutputDir you have to specify either 'value' or 'systemProperty'");
    }

    public static boolean useDebugMode(Class<?> klass) {
        DebugMode debugModeAnnotation = klass.getAnnotation(DebugMode.class);
        if (null == debugModeAnnotation) {
            return true;
        }
        return debugModeAnnotation.value();
    }

    public static int getPort(Class<?> klass) {
        Port portAnnotation = klass.getAnnotation(Port.class);
        if (null == portAnnotation) {
            return 0;
        }
        int lport = portAnnotation.value();
        if (!"".equals(portAnnotation.systemProperty())) {
            lport = Integer.getInteger(portAnnotation.systemProperty(), lport);
        }
        return lport;
    }

    public void run(RunNotifier notifier) {
        if (this.isFilteredForChildTest()) {
            super.run(notifier);
        } else {
            this.runFullSuite(notifier);
        }
    }

    protected void runFullSuite(RunNotifier notifier) {
        JUnitHelper helper = this.createJUnitHelper(notifier);
        try {
            helper.assertSuitePasses(this.suiteName, this.suiteFilter, this.excludeSuiteFilter);
        }
        catch (AssertionFailedError e) {
            notifier.fireTestFailure(new Failure(Description.createSuiteDescription((Class)this.suiteClass), (Throwable)e));
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(Description.createSuiteDescription((Class)this.suiteClass), (Throwable)e));
        }
    }

    private boolean isFilteredForChildTest() {
        return this.getDescription().getChildren().size() < this.getChildren().size();
    }

    protected void runChild(String test, RunNotifier notifier) {
        JUnitHelper helper = this.createJUnitHelper(notifier);
        try {
            helper.assertTestPasses(test);
        }
        catch (AssertionFailedError e) {
            notifier.fireTestFailure(new Failure(Description.createSuiteDescription((Class)this.suiteClass), (Throwable)e));
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(Description.createSuiteDescription((Class)this.suiteClass), (Throwable)e));
        }
    }

    private JUnitHelper createJUnitHelper(RunNotifier notifier) {
        JUnitHelper jUnitHelper = new JUnitHelper(this.fitNesseDir, this.outputDir, (ResultsListener)new JUnitRunNotifierResultsListener(notifier, this.suiteClass));
        jUnitHelper.setDebugMode(this.debugMode);
        jUnitHelper.setPort(this.port);
        return jUnitHelper;
    }

    private static FitNesseContext initContext(String rootPath, int port) throws Exception {
        FitNesseContext.Builder builder = new FitNesseContext.Builder();
        WikiPageFactory wikiPageFactory = new WikiPageFactory();
        ComponentFactory componentFactory = new ComponentFactory(rootPath);
        builder.port = port;
        builder.rootPath = rootPath;
        builder.rootDirectoryName = "FitNesseRoot";
        builder.pageTheme = componentFactory.getProperty("Theme");
        builder.defaultNewPageContent = componentFactory.getProperty("newpage.default.content");
        builder.root = wikiPageFactory.makeRootPage(builder.rootPath, builder.rootDirectoryName, componentFactory);
        builder.logger = null;
        builder.authenticator = new PromiscuousAuthenticator();
        FitNesseContext context = builder.createFitNesseContext();
        return context;
    }
}

