/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NameWikiPageResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.HashSet;
import org.json.JSONArray;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.RegexTestCase;

public class NameWikiPageResponderTest {
    private WikiPage root;
    private NameWikiPageResponder responder;
    private MockRequest request;
    private PageCrawler crawler;
    private String pageOneName;
    private String pageTwoName;
    private String frontPageName;
    private WikiPagePath pageOnePath;
    private WikiPagePath pageTwoPath;
    private WikiPagePath frontPagePath;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.responder = new NameWikiPageResponder();
        this.request = new MockRequest();
        this.pageOneName = "PageOne";
        this.pageTwoName = "PageTwo";
        this.frontPageName = "FrontPage";
        this.pageOnePath = PathParser.parse((String)this.pageOneName);
        this.pageTwoPath = PathParser.parse((String)this.pageTwoName);
        this.frontPagePath = PathParser.parse((String)this.frontPageName);
    }

    @Test
    public void testTextPlain() throws Exception {
        Response r = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        Assert.assertEquals((Object)"text/plain", (Object)r.getContentType());
    }

    @Test
    public void testPageNamesFromRoot() throws Exception {
        this.crawler.addPage(this.root, this.pageOnePath);
        this.crawler.addPage(this.root, this.pageTwoPath);
        this.request.setResource("");
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        RegexTestCase.assertHasRegexp((String)this.pageOneName, (String)response.getContent());
        RegexTestCase.assertHasRegexp((String)this.pageTwoName, (String)response.getContent());
    }

    @Test
    public void testPageNamesFromASubPage() throws Exception {
        WikiPage frontPage = this.crawler.addPage(this.root, this.frontPagePath);
        this.crawler.addPage(frontPage, this.pageOnePath);
        this.crawler.addPage(frontPage, this.pageTwoPath);
        this.request.setResource("");
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        RegexTestCase.assertHasRegexp((String)this.frontPageName, (String)response.getContent());
        RegexTestCase.assertDoesntHaveRegexp((String)this.pageOneName, (String)response.getContent());
        RegexTestCase.assertDoesntHaveRegexp((String)this.pageTwoName, (String)response.getContent());
        this.request.setResource(this.frontPageName);
        response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        RegexTestCase.assertHasRegexp((String)this.pageOneName, (String)response.getContent());
        RegexTestCase.assertHasRegexp((String)this.pageTwoName, (String)response.getContent());
        RegexTestCase.assertDoesntHaveRegexp((String)this.frontPageName, (String)response.getContent());
    }

    @Test
    public void jsonFormat() throws Exception {
        this.crawler.addPage(this.root, this.pageOnePath);
        this.crawler.addPage(this.root, this.pageTwoPath);
        this.request.setResource("");
        this.request.addInput("format", (Object)"json");
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        JSONArray actual = new JSONArray(response.getContent());
        Assert.assertEquals((long)2L, (long)actual.length());
        HashSet<String> actualSet = new HashSet<String>();
        actualSet.add(actual.getString(0));
        actualSet.add(actual.getString(1));
        HashSet<String> expectedSet = new HashSet<String>();
        expectedSet.add(this.pageOneName);
        expectedSet.add(this.pageTwoName);
        Assert.assertEquals(expectedSet, actualSet);
    }

    @Test
    public void canShowChildCount() throws Exception {
        WikiPage frontPage = this.crawler.addPage(this.root, this.frontPagePath);
        this.crawler.addPage(frontPage, this.pageOnePath);
        this.crawler.addPage(frontPage, this.pageTwoPath);
        this.request.setResource("");
        this.request.addInput("ShowChildCount", (Object)"");
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        RegexTestCase.assertHasRegexp((String)"FrontPage 2", (String)response.getContent());
    }
}

