/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.Responder;
import fitnesse.http.Request;
import fitnesse.responders.DefaultResponder;
import fitnesse.responders.ImportAndViewResponder;
import fitnesse.responders.NameWikiPageResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.PacketResponder;
import fitnesse.responders.PageDataWikiPageResponder;
import fitnesse.responders.RawContentResponder;
import fitnesse.responders.RssResponder;
import fitnesse.responders.SerializedPageResponder;
import fitnesse.responders.ShutdownResponder;
import fitnesse.responders.WikiImportingResponder;
import fitnesse.responders.WikiPageResponder;
import fitnesse.responders.editing.AddChildPageResponder;
import fitnesse.responders.editing.EditResponder;
import fitnesse.responders.editing.NewPageResponder;
import fitnesse.responders.editing.PropertiesResponder;
import fitnesse.responders.editing.SavePropertiesResponder;
import fitnesse.responders.editing.SaveResponder;
import fitnesse.responders.editing.SymbolicLinkResponder;
import fitnesse.responders.files.CreateDirectoryResponder;
import fitnesse.responders.files.DeleteConfirmationResponder;
import fitnesse.responders.files.DeleteFileResponder;
import fitnesse.responders.files.FileResponder;
import fitnesse.responders.files.RenameFileConfirmationResponder;
import fitnesse.responders.files.RenameFileResponder;
import fitnesse.responders.files.UploadResponder;
import fitnesse.responders.refactoring.DeletePageResponder;
import fitnesse.responders.refactoring.MovePageResponder;
import fitnesse.responders.refactoring.RefactorPageResponder;
import fitnesse.responders.refactoring.RenamePageResponder;
import fitnesse.responders.refactoring.SearchReplaceResponder;
import fitnesse.responders.run.FitClientResponder;
import fitnesse.responders.run.SocketCatchingResponder;
import fitnesse.responders.run.StopTestResponder;
import fitnesse.responders.run.SuiteResponder;
import fitnesse.responders.run.TestResponder;
import fitnesse.responders.run.TestResultFormattingResponder;
import fitnesse.responders.search.ExecuteSearchPropertiesResponder;
import fitnesse.responders.search.SearchFormResponder;
import fitnesse.responders.search.SearchResponder;
import fitnesse.responders.search.WhereUsedResponder;
import fitnesse.responders.testHistory.HistoryComparerResponder;
import fitnesse.responders.testHistory.PageHistoryResponder;
import fitnesse.responders.testHistory.PurgeHistoryResponder;
import fitnesse.responders.testHistory.SuiteOverviewResponder;
import fitnesse.responders.testHistory.TestHistoryResponder;
import fitnesse.responders.versions.RollbackResponder;
import fitnesse.responders.versions.VersionComparerResponder;
import fitnesse.responders.versions.VersionResponder;
import fitnesse.responders.versions.VersionSelectionResponder;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.parser.WikiWordPath;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import util.StringUtil;

public class ResponderFactory {
    private final String rootPath;
    private final Map<String, Class<?>> responderMap;

    public ResponderFactory(String rootPath) {
        this.rootPath = rootPath;
        this.responderMap = new HashMap();
        this.addResponder("new", NewPageResponder.class);
        this.addResponder("edit", EditResponder.class);
        this.addResponder("saveData", SaveResponder.class);
        this.addResponder("search", SearchResponder.class);
        this.addResponder("searchForm", SearchFormResponder.class);
        this.addResponder("stoptest", StopTestResponder.class);
        this.addResponder("test", TestResponder.class);
        this.addResponder("suite", SuiteResponder.class);
        this.addResponder("proxy", SerializedPageResponder.class);
        this.addResponder("versions", VersionSelectionResponder.class);
        this.addResponder("viewVersion", VersionResponder.class);
        this.addResponder("rollback", RollbackResponder.class);
        this.addResponder("names", NameWikiPageResponder.class);
        this.addResponder("properties", PropertiesResponder.class);
        this.addResponder("saveProperties", SavePropertiesResponder.class);
        this.addResponder("executeSearchProperties", ExecuteSearchPropertiesResponder.class);
        this.addResponder("whereUsed", WhereUsedResponder.class);
        this.addResponder("refactor", RefactorPageResponder.class);
        this.addResponder("deletePage", DeletePageResponder.class);
        this.addResponder("renamePage", RenamePageResponder.class);
        this.addResponder("movePage", MovePageResponder.class);
        this.addResponder("pageData", PageDataWikiPageResponder.class);
        this.addResponder("createDir", CreateDirectoryResponder.class);
        this.addResponder("upload", UploadResponder.class);
        this.addResponder("socketCatcher", SocketCatchingResponder.class);
        this.addResponder("fitClient", FitClientResponder.class);
        this.addResponder("deleteFile", DeleteFileResponder.class);
        this.addResponder("renameFile", RenameFileResponder.class);
        this.addResponder("deleteConfirmation", DeleteConfirmationResponder.class);
        this.addResponder("renameConfirmation", RenameFileConfirmationResponder.class);
        this.addResponder("raw", RawContentResponder.class);
        this.addResponder("rss", RssResponder.class);
        this.addResponder("import", WikiImportingResponder.class);
        this.addResponder("files", FileResponder.class);
        this.addResponder("shutdown", ShutdownResponder.class);
        this.addResponder("format", TestResultFormattingResponder.class);
        this.addResponder("symlink", SymbolicLinkResponder.class);
        this.addResponder("importAndView", ImportAndViewResponder.class);
        this.addResponder("getPage", WikiPageResponder.class);
        this.addResponder("packet", PacketResponder.class);
        this.addResponder("testHistory", TestHistoryResponder.class);
        this.addResponder("pageHistory", PageHistoryResponder.class);
        this.addResponder("addChild", AddChildPageResponder.class);
        this.addResponder("purgeHistory", PurgeHistoryResponder.class);
        this.addResponder("compareHistory", HistoryComparerResponder.class);
        this.addResponder("replace", SearchReplaceResponder.class);
        this.addResponder("overview", SuiteOverviewResponder.class);
        this.addResponder("compareVersions", VersionComparerResponder.class);
    }

    public void addResponder(String key, String responderClassName) throws ClassNotFoundException {
        this.responderMap.put(key, Class.forName(responderClassName));
    }

    public void addResponder(String key, Class<?> responderClass) {
        this.responderMap.put(key, responderClass);
    }

    public String getResponderKey(Request request) {
        String fullQuery = request.hasInput("responder") ? (String)request.getInput("responder") : request.getQueryString();
        if (fullQuery == null) {
            return null;
        }
        int argStart = fullQuery.indexOf(38);
        return argStart <= 0 ? fullQuery : fullQuery.substring(0, argStart);
    }

    public Responder makeResponder(Request request, WikiPage root) throws InstantiationException {
        Object responder = new DefaultResponder();
        String resource = request.getResource();
        String responderKey = this.getResponderKey(request);
        responder = this.usingResponderKey(responderKey) ? this.lookupResponder(responderKey) : (StringUtil.isBlank((String)resource) ? new WikiPageResponder() : (resource.startsWith("files/") || resource.equals("files") ? FileResponder.makeResponder((Request)request, (String)this.rootPath) : (WikiWordPath.isWikiWord((String)resource) || "root".equals(resource) ? new WikiPageResponder() : new NotFoundResponder())));
        return responder;
    }

    private Responder lookupResponder(String responderKey) throws InstantiationException {
        Class responderClass = this.getResponderClass(responderKey);
        if (responderClass != null) {
            try {
                return this.newResponderInstance(responderClass);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InstantiationException("Unable to instantiate responder " + responderKey);
            }
        }
        throw new InstantiationException("No responder for " + responderKey);
    }

    private Responder newResponderInstance(Class<?> responderClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            Constructor<?> constructor = responderClass.getConstructor(String.class);
            return (Responder)constructor.newInstance(this.rootPath);
        }
        catch (NoSuchMethodException e) {
            Constructor<?> constructor = responderClass.getConstructor(new Class[0]);
            return (Responder)constructor.newInstance(new Object[0]);
        }
    }

    public Class<?> getResponderClass(String responderKey) {
        return (Class)this.responderMap.get(responderKey);
    }

    private boolean usingResponderKey(String responderKey) {
        return !"".equals(responderKey) && responderKey != null;
    }
}

