/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.Responder;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.responders.NameWikiPageResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.PacketResponder;
import fitnesse.responders.PageDataWikiPageResponder;
import fitnesse.responders.RawContentResponder;
import fitnesse.responders.ResponderFactory;
import fitnesse.responders.RssResponder;
import fitnesse.responders.SerializedPageResponder;
import fitnesse.responders.ShutdownResponder;
import fitnesse.responders.WikiImportingResponder;
import fitnesse.responders.WikiPageResponder;
import fitnesse.responders.editing.AddChildPageResponder;
import fitnesse.responders.editing.EditResponder;
import fitnesse.responders.editing.PropertiesResponder;
import fitnesse.responders.editing.SavePropertiesResponder;
import fitnesse.responders.editing.SaveResponder;
import fitnesse.responders.editing.SymbolicLinkResponder;
import fitnesse.responders.files.CreateDirectoryResponder;
import fitnesse.responders.files.DeleteConfirmationResponder;
import fitnesse.responders.files.DeleteFileResponder;
import fitnesse.responders.files.FileResponder;
import fitnesse.responders.files.RenameFileConfirmationResponder;
import fitnesse.responders.files.RenameFileResponder;
import fitnesse.responders.files.UploadResponder;
import fitnesse.responders.refactoring.DeletePageResponder;
import fitnesse.responders.refactoring.MovePageResponder;
import fitnesse.responders.refactoring.RefactorPageResponder;
import fitnesse.responders.refactoring.RenamePageResponder;
import fitnesse.responders.refactoring.SearchReplaceResponder;
import fitnesse.responders.run.FitClientResponder;
import fitnesse.responders.run.SocketCatchingResponder;
import fitnesse.responders.run.StopTestResponder;
import fitnesse.responders.run.SuiteResponder;
import fitnesse.responders.run.TestResponder;
import fitnesse.responders.run.TestResultFormattingResponder;
import fitnesse.responders.search.ExecuteSearchPropertiesResponder;
import fitnesse.responders.search.SearchFormResponder;
import fitnesse.responders.search.SearchResponder;
import fitnesse.responders.search.WhereUsedResponder;
import fitnesse.responders.testHistory.HistoryComparerResponder;
import fitnesse.responders.testHistory.PageHistoryResponder;
import fitnesse.responders.testHistory.PurgeHistoryResponder;
import fitnesse.responders.testHistory.TestHistoryResponder;
import fitnesse.responders.versions.RollbackResponder;
import fitnesse.responders.versions.VersionResponder;
import fitnesse.responders.versions.VersionSelectionResponder;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageDummy;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.FileUtil;

public class ResponderFactoryTest {
    private ResponderFactory factory;
    private MockRequest request;
    private WikiPageDummy nonExistantPage;
    private WikiPage root;
    private PageCrawler crawler;

    @Before
    public void setUp() throws Exception {
        this.factory = new ResponderFactory("testDir");
        this.request = new MockRequest();
        this.root = InMemoryPage.makeRoot((String)"root");
        this.crawler = this.root.getPageCrawler();
        this.nonExistantPage = new WikiPageDummy();
    }

    @Test
    public void testGetResponderKey() throws Exception {
        this.checkResponderKey("railroad", "railroad");
        this.checkResponderKey("responder=railroad", "railroad");
        this.checkResponderKey("", "");
    }

    private void checkResponderKey(String queryString, String key) {
        MockRequest request = new MockRequest();
        request.setQueryString(queryString);
        Assert.assertEquals((Object)key, (Object)this.factory.getResponderKey((Request)request));
    }

    @Test
    public void testWikiPageResponder() throws Exception {
        this.request.setResource("SomePage");
        this.assertResponderType(WikiPageResponder.class, this.root);
        this.request.setResource("");
        this.assertResponderType(WikiPageResponder.class, this.root);
        this.request.setResource("root");
        this.assertResponderType(WikiPageResponder.class, this.root);
    }

    @Test
    public void testRefactorPageResponder() throws Exception {
        this.assertResponderTypeMatchesInput("refactor", RefactorPageResponder.class);
    }

    @Test
    public void testDeletePageResponder() throws Exception {
        this.assertResponderTypeMatchesInput("deletePage", DeletePageResponder.class);
    }

    @Test
    public void testRenamePageResponder() throws Exception {
        this.assertResponderTypeMatchesInput("renamePage", RenamePageResponder.class);
    }

    @Test
    public void testEditResponder() throws Exception {
        this.request.addInput("responder", (Object)"edit");
        this.request.setResource("SomePage");
        this.assertResponderType(EditResponder.class, this.root);
        this.assertResponderType(EditResponder.class, (WikiPage)this.nonExistantPage);
    }

    @Test
    public void testPageDataResponder() throws Exception {
        this.request.addInput("responder", (Object)"pageData");
        this.request.setResource("SomePage");
        this.assertResponderType(PageDataWikiPageResponder.class, this.root);
    }

    @Test
    public void testSaveResponder() throws Exception {
        this.assertResponderTypeMatchesInput("saveData", SaveResponder.class);
    }

    @Test
    public void testTestResponder() throws Exception {
        this.assertResponderTypeMatchesInput("test", TestResponder.class);
    }

    @Test
    public void testSuiteResponder() throws Exception {
        this.assertResponderTypeMatchesInput("suite", SuiteResponder.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileResponder() throws Exception {
        try {
            new File("testDir").mkdir();
            new File("testDir/files").mkdir();
            FileUtil.createFile((String)"testDir/files/someFile", (String)"this is a test");
            this.request.setResource("files/someFile");
            this.assertResponderType(FileResponder.class, (WikiPage)this.nonExistantPage);
        }
        finally {
            FileUtil.deleteFileSystemDirectory((String)"testDir");
        }
    }

    @Test
    public void testSearchFormResponder() throws Exception {
        this.assertResponderTypeMatchesInput("searchForm", SearchFormResponder.class);
    }

    @Test
    public void testSearchResponder() throws Exception {
        this.assertResponderTypeMatchesInput("search", SearchResponder.class);
    }

    @Test
    public void testSerializedPageResponder() throws Exception {
        this.assertResponderTypeMatchesInput("proxy", SerializedPageResponder.class);
    }

    @Test
    public void testVersionSelectionResponder() throws Exception {
        this.assertResponderTypeMatchesInput("versions", VersionSelectionResponder.class);
    }

    @Test
    public void testVersionResponder() throws Exception {
        this.assertResponderTypeMatchesInput("viewVersion", VersionResponder.class);
    }

    @Test
    public void testRollbackResponder() throws Exception {
        this.assertResponderTypeMatchesInput("rollback", RollbackResponder.class);
    }

    @Test
    public void testNameReponder() throws Exception {
        this.assertResponderTypeMatchesInput("names", NameWikiPageResponder.class);
    }

    @Test
    public void testUploadResponder() throws Exception {
        this.assertResponderTypeMatchesInput("upload", UploadResponder.class);
    }

    @Test
    public void testCreateDirectoryResponder() throws Exception {
        this.assertResponderTypeMatchesInput("createDir", CreateDirectoryResponder.class);
    }

    @Test
    public void testDeleteFileResponder() throws Exception {
        this.assertResponderTypeMatchesInput("deleteFile", DeleteFileResponder.class);
    }

    @Test
    public void testRenameFileResponder() throws Exception {
        this.assertResponderTypeMatchesInput("renameFile", RenameFileResponder.class);
    }

    @Test
    public void testDeleteConfirmationFileResponder() throws Exception {
        this.assertResponderTypeMatchesInput("deleteConfirmation", DeleteConfirmationResponder.class);
    }

    @Test
    public void testRenameFileConfirmationResponder() throws Exception {
        this.assertResponderTypeMatchesInput("renameConfirmation", RenameFileConfirmationResponder.class);
    }

    @Test
    public void testCreatePropertiesResponder() throws Exception {
        this.assertResponderTypeMatchesInput("properties", PropertiesResponder.class);
    }

    @Test
    public void testCreateSavePropertiesResponder() throws Exception {
        this.assertResponderTypeMatchesInput("saveProperties", SavePropertiesResponder.class);
    }

    @Test
    public void testCreateExecuteSearchPropertiesResponder() throws Exception {
        this.assertResponderTypeMatchesInput("executeSearchProperties", ExecuteSearchPropertiesResponder.class);
    }

    @Test
    public void testCreateWhereUsedResponder() throws Exception {
        this.assertResponderTypeMatchesInput("whereUsed", WhereUsedResponder.class);
    }

    @Test
    public void testCreateMovePageResponer() throws Exception {
        this.assertResponderTypeMatchesInput("movePage", MovePageResponder.class);
    }

    @Test
    public void testSocketCatcher() throws Exception {
        this.assertResponderTypeMatchesInput("socketCatcher", SocketCatchingResponder.class);
    }

    @Test
    public void testFitClient() throws Exception {
        this.assertResponderTypeMatchesInput("fitClient", FitClientResponder.class);
    }

    @Test
    public void testRawContent() throws Exception {
        this.assertResponderTypeMatchesInput("raw", RawContentResponder.class);
    }

    @Test
    public void testRssResponder() throws Exception {
        this.assertResponderTypeMatchesInput("rss", RssResponder.class);
    }

    @Test
    public void testPageImporterResponder() throws Exception {
        this.assertResponderTypeMatchesInput("import", WikiImportingResponder.class);
    }

    @Test
    public void testShutdownResponder() throws Exception {
        this.assertResponderTypeMatchesInput("shutdown", ShutdownResponder.class);
    }

    @Test
    public void testTestResultFormattingResponder() throws Exception {
        this.assertResponderTypeMatchesInput("format", TestResultFormattingResponder.class);
    }

    @Test
    public void testSymbolicLinkResponder() throws Exception {
        this.assertResponderTypeMatchesInput("symlink", SymbolicLinkResponder.class);
    }

    @Test
    public void testPacketResponder() throws Exception {
        this.assertResponderTypeMatchesInput("packet", PacketResponder.class);
    }

    @Test
    public void testStopTestResponder() throws Exception {
        this.assertResponderTypeMatchesInput("stoptest", StopTestResponder.class);
    }

    @Test
    public void testReplaceResponder() throws Exception {
        this.assertResponderTypeMatchesInput("replace", SearchReplaceResponder.class);
    }

    @Test
    public void testNotFoundResponder() throws Exception {
        this.request.setResource("somepage");
        this.assertResponderType(NotFoundResponder.class, this.root);
    }

    @Test
    public void testAddingResponders() throws Exception {
        this.factory.addResponder("custom", WikiPageResponder.class);
        this.assertResponderTypeMatchesInput("custom", WikiPageResponder.class);
    }

    private void assertResponderType(Class<?> expectedClass, WikiPage page) throws Exception {
        Responder responder = this.factory.makeResponder((Request)this.request, page);
        Assert.assertEquals(expectedClass, responder.getClass());
    }

    private void assertResponderTypeMatchesInput(String responderType, Class<?> responderClass) throws Exception {
        this.request.addInput("responder", (Object)responderType);
        this.assertResponderType(responderClass, this.root);
    }

    @Test
    public void testTestHistoryResponder() throws Exception {
        this.assertResponderTypeMatchesInput("testHistory", TestHistoryResponder.class);
    }

    @Test
    public void testPageHistoryResponder() throws Exception {
        this.assertResponderTypeMatchesInput("pageHistory", PageHistoryResponder.class);
    }

    @Test
    public void testAddChildPageResponder() throws Exception {
        this.assertResponderTypeMatchesInput("addChild", AddChildPageResponder.class);
    }

    @Test
    public void testPurgeHistoryResponder() throws Exception {
        this.assertResponderTypeMatchesInput("purgeHistory", PurgeHistoryResponder.class);
    }

    @Test
    public void testHistoryComparerResponder() throws Exception {
        this.assertResponderTypeMatchesInput("compareHistory", HistoryComparerResponder.class);
    }
}

