/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.components.TraversalListener;
import fitnesse.http.RequestBuilder;
import fitnesse.http.ResponseParser;
import fitnesse.responders.WikiImporter;
import fitnesse.responders.WikiImporterClient;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageXmlizer;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wiki.XmlizerPageHandler;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import util.XmlUtil;

public class WikiImporter
implements XmlizerPageHandler,
TraversalListener<WikiPage> {
    private String remoteUsername;
    private String remotePassword;
    private String remoteHostname;
    private int remotePort;
    private WikiPagePath localPath;
    private WikiPagePath remotePath = new WikiPagePath();
    private WikiPagePath relativePath = new WikiPagePath();
    protected WikiImporterClient importerClient;
    protected int importCount = 0;
    protected int unmodifiedCount = 0;
    private List<WikiPagePath> orphans = new LinkedList();
    private HashSet<WikiPagePath> pageCatalog;
    private PageCrawler crawler;
    private boolean shouldDeleteOrphans = true;
    private WikiPagePath contextPath;
    private boolean autoUpdateSetting;
    private Exception caughtException;

    public WikiImporter() {
        this.importerClient = new NullWikiImporterClient(null);
        this.localPath = new WikiPagePath();
    }

    public WikiImporter(WikiImporterClient client) {
        this.importerClient = client;
        this.localPath = new WikiPagePath();
    }

    public void importWiki(WikiPage page) {
        Document remotePageTreeDocument;
        this.catalogLocalTree(page);
        try {
            remotePageTreeDocument = this.getPageTree();
        }
        catch (AuthenticationRequiredException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WikiImporterException("Unable to process page tree", (Throwable)e);
        }
        new PageXmlizer().deXmlizeSkippingRootLevel(remotePageTreeDocument, page, (XmlizerPageHandler)this);
        this.configureAutoUpdateSetting(page);
        this.filterOrphans(page);
        if (this.shouldDeleteOrphans) {
            this.removeOrphans(page);
        }
    }

    private void removeOrphans(WikiPage context) {
        for (WikiPagePath orphan : this.orphans) {
            WikiPagePath path = orphan;
            WikiPage wikiPage = this.crawler.getPage(context, path);
            if (wikiPage == null) continue;
            wikiPage.getParent().removeChildPage(wikiPage.getName());
        }
    }

    private void filterOrphans(WikiPage context) {
        for (WikiPagePath aPageCatalog : this.pageCatalog) {
            WikiPagePath wikiPagePath = aPageCatalog;
            WikiPage unrecognizedPage = this.crawler.getPage(context, wikiPagePath);
            PageData data = unrecognizedPage.getData();
            WikiImportProperty importProps = WikiImportProperty.createFrom((WikiPageProperty)data.getProperties());
            if (importProps == null || importProps.isRoot()) continue;
            this.orphans.add(wikiPagePath);
        }
    }

    private void catalogLocalTree(WikiPage page) {
        this.crawler = page.getPageCrawler();
        this.contextPath = this.crawler.getFullPath(page);
        this.pageCatalog = new HashSet();
        page.getPageCrawler().traverse(page, (TraversalListener)this);
        WikiPagePath relativePathOfContext = this.contextPath.subtractFromFront(this.contextPath);
        this.pageCatalog.remove(relativePathOfContext);
    }

    public void enterChildPage(WikiPage childPage, Date lastModified) {
        if (this.pageCatalog != null) {
            this.pageCatalog.remove(this.relativePath(childPage));
        }
        this.remotePath.addNameToEnd(childPage.getName());
        this.relativePath.addNameToEnd(childPage.getName());
        this.localPath.addNameToEnd(childPage.getName());
        PageData data = childPage.getData();
        WikiPageProperties props = data.getProperties();
        WikiImportProperty importProps = WikiImportProperty.createFrom((WikiPageProperty)props);
        if (importProps != null) {
            Date lastRemoteModification = importProps.getLastRemoteModificationTime();
            if (lastModified.after(lastRemoteModification)) {
                this.importRemotePageContent(childPage);
            } else {
                ++this.unmodifiedCount;
                this.configureAutoUpdateSetting(importProps, data, childPage);
            }
        } else {
            this.importRemotePageContent(childPage);
        }
    }

    private void configureAutoUpdateSetting(WikiImportProperty importProps, PageData data, WikiPage childPage) {
        if (importProps.isAutoUpdate() != this.autoUpdateSetting) {
            importProps.setAutoUpdate(this.autoUpdateSetting);
            importProps.addTo((WikiPageProperty)data.getProperties());
            childPage.commit(data);
        }
    }

    public void configureAutoUpdateSetting(WikiPage page) {
        PageData data = page.getData();
        WikiPageProperties props = data.getProperties();
        WikiImportProperty importProps = WikiImportProperty.createFrom((WikiPageProperty)props);
        if (importProps != null) {
            this.configureAutoUpdateSetting(importProps, data, page);
        }
    }

    private WikiPagePath relativePath(WikiPage childPage) {
        return this.crawler.getFullPath(childPage).subtractFromFront(this.contextPath);
    }

    protected void importRemotePageContent(WikiPage localPage) {
        try {
            Document doc = this.getXmlDocument("data");
            PageData remoteData = new PageXmlizer().deXmlizeData(doc);
            WikiPageProperties remoteProps = remoteData.getProperties();
            remoteProps.remove("Edit");
            WikiImportProperty importProperty = new WikiImportProperty(this.remoteUrl());
            Date lastModificationTime = remoteProps.getLastModificationTime();
            importProperty.setLastRemoteModificationTime(lastModificationTime);
            importProperty.setAutoUpdate(this.autoUpdateSetting);
            importProperty.addTo((WikiPageProperty)remoteProps);
            localPage.commit(remoteData);
            this.importerClient.pageImported(localPage);
        }
        catch (AuthenticationRequiredException e) {
            throw e;
        }
        catch (Exception e) {
            this.caughtException = e;
            this.importerClient.pageImportError(localPage, e);
        }
        ++this.importCount;
    }

    public String remoteUrl() {
        String remotePathName = PathParser.render((WikiPagePath)this.remotePath);
        return "http://" + this.remoteHostname + ":" + this.remotePort + "/" + remotePathName;
    }

    public void exitPage() {
        this.remotePath.removeNameFromEnd();
        this.relativePath.removeNameFromEnd();
        this.localPath.removeNameFromEnd();
    }

    public Document getPageTree() throws IOException, SAXException {
        return this.getXmlDocument("pages");
    }

    private Document getXmlDocument(String documentType) throws IOException, SAXException {
        ResponseParser parser;
        String remotePathName = PathParser.render((WikiPagePath)this.remotePath);
        RequestBuilder builder = new RequestBuilder("/" + remotePathName);
        builder.addInput("responder", (Object)"proxy");
        builder.addInput("type", (Object)documentType);
        builder.setHostAndPort(this.remoteHostname, this.remotePort);
        if (this.remoteUsername != null) {
            builder.addCredentials(this.remoteUsername, this.remotePassword);
        }
        if ((parser = ResponseParser.performHttpRequest((String)this.remoteHostname, (int)this.remotePort, (RequestBuilder)builder)).getStatus() == 404) {
            throw new IOException("The remote resource, " + this.remoteUrl() + ", was not found.");
        }
        if (parser.getStatus() == 401) {
            throw new AuthenticationRequiredException(this.remoteUrl());
        }
        String body = parser.getBody();
        return XmlUtil.newDocument((String)body);
    }

    public Exception getCaughtException() {
        return this.caughtException;
    }

    public void setRemoteUsername(String username) {
        this.remoteUsername = username;
    }

    public void setRemotePassword(String password) {
        this.remotePassword = password;
    }

    public WikiPagePath getRelativePath() {
        return this.relativePath;
    }

    public WikiPagePath getLocalPath() {
        return this.localPath;
    }

    public String getRemoteHostname() {
        return this.remoteHostname;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public WikiPagePath getRemotePath() {
        return this.remotePath;
    }

    public int getUnmodifiedCount() {
        return this.unmodifiedCount;
    }

    public int getImportCount() {
        return this.importCount;
    }

    public void parseUrl(String urlString) throws MalformedURLException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new MalformedURLException(urlString + " is not a valid URL.");
        }
        this.remoteHostname = url.getHost();
        this.remotePort = url.getPort();
        if (this.remotePort == -1) {
            this.remotePort = 80;
        }
        String path = url.getPath();
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.remotePath = PathParser.parse((String)path);
        if (this.remotePath == null) {
            throw new MalformedURLException("The URL's resource path, " + path + ", is not a valid WikiWord.");
        }
    }

    public void setWikiImporterClient(WikiImporterClient client) {
        this.importerClient = client;
    }

    public void setLocalPath(WikiPagePath path) {
        this.localPath = path;
    }

    public List<WikiPagePath> getOrphans() {
        return this.orphans;
    }

    public void process(WikiPage page) {
        WikiPagePath relativePath = this.relativePath(page);
        this.pageCatalog.add(relativePath);
    }

    public void setDeleteOrphanOption(boolean shouldDeleteOrphans) {
        this.shouldDeleteOrphans = shouldDeleteOrphans;
    }

    public boolean getAutoUpdateSetting() {
        return this.autoUpdateSetting;
    }

    public void setAutoUpdateSetting(boolean autoUpdateSetting) {
        this.autoUpdateSetting = autoUpdateSetting;
    }
}

