/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.authentication.SecureWriteOperation;
import fitnesse.components.TraversalListener;
import fitnesse.components.Traverser;
import fitnesse.http.ChunkedResponse;
import fitnesse.responders.ChunkingResponder;
import fitnesse.responders.WikiImporter;
import fitnesse.responders.WikiImporterClient;
import fitnesse.responders.WikiImportingResponder;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperty;

public class WikiImportingResponder
extends ChunkingResponder
implements SecureResponder,
WikiImporterClient,
Traverser<Object> {
    private boolean isUpdate;
    private boolean isNonRoot;
    public PageData data;
    private WikiImporter importer = new WikiImporter();
    private TraversalListener<Object> traversalListener;

    public void setImporter(WikiImporter importer) {
        this.importer = importer;
    }

    protected void doSending() throws Exception {
        this.data = this.page.getData();
        this.initializeImporter();
        HtmlPage htmlPage = this.makeHtml();
        htmlPage.render(this.response.getWriter());
        this.response.closeAll();
    }

    public void traverse(TraversalListener<Object> traversalListener) {
        this.traversalListener = traversalListener;
        try {
            if (this.isNonRoot) {
                this.importer.importRemotePageContent(this.page);
            }
            this.importer.importWiki(this.page);
            if (!this.isUpdate) {
                WikiImportProperty importProperty = new WikiImportProperty(this.importer.remoteUrl());
                importProperty.setRoot(true);
                importProperty.setAutoUpdate(this.importer.getAutoUpdateSetting());
                importProperty.addTo((WikiPageProperty)this.data.getProperties());
                this.page.commit(this.data);
            }
        }
        catch (WikiImporter.WikiImporterException e) {
            traversalListener.process((Object)new ImportError("ERROR", "The remote resource, " + this.importer.remoteUrl() + ", was not found."));
        }
        catch (WikiImporter.AuthenticationRequiredException e) {
            traversalListener.process((Object)new ImportError("AUTH", e.getMessage()));
        }
        catch (Exception e) {
            traversalListener.process((Object)new ImportError("ERROR", e.getMessage(), e));
        }
    }

    public void initializeImporter() throws Exception {
        String remoteWikiUrl = this.establishRemoteUrlAndUpdateStyle();
        this.importer.setWikiImporterClient((WikiImporterClient)this);
        this.importer.setLocalPath(this.path);
        this.importer.parseUrl(remoteWikiUrl);
        this.setRemoteUserCredentialsOnImporter();
        this.importer.setAutoUpdateSetting(this.request.hasInput("autoUpdate"));
    }

    private void setRemoteUserCredentialsOnImporter() {
        if (this.request.hasInput("remoteUsername")) {
            this.importer.setRemoteUsername((String)this.request.getInput("remoteUsername"));
        }
        if (this.request.hasInput("remotePassword")) {
            this.importer.setRemotePassword((String)this.request.getInput("remotePassword"));
        }
    }

    private String establishRemoteUrlAndUpdateStyle() throws Exception {
        String remoteWikiUrl = (String)this.request.getInput("remoteUrl");
        WikiImportProperty importProperty = WikiImportProperty.createFrom((WikiPageProperty)this.data.getProperties());
        if (importProperty != null) {
            remoteWikiUrl = importProperty.getSourceUrl();
            this.isUpdate = true;
            this.isNonRoot = !importProperty.isRoot();
        }
        return remoteWikiUrl;
    }

    private HtmlPage makeHtml() throws Exception {
        HtmlPage html = this.context.pageFactory.newPage();
        html = this.context.pageFactory.newPage();
        String title = "Wiki Import";
        if (this.isUpdate) {
            title = title + " Update";
        }
        String localPathName = PathParser.render((WikiPagePath)this.path);
        html.setTitle(title + ": " + localPathName);
        html.setPageTitle(new PageTitle(title, this.path));
        html.setMainTemplate("wikiImportingPage");
        html.put("isUpdate", (Object)this.isUpdate);
        String pageName = PathParser.render((WikiPagePath)this.path);
        html.put("pageName", (Object)pageName);
        String remoteWikiUrl = this.importer.remoteUrl();
        html.put("remoteUrl", (Object)remoteWikiUrl);
        html.put("importer", (Object)this.importer);
        html.put("PathParser", PathParser.class);
        html.put("importTraverser", (Object)this);
        return html;
    }

    protected PageCrawler getPageCrawler() {
        return this.root.getPageCrawler();
    }

    public void setResponse(ChunkedResponse response) {
        this.response = response;
    }

    public SecureOperation getSecureOperation() {
        return new SecureWriteOperation();
    }

    public void pageImported(WikiPage localPage) {
        this.traversalListener.process((Object)localPage);
    }

    public void pageImportError(WikiPage localPage, Exception e) {
        this.traversalListener.process((Object)new ImportError("PAGEERROR", e.getMessage(), e));
    }

    public WikiImporter getImporter() {
        return this.importer;
    }
}

