/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.http.ChunkedDataProvider;
import fitnesse.http.ChunkedResponse;
import fitnesse.http.MockChunkedDataProvider;
import fitnesse.http.MockRequest;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.responders.MockWikiImporter;
import fitnesse.responders.WikiImporter;
import fitnesse.responders.WikiImporterTest;
import fitnesse.responders.WikiImportingResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageDummy;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import java.io.IOException;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class WikiImportingResponderTest
extends RegexTestCase {
    private WikiImportingResponder responder;
    private String baseUrl;
    private WikiImporterTest testData;

    public void setUp() throws Exception {
        this.testData = new WikiImporterTest();
        this.testData.createRemoteRoot();
        this.testData.createLocalRoot();
        FitNesseUtil.startFitnesse((WikiPage)this.testData.remoteRoot);
        this.baseUrl = "http://localhost:1999/";
        this.createResponder();
    }

    private void createResponder() throws Exception {
        this.responder = new WikiImportingResponder();
        this.responder.path = new WikiPagePath();
        ChunkedResponse response = new ChunkedResponse("html", (ChunkedDataProvider)new MockChunkedDataProvider());
        response.sendTo((ResponseSender)new MockResponseSender());
        this.responder.setResponse(response);
        this.responder.getImporter().setDeleteOrphanOption(false);
    }

    public void tearDown() throws Exception {
        FitNesseUtil.stopFitnesse();
    }

    public void testActionsOfMakeResponse() throws Exception {
        ChunkedResponse response = this.makeSampleResponse(this.baseUrl);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending((Response)response);
        WikiImportingResponderTest.assertEquals((int)2, (int)this.testData.pageTwo.getChildren().size());
        WikiPage importedPageOne = this.testData.pageTwo.getChildPage("PageOne");
        WikiImportingResponderTest.assertNotNull((Object)importedPageOne);
        WikiImportingResponderTest.assertEquals((String)"page one", (String)importedPageOne.getData().getContent());
        WikiPage importedPageTwo = this.testData.pageTwo.getChildPage("PageTwo");
        WikiImportingResponderTest.assertNotNull((Object)importedPageTwo);
        WikiImportingResponderTest.assertEquals((String)"page two", (String)importedPageTwo.getData().getContent());
        WikiImportingResponderTest.assertEquals((int)1, (int)importedPageOne.getChildren().size());
        WikiPage importedChildOne = importedPageOne.getChildPage("ChildOne");
        WikiImportingResponderTest.assertNotNull((Object)importedChildOne);
        WikiImportingResponderTest.assertEquals((String)"child one", (String)importedChildOne.getData().getContent());
    }

    public void testImportingFromNonRootPageUpdatesPageContent() throws Exception {
        PageData data = this.testData.pageTwo.getData();
        WikiImportProperty importProperty = new WikiImportProperty(this.baseUrl + "PageOne");
        importProperty.addTo((WikiPageProperty)data.getProperties());
        data.setContent("nonsense");
        this.testData.pageTwo.commit(data);
        ChunkedResponse response = this.makeSampleResponse("blah");
        MockResponseSender sender = new MockResponseSender();
        sender.doSending((Response)response);
        data = this.testData.pageTwo.getData();
        WikiImportingResponderTest.assertEquals((String)"page one", (String)data.getContent());
        WikiImportingResponderTest.assertFalse((boolean)WikiImportProperty.createFrom((WikiPageProperty)data.getProperties()).isRoot());
    }

    public void testImportPropertiesGetAdded() throws Exception {
        ChunkedResponse response = this.makeSampleResponse(this.baseUrl);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending((Response)response);
        this.checkProperties(this.testData.pageTwo, this.baseUrl, true, null);
        WikiPage importedPageOne = this.testData.pageTwo.getChildPage("PageOne");
        this.checkProperties(importedPageOne, this.baseUrl + "PageOne", false, this.testData.remoteRoot.getChildPage("PageOne"));
        WikiPage importedPageTwo = this.testData.pageTwo.getChildPage("PageTwo");
        this.checkProperties(importedPageTwo, this.baseUrl + "PageTwo", false, this.testData.remoteRoot.getChildPage("PageTwo"));
        WikiPage importedChildOne = importedPageOne.getChildPage("ChildOne");
        this.checkProperties(importedChildOne, this.baseUrl + "PageOne.ChildOne", false, this.testData.remoteRoot.getChildPage("PageOne").getChildPage("ChildOne"));
    }

    private void checkProperties(WikiPage page, String source, boolean isRoot, WikiPage remotePage) throws Exception {
        WikiPageProperties props = page.getData().getProperties();
        if (!isRoot) {
            WikiImportingResponderTest.assertFalse((String)"should not have Edit property", (boolean)props.has("Edit"));
        }
        WikiImportProperty importProperty = WikiImportProperty.createFrom((WikiPageProperty)props);
        WikiImportingResponderTest.assertNotNull((Object)importProperty);
        WikiImportingResponderTest.assertEquals((String)source, (String)importProperty.getSourceUrl());
        WikiImportingResponderTest.assertEquals((boolean)isRoot, (boolean)importProperty.isRoot());
        if (remotePage != null) {
            long remoteLastModificationTime = remotePage.getData().getProperties().getLastModificationTime().getTime();
            long importPropertyLastModificationTime = importProperty.getLastRemoteModificationTime().getTime();
            WikiImportingResponderTest.assertEquals((long)remoteLastModificationTime, (long)importPropertyLastModificationTime);
        }
    }

    private String simulateWebRequest(MockRequest request) throws IOException {
        ChunkedResponse response = this.getResponse(request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending((Response)response);
        String content = sender.sentData();
        return content;
    }

    public void testHtmlOfMakeResponse() throws IOException {
        ChunkedResponse response = this.makeSampleResponse(this.baseUrl);
        MockResponseSender sender = new MockResponseSender();
        response.turnOffChunking();
        sender.doSending((Response)response);
        String content = sender.sentData();
        System.out.println(content);
        WikiImportingResponderTest.assertSubString((String)"<html>", (String)content);
        WikiImportingResponderTest.assertSubString((String)"Wiki Import", (String)content);
        WikiImportingResponderTest.assertSubString((String)"PageTwo", (String)content);
        WikiImportingResponderTest.assertSubString((String)"PageTwo.PageOne", (String)content);
        WikiImportingResponderTest.assertSubString((String)"PageTwo.PageOne.ChildOne", (String)content);
        WikiImportingResponderTest.assertSubString((String)"Import complete.", (String)content);
        WikiImportingResponderTest.assertSubString((String)"3 pages were imported.", (String)content);
    }

    public void testHtmlOfMakeResponseWithNoModifications() throws Exception {
        ChunkedResponse response = this.makeSampleResponse(this.baseUrl);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending((Response)response);
        this.createResponder();
        response = this.makeSampleResponse(this.baseUrl);
        sender = new MockResponseSender();
        sender.doSending((Response)response);
        String content = sender.sentData();
        WikiImportingResponderTest.assertSubString((String)"<html>", (String)content);
        WikiImportingResponderTest.assertSubString((String)"Wiki Import", (String)content);
        WikiImportingResponderTest.assertSubString((String)"PageTwo", (String)content);
        WikiImportingResponderTest.assertNotSubString((String)"PageTwo.PageOne", (String)content);
        WikiImportingResponderTest.assertNotSubString((String)"href=\"PageTwo.PageOne.ChildOne\"", (String)content);
        WikiImportingResponderTest.assertNotSubString((String)"href=\"PageTwo.PageTwo\"", (String)content);
        WikiImportingResponderTest.assertSubString((String)"Import complete.", (String)content);
        WikiImportingResponderTest.assertSubString((String)"0 pages were imported.", (String)content);
        WikiImportingResponderTest.assertSubString((String)"3 pages were unmodified.", (String)content);
    }

    private ChunkedResponse makeSampleResponse(String remoteUrl) {
        MockRequest request = this.makeRequest(remoteUrl);
        return this.getResponse(request);
    }

    private ChunkedResponse getResponse(MockRequest request) {
        ChunkedResponse response = (ChunkedResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.testData.localRoot), (Request)request);
        response.turnOffChunking();
        return response;
    }

    private MockRequest makeRequest(String remoteUrl) {
        MockRequest request = new MockRequest();
        request.setResource("PageTwo");
        request.addInput("responder", (Object)"import");
        request.addInput("remoteUrl", (Object)remoteUrl);
        return request;
    }

    public void testMakeResponseImportingNonRootPage() throws Exception {
        MockRequest request = this.makeRequest(this.baseUrl + "PageOne");
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.testData.localRoot), (Request)request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(response);
        String content = sender.sentData();
        WikiImportingResponderTest.assertNotNull((Object)this.testData.pageTwo.getChildPage("ChildOne"));
        WikiImportingResponderTest.assertSubString((String)"PageTwo.ChildOne", (String)content);
        WikiImportingResponderTest.assertSubString((String)"ChildOne", (String)content);
    }

    public void testRemoteUrlNotFound() throws Exception {
        String remoteUrl = this.baseUrl + "PageDoesntExist";
        ChunkedResponse response = this.makeSampleResponse(remoteUrl);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending((Response)response);
        String content = sender.sentData();
        WikiImportingResponderTest.assertSubString((String)("The remote resource, " + remoteUrl + ", was not found."), (String)content);
    }

    public void testErrorMessageForBadUrlProvided() throws Exception {
        String remoteUrl = this.baseUrl + "blah";
        ChunkedResponse response = this.makeSampleResponse(remoteUrl);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending((Response)response);
        String content = sender.sentData();
        WikiImportingResponderTest.assertSubString((String)"The URL's resource path, blah, is not a valid WikiWord.", (String)content);
    }

    public void testListOfOrphanedPages() throws Exception {
        WikiImporter importer = new WikiImporter();
        this.responder.setImporter(importer);
        MockRequest request = this.makeRequest(this.baseUrl);
        String content = this.simulateWebRequest(request);
        WikiImportingResponderTest.assertNotSubString((String)"orphan", (String)content);
        importer.getOrphans().add(new WikiPagePath(this.testData.pageOne));
        importer.getOrphans().add(new WikiPagePath(this.testData.childPageOne));
        content = this.simulateWebRequest(request);
        WikiImportingResponderTest.assertSubString((String)"2 orphaned pages were found and have been removed.", (String)content);
        WikiImportingResponderTest.assertSubString((String)"PageOne", (String)content);
        WikiImportingResponderTest.assertSubString((String)"PageOne.ChildOne", (String)content);
    }

    public void testAutoUpdatingTurnedOn() throws Exception {
        MockRequest request = this.makeRequest(this.baseUrl);
        this.responder.setRequest((Request)request);
        this.responder.data = new PageData((WikiPage)new WikiPageDummy());
        this.responder.initializeImporter();
        WikiImportingResponderTest.assertFalse((boolean)this.responder.getImporter().getAutoUpdateSetting());
        request.addInput("autoUpdate", (Object)"1");
        this.responder.initializeImporter();
        WikiImportingResponderTest.assertTrue((boolean)this.responder.getImporter().getAutoUpdateSetting());
    }

    public void testAutoUpdateSettingDisplayed() throws Exception {
        MockWikiImporter importer = new MockWikiImporter();
        this.responder.setImporter((WikiImporter)importer);
        MockRequest request = this.makeRequest(this.baseUrl);
        request.addInput("autoUpdate", (Object)true);
        String content = this.simulateWebRequest(request);
        WikiImportingResponderTest.assertSubString((String)"Automatic Update turned ON", (String)content);
        request = this.makeRequest(this.baseUrl);
        content = this.simulateWebRequest(request);
        WikiImportingResponderTest.assertSubString((String)"Automatic Update turned OFF", (String)content);
    }
}

