/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.WikiPageResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageVersionPruner;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class WikiPageResponderTest
extends RegexTestCase {
    private WikiPage root;
    private PageCrawler crawler;
    private FitNesseContext context;

    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"root");
        this.crawler = this.root.getPageCrawler();
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        PageVersionPruner.daysTillVersionsExpire = 14;
    }

    public void testResponse() throws Exception {
        WikiPage page = this.crawler.addPage(this.root, PathParser.parse((String)"ChildPage"), "child content");
        PageData data = page.getData();
        WikiPageProperties properties = data.getProperties();
        properties.set("Suites", "Wiki Page tags");
        page.commit(data);
        MockRequest request = new MockRequest();
        request.setResource("ChildPage");
        WikiPageResponder responder = new WikiPageResponder();
        SimpleResponse response = (SimpleResponse)responder.makeResponse(this.context, (Request)request);
        WikiPageResponderTest.assertEquals((int)200, (int)response.getStatus());
        String body = response.getContent();
        WikiPageResponderTest.assertSubString((String)"<html>", (String)body);
        WikiPageResponderTest.assertSubString((String)"<body", (String)body);
        WikiPageResponderTest.assertSubString((String)"child content", (String)body);
        WikiPageResponderTest.assertSubString((String)"href=\"ChildPage?whereUsed\"", (String)body);
        WikiPageResponderTest.assertSubString((String)"Cache-Control: max-age=0", (String)response.makeHttpHeaders());
        WikiPageResponderTest.assertSubString((String)"<h5> Wiki Page tags</h5>", (String)body);
    }

    public void testAttributeButtons() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"NormalPage"));
        WikiPage noButtonsPage = this.crawler.addPage(this.root, PathParser.parse((String)"NoButtonPage"));
        for (String attribute : PageData.NON_SECURITY_ATTRIBUTES) {
            PageData data = noButtonsPage.getData();
            data.removeAttribute(attribute);
            noButtonsPage.commit(data);
        }
        SimpleResponse response = this.requestPage("NormalPage");
        WikiPageResponderTest.assertSubString((String)">Edit</a>", (String)response.getContent());
        WikiPageResponderTest.assertSubString((String)">Search</a>", (String)response.getContent());
        WikiPageResponderTest.assertSubString((String)">Versions</a>", (String)response.getContent());
        WikiPageResponderTest.assertNotSubString((String)">Suite</a>", (String)response.getContent());
        WikiPageResponderTest.assertNotSubString((String)">Test</a>", (String)response.getContent());
        response = this.requestPage("NoButtonPage");
        WikiPageResponderTest.assertNotSubString((String)">Edit</a>", (String)response.getContent());
        WikiPageResponderTest.assertNotSubString((String)">Search</a>", (String)response.getContent());
        WikiPageResponderTest.assertNotSubString((String)">Versions</a>", (String)response.getContent());
        WikiPageResponderTest.assertNotSubString((String)">Suite</a>", (String)response.getContent());
        WikiPageResponderTest.assertNotSubString((String)">Test</a>", (String)response.getContent());
    }

    public void testHeadersAndFooters() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"NormalPage"), "normal");
        this.crawler.addPage(this.root, PathParser.parse((String)"TestPage"), "test page");
        this.crawler.addPage(this.root, PathParser.parse((String)"PageHeader"), "header");
        this.crawler.addPage(this.root, PathParser.parse((String)"PageFooter"), "footer");
        this.crawler.addPage(this.root, PathParser.parse((String)"SetUp"), "setup");
        this.crawler.addPage(this.root, PathParser.parse((String)"TearDown"), "teardown");
        this.crawler.addPage(this.root, PathParser.parse((String)"SuiteSetUp"), "suite setup");
        this.crawler.addPage(this.root, PathParser.parse((String)"SuiteTearDown"), "suite teardown");
        SimpleResponse response = this.requestPage("NormalPage");
        String content = response.getContent();
        WikiPageResponderTest.assertHasRegexp((String)"header", (String)content);
        WikiPageResponderTest.assertHasRegexp((String)"normal", (String)content);
        WikiPageResponderTest.assertHasRegexp((String)"footer", (String)content);
        WikiPageResponderTest.assertDoesntHaveRegexp((String)"setup", (String)content);
        WikiPageResponderTest.assertDoesntHaveRegexp((String)"teardown", (String)content);
        WikiPageResponderTest.assertDoesntHaveRegexp((String)"suite setup", (String)content);
        WikiPageResponderTest.assertDoesntHaveRegexp((String)"suite teardown", (String)content);
        response = this.requestPage("TestPage");
        content = response.getContent();
        WikiPageResponderTest.assertHasRegexp((String)"header", (String)content);
        WikiPageResponderTest.assertHasRegexp((String)"test page", (String)content);
        WikiPageResponderTest.assertHasRegexp((String)"footer", (String)content);
        WikiPageResponderTest.assertHasRegexp((String)"setup", (String)content);
        WikiPageResponderTest.assertHasRegexp((String)"teardown", (String)content);
        WikiPageResponderTest.assertHasRegexp((String)"suite setup", (String)content);
        WikiPageResponderTest.assertHasRegexp((String)"suite teardown", (String)content);
    }

    private SimpleResponse requestPage(String name) throws Exception {
        MockRequest request = new MockRequest();
        request.setResource(name);
        WikiPageResponder responder = new WikiPageResponder();
        return (SimpleResponse)responder.makeResponse(this.context, (Request)request);
    }

    public void testImportedPageIndication() throws Exception {
        WikiPage page = this.crawler.addPage(this.root, PathParser.parse((String)"SamplePage"));
        PageData data = page.getData();
        WikiImportProperty importProperty = new WikiImportProperty("blah");
        importProperty.addTo((WikiPageProperty)data.getProperties());
        page.commit(data);
        String content = this.requestPage("SamplePage").getContent();
        WikiPageResponderTest.assertSubString((String)"<body class=\"imported\">", (String)content);
    }

    public void testImportedPageIndicationNotOnRoot() throws Exception {
        WikiPage page = this.crawler.addPage(this.root, PathParser.parse((String)"SamplePage"));
        PageData data = page.getData();
        WikiImportProperty importProperty = new WikiImportProperty("blah");
        importProperty.setRoot(true);
        importProperty.addTo((WikiPageProperty)data.getProperties());
        page.commit(data);
        String content = this.requestPage("SamplePage").getContent();
        WikiPageResponderTest.assertNotSubString((String)"<body class=\"imported\">", (String)content);
    }

    public void testResponderIsSecureReadOperation() throws Exception {
        WikiPageResponder responder = new WikiPageResponder();
        WikiPageResponderTest.assertTrue((boolean)(responder instanceof SecureResponder));
        SecureOperation operation = ((SecureResponder)responder).getSecureOperation();
        WikiPageResponderTest.assertEquals(SecureReadOperation.class, operation.getClass());
    }
}

