/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.editing.AddChildPageResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import org.junit.Before;
import org.junit.Test;
import util.RegexTestCase;

public class AddChildPageResponderTest {
    private WikiPage root;
    private WikiPage childPage;
    private PageData childPageData;
    private PageCrawler crawler;
    private String childName;
    private String childContent;
    private String pagetype;
    private MockRequest request;
    private FitNesseContext context;
    private Responder responder;
    private WikiPagePath path;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"root");
        this.crawler = this.root.getPageCrawler();
        this.crawler.addPage(this.root, PathParser.parse((String)"TestPage"));
        this.childName = "ChildPage";
        this.childContent = "child content";
        this.pagetype = "";
        this.request = new MockRequest();
        this.request.setResource("TestPage");
        this.request.addInput("pageName", (Object)this.childName);
        this.request.addInput("pageContent", (Object)this.childContent);
        this.request.addInput("pageType", (Object)this.pagetype);
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.responder = new AddChildPageResponder();
        this.path = PathParser.parse((String)"TestPage.ChildPage");
    }

    @Test
    public void canGetRedirectResponse() throws Exception {
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        String body = response.getContent();
        RegexTestCase.assertEquals((String)"", (String)body);
        RegexTestCase.assertEquals((int)response.getStatus(), (int)303);
    }

    @Test
    public void childPageIsMade() throws Exception {
        String helpText = "help text";
        String suites = "tag";
        this.request.addInput("helpText", (Object)helpText);
        this.request.addInput("suites", (Object)suites);
        RegexTestCase.assertTrue((this.crawler.getPage(this.root, this.path) == null ? 1 : 0) != 0);
        this.responder.makeResponse(this.context, (Request)this.request);
        RegexTestCase.assertTrue((this.crawler.getPage(this.root, this.path) != null ? 1 : 0) != 0);
        this.getChildPage(this.childName);
        RegexTestCase.assertEquals((String)suites, (String)this.childPageData.getAttribute("Suites"));
        RegexTestCase.assertEquals((String)helpText, (String)this.childPageData.getAttribute("Help"));
    }

    @Test
    public void noPageIsMadeIfNameIsNull() throws Exception {
        this.request.addInput("pageName", (Object)"");
        RegexTestCase.assertTrue((this.crawler.getPage(this.root, this.path) == null ? 1 : 0) != 0);
        this.responder.makeResponse(this.context, (Request)this.request);
        RegexTestCase.assertTrue((this.crawler.getPage(this.root, this.path) == null ? 1 : 0) != 0);
    }

    @Test
    public void givesAInvalidNameErrorForAInvalidName() throws Exception {
        this.request = this.makeInvalidRequest("");
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        RegexTestCase.assertEquals((int)400, (int)response.getStatus());
        RegexTestCase.assertSubString((String)"Invalid Child Name", (String)response.getContent());
        this.request = this.makeInvalidRequest("hello goodbye");
        response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        RegexTestCase.assertSubString((String)"Invalid Child Name", (String)response.getContent());
        this.request = this.makeInvalidRequest("1man1mission");
        response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        RegexTestCase.assertSubString((String)"Invalid Child Name", (String)response.getContent());
        this.request = this.makeInvalidRequest("PageOne.PageTwo");
        response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        RegexTestCase.assertSubString((String)"Invalid Child Name", (String)response.getContent());
    }

    private MockRequest makeInvalidRequest(String name) {
        MockRequest request = new MockRequest();
        request.setResource("TestPage");
        request.addInput("pageName", (Object)name);
        request.addInput("pageContent", (Object)"hello");
        request.addInput("pageType", (Object)"");
        return request;
    }

    @Test
    public void withDefaultPageTypeAndPageNameForStaticThenNoAttributeShouldBeSet() throws Exception {
        this.request.addInput("pageName", (Object)"StaticPage");
        this.responder.makeResponse(this.context, (Request)this.request);
        this.getChildPage("StaticPage");
        RegexTestCase.assertFalse((boolean)this.isSuite());
        RegexTestCase.assertFalse((boolean)this.isTest());
    }

    @Test
    public void withDefaultPageTypeAndPageNameForTestTheTestAttributeShouldBeSet() throws Exception {
        this.request.addInput("pageName", (Object)"TestPage");
        this.responder.makeResponse(this.context, (Request)this.request);
        this.getChildPage("TestPage");
        RegexTestCase.assertFalse((boolean)this.isSuite());
        RegexTestCase.assertTrue((boolean)this.isTest());
    }

    @Test
    public void withDefaultPageTypeAndPageNameForSuiteTheSuiteAttributeShouldBeSet() throws Exception {
        this.request.addInput("pageName", (Object)"SuitePage");
        this.responder.makeResponse(this.context, (Request)this.request);
        this.getChildPage("SuitePage");
        RegexTestCase.assertTrue((boolean)this.isSuite());
        RegexTestCase.assertFalse((boolean)this.isTest());
    }

    private boolean isSuite() {
        return this.childPageData.hasAttribute("Suite");
    }

    @Test
    public void correctAttributeWhenNameHasTestButAttributeIsStatic() throws Exception {
        this.request.addInput("pageName", (Object)"TestChildPage");
        this.request.addInput("pageType", (Object)"Static");
        this.responder.makeResponse(this.context, (Request)this.request);
        this.getChildPage("TestChildPage");
        RegexTestCase.assertFalse((boolean)this.isTest());
        RegexTestCase.assertFalse((boolean)this.isSuite());
    }

    @Test
    public void pageTypeShouldBeTestWhenAttributeIsTest() throws Exception {
        this.request.addInput("pageType", (Object)"Test");
        this.responder.makeResponse(this.context, (Request)this.request);
        this.getChildPage(this.childName);
        RegexTestCase.assertTrue((boolean)this.isTest());
        RegexTestCase.assertFalse((boolean)this.isSuite());
    }

    @Test
    public void pageTypeShouldBeSuiteWhenAttributeIsSuite() throws Exception {
        this.request.addInput("pageType", (Object)"Suite");
        this.responder.makeResponse(this.context, (Request)this.request);
        this.getChildPage(this.childName);
        RegexTestCase.assertFalse((boolean)this.isTest());
        RegexTestCase.assertTrue((boolean)this.isSuite());
    }

    private boolean isTest() {
        return this.childPageData.hasAttribute("Test");
    }

    private void getChildPage(String childName) throws Exception {
        this.childPage = this.crawler.getPage(this.root, PathParser.parse((String)("TestPage." + childName)));
        this.childPageData = this.childPage.getData();
    }
}

