/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.components.SaveRecorder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.wiki.MockingPageCrawler;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageCrawlerDeadEndStrategy;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.Utils;
import util.TemplateUtil;

public class EditResponder
implements SecureResponder {
    public static final String CONTENT_INPUT_NAME = "pageContent";
    public static final String TIME_STAMP = "editTime";
    public static final String TICKET_ID = "ticketId";
    public static final String HELP_TEXT = "helpText";
    public static final String SUITES = "suites";
    public static final String PAGE_TYPE = "pageType";
    public static final String PAGE_NAME = "pageName";
    public static final String TEMPLATE_MAP = "templateMap";
    protected String content;
    protected WikiPage page;
    protected WikiPage root;
    protected PageData pageData;
    protected Request request;

    public Response makeResponse(FitNesseContext context, Request request) {
        boolean nonExistent = request.hasInput("nonExistent");
        return this.doMakeResponse(context, request, nonExistent);
    }

    public Response makeResponseForNonExistentPage(FitNesseContext context, Request request) {
        return this.doMakeResponse(context, request, true);
    }

    protected Response doMakeResponse(FitNesseContext context, Request request, boolean firstTimeForNewPage) {
        this.initializeResponder(context.root, request);
        SimpleResponse response = new SimpleResponse();
        String resource = request.getResource();
        WikiPagePath path = PathParser.parse((String)resource);
        PageCrawler crawler = context.root.getPageCrawler();
        if (!crawler.pageExists(this.root, path)) {
            crawler.setDeadEndStrategy((PageCrawlerDeadEndStrategy)new MockingPageCrawler());
            this.page = crawler.getPage(this.root, path);
        } else {
            this.page = crawler.getPage(this.root, path);
        }
        this.pageData = this.page.getData();
        this.content = this.createPageContent();
        String html = this.doMakeHtml(resource, context, firstTimeForNewPage);
        response.setContent(html);
        response.setMaxAge(0);
        return response;
    }

    protected void initializeResponder(WikiPage root, Request request) {
        this.root = root;
        this.request = request;
    }

    protected String createPageContent() {
        return this.pageData.getContent();
    }

    private String doMakeHtml(String resource, FitNesseContext context, boolean firstTimeForNewPage) {
        HtmlPage html = context.pageFactory.newPage();
        String title = firstTimeForNewPage ? "Page doesn't exist. Edit: " : "Edit: ";
        html.setTitle(title + resource);
        html.setPageTitle(new PageTitle(title + " Page:", PathParser.parse((String)resource), this.pageData.getAttribute("Suites")));
        html.setMainTemplate("editPage");
        this.makeEditForm(html, resource, firstTimeForNewPage, context.defaultNewPageContent);
        return html.html();
    }

    private void makeEditForm(HtmlPage html, String resource, boolean firstTimeForNewPage, String defaultNewPageContent) {
        html.put("resource", (Object)resource);
        html.put(TIME_STAMP, (Object)String.valueOf(SaveRecorder.timeStamp()));
        html.put(TICKET_ID, (Object)String.valueOf(SaveRecorder.newTicket()));
        if (this.request.hasInput("redirectToReferer") && this.request.hasHeader("Referer")) {
            String redirectUrl = this.request.getHeader("Referer").toString();
            int questionMarkIndex = redirectUrl.indexOf("?");
            if (questionMarkIndex > 0) {
                redirectUrl = redirectUrl.substring(0, questionMarkIndex);
            }
            redirectUrl = redirectUrl + "?" + this.request.getInput("redirectAction").toString();
            html.put("redirect", (Object)redirectUrl);
        }
        html.put(HELP_TEXT, (Object)this.pageData.getAttribute("Help"));
        html.put(TEMPLATE_MAP, (Object)TemplateUtil.getTemplateMap((WikiPage)this.page));
        html.put(SUITES, (Object)this.pageData.getAttribute("Suites"));
        html.put(CONTENT_INPUT_NAME, (Object)Utils.escapeHTML((String)(firstTimeForNewPage ? defaultNewPageContent : this.content)));
    }

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

