/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import util.TemplateUtil;

public class NewPageResponder
implements Responder {
    public Response makeResponse(FitNesseContext context, Request request) {
        SimpleResponse response = new SimpleResponse();
        response.setContent(this.doMakeHtml(context, request));
        return response;
    }

    private String doMakeHtml(FitNesseContext context, Request request) {
        HtmlPage html = context.pageFactory.newPage();
        html.setTitle("New page");
        html.setPageTitle(new PageTitle("New Page", PathParser.parse((String)request.getResource())));
        html.setMainTemplate("editPage");
        this.makeEditForm(html, context, request);
        return html.html();
    }

    private void makeEditForm(HtmlPage html, FitNesseContext context, Request request) {
        html.put("resource", (Object)request.getResource());
        html.put("isNewPage", (Object)true);
        html.put("helpText", (Object)"");
        html.put("templateMap", (Object)TemplateUtil.getTemplateMap((WikiPage)this.getParentWikiPage(context, request)));
        html.put("pageContent", (Object)context.defaultNewPageContent);
        if (request.hasInput("pageType")) {
            String pageType = (String)request.getInput("pageType");
            PageType.fromString((String)pageType);
            html.put("pageType", (Object)pageType);
        } else {
            html.put("pageTypes", (Object)PageData.PAGE_TYPE_ATTRIBUTES);
        }
    }

    private WikiPage getParentWikiPage(FitNesseContext context, Request request) {
        WikiPagePath parentPath = PathParser.parse((String)request.getResource());
        PageCrawler crawler = context.root.getPageCrawler();
        WikiPage page = crawler.getPage(context.root, parentPath);
        return page;
    }

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

