/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.Responder;
import fitnesse.components.SaveRecorder;
import fitnesse.http.MockRequest;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.editing.SaveResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import util.RegexTestCase;

public class SaveResponderTest {
    private WikiPage root;
    private Response response;
    public MockRequest request;
    public Responder responder;
    private PageCrawler crawler;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.crawler = this.root.getPageCrawler();
        this.request = new MockRequest();
        this.responder = new SaveResponder();
        SaveResponder.contentFilter = null;
        SaveRecorder.clear();
    }

    @After
    public void tearDown() throws Exception {
        SaveResponder.contentFilter = null;
    }

    @Test
    public void testResponse() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"ChildPage"));
        this.prepareRequest("ChildPage");
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        RegexTestCase.assertEquals((int)303, (int)response.getStatus());
        RegexTestCase.assertHasRegexp((String)"Location: ChildPage", (String)response.makeHttpHeaders());
        String newContent = this.root.getChildPage("ChildPage").getData().getContent();
        RegexTestCase.assertEquals((String)"some new content", (String)newContent);
        this.checkRecentChanges(this.root, "ChildPage");
    }

    private void prepareRequest(String pageName) {
        this.request.setResource(pageName);
        this.request.addInput("editTime", (Object)"12345");
        this.request.addInput("pageContent", (Object)"some new content");
        this.request.addInput("helpText", (Object)"some help");
        this.request.addInput("ticketId", (Object)("" + SaveRecorder.newTicket()));
    }

    @Test
    public void testResponseWithRedirect() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"ChildPage"));
        this.prepareRequest("ChildPage");
        this.request.addInput("redirect", (Object)"http://fitnesse.org:8080/SomePage");
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        RegexTestCase.assertEquals((int)303, (int)response.getStatus());
        RegexTestCase.assertHasRegexp((String)"Location: http://fitnesse.org:8080/SomePage", (String)response.makeHttpHeaders());
    }

    private void checkRecentChanges(WikiPage source, String changedPage) throws Exception {
        RegexTestCase.assertTrue((String)"RecentChanges should exist", (boolean)source.hasChildPage("RecentChanges"));
        String recentChanges = source.getChildPage("RecentChanges").getData().getContent();
        RegexTestCase.assertTrue((String)"ChildPage should be in RecentChanges", (boolean)recentChanges.contains(changedPage));
    }

    @Test
    public void testCanCreatePage() throws Exception {
        this.prepareRequest("ChildPageTwo");
        this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        RegexTestCase.assertEquals((boolean)true, (boolean)this.root.hasChildPage("ChildPageTwo"));
        String newContent = this.root.getChildPage("ChildPageTwo").getData().getContent();
        RegexTestCase.assertEquals((String)"some new content", (String)newContent);
        RegexTestCase.assertTrue((String)"RecentChanges should exist", (boolean)this.root.hasChildPage("RecentChanges"));
        this.checkRecentChanges(this.root, "ChildPageTwo");
    }

    @Test
    public void testCanCreatePageWithoutTicketIdAndEditTime() throws Exception {
        this.request.setResource("ChildPageTwo");
        this.request.addInput("pageContent", (Object)"some new content");
        this.request.addInput("helpText", (Object)"some help");
        this.request.addInput("suites", (Object)"some help");
        this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        RegexTestCase.assertEquals((boolean)true, (boolean)this.root.hasChildPage("ChildPageTwo"));
        String newContent = this.root.getChildPage("ChildPageTwo").getData().getContent();
        RegexTestCase.assertEquals((String)"some new content", (String)newContent);
        RegexTestCase.assertEquals((String)"some help", (String)this.root.getChildPage("ChildPageTwo").getData().getAttribute("Help"));
        RegexTestCase.assertTrue((String)"RecentChanges should exist", (boolean)this.root.hasChildPage("RecentChanges"));
        this.checkRecentChanges(this.root, "ChildPageTwo");
    }

    @Test
    public void testKnowsWhenToMerge() throws Exception {
        String simplePageName = "SimplePageName";
        this.createAndSaveANewPage(simplePageName);
        this.request.setResource(simplePageName);
        this.request.addInput("pageContent", (Object)"some new content");
        this.request.addInput("editTime", (Object)("" + (SaveRecorder.timeStamp() - 10000L)));
        this.request.addInput("ticketId", (Object)("" + SaveRecorder.newTicket()));
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        RegexTestCase.assertHasRegexp((String)"Merge", (String)response.getContent());
    }

    @Test
    public void testKnowWhenNotToMerge() throws Exception {
        String pageName = "NewPage";
        this.createAndSaveANewPage(pageName);
        String newContent = "some new Content work damn you!";
        this.request.setResource(pageName);
        this.request.addInput("pageContent", (Object)newContent);
        this.request.addInput("editTime", (Object)("" + SaveRecorder.timeStamp()));
        this.request.addInput("ticketId", (Object)("" + SaveRecorder.newTicket()));
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        RegexTestCase.assertEquals((int)303, (int)response.getStatus());
        this.request.addInput("pageContent", (Object)(newContent + " Ok I'm working now"));
        this.request.addInput("editTime", (Object)("" + SaveRecorder.timeStamp()));
        response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        RegexTestCase.assertEquals((int)303, (int)response.getStatus());
    }

    @Test
    public void testUsernameIsSavedInPageProperties() throws Exception {
        this.addRequestParameters();
        this.request.setCredentials("Aladdin", "open sesame");
        this.response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        String user = this.root.getChildPage("EditPage").getData().getAttribute("LastModifyingUser");
        RegexTestCase.assertEquals((String)"Aladdin", (String)user);
    }

    @Test
    public void testContentFilter() throws Exception {
        SaveResponder.contentFilter = new /* Unavailable Anonymous Inner Class!! */;
        this.crawler.addPage(this.root, PathParser.parse((String)"ChildPage"));
        this.prepareRequest("ChildPage");
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        RegexTestCase.assertEquals((int)200, (int)response.getStatus());
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(response);
        RegexTestCase.assertSubString((String)"Your changes will not be saved!", (String)sender.sentData());
    }

    private void createAndSaveANewPage(String pageName) throws Exception {
        WikiPage simplePage = this.crawler.addPage(this.root, PathParser.parse((String)pageName));
        PageData data = simplePage.getData();
        SaveRecorder.pageSaved((PageData)data, (long)0L);
        simplePage.commit(data);
    }

    private void doSimpleEdit() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"EditPage"));
        this.addRequestParameters();
        this.response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
    }

    private void addRequestParameters() {
        this.prepareRequest("EditPage");
    }

    @Test
    public void testHasVersionHeader() throws Exception {
        this.doSimpleEdit();
        RegexTestCase.assertTrue((String)"header missing", (this.response.getHeader("Previous-Version") != null ? 1 : 0) != 0);
    }
}

