/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.Responder;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.editing.SymbolicLinkResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperty;
import util.FileUtil;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class SymbolicLinkResponderTest
extends RegexTestCase {
    private WikiPage root;
    private WikiPage pageOne;
    private WikiPage pageTwo;
    private WikiPage childTwo;
    private MockRequest request;
    private Responder responder;

    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.pageOne = this.root.addChildPage("PageOne");
        this.pageOne.addChildPage("ChildOne");
        this.pageTwo = this.root.addChildPage("PageTwo");
        this.childTwo = this.pageTwo.addChildPage("ChildTwo");
        this.pageTwo.addChildPage("ChildThree");
        this.request = new MockRequest();
        this.request.setResource("PageOne");
        this.responder = new SymbolicLinkResponder();
    }

    public void tearDown() throws Exception {
        FileUtil.deleteFileSystemDirectory((String)"testDir");
    }

    public void testSubmitGoodForm() throws Exception {
        this.executeSymbolicLinkTestWith("SymLink", "PageTwo");
    }

    public void testShouldTrimSpacesOnLinkPath() throws Exception {
        this.executeSymbolicLinkTestWith("SymLink", "    PageTwo   ");
    }

    public void testShouldTrimSpacesOnLinkName() throws Exception {
        this.executeSymbolicLinkTestWith("   SymLink   ", "PageTwo");
    }

    private void executeSymbolicLinkTestWith(String linkName, String linkPath) throws Exception {
        this.request.addInput("linkName", (Object)linkName);
        this.request.addInput("linkPath", (Object)linkPath);
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        this.checkPageOneRedirectToProperties(response);
        WikiPage symLink = this.pageOne.getChildPage("SymLink");
        SymbolicLinkResponderTest.assertNotNull((Object)symLink);
        SymbolicLinkResponderTest.assertEquals(SymbolicPage.class, symLink.getClass());
    }

    public void testSubmitGoodFormToSiblingChild() throws Exception {
        this.executeSymbolicLinkTestWith("SymLink", "PageTwo.ChildTwo");
    }

    public void testSubmitGoodFormToChildSibling() throws Exception {
        this.request.setResource("PageTwo.ChildTwo");
        this.request.addInput("linkName", (Object)"SymLink");
        this.request.addInput("linkPath", (Object)"ChildThree");
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        this.checkChildTwoRedirectToProperties(response);
        WikiPage symLink = this.childTwo.getChildPage("SymLink");
        SymbolicLinkResponderTest.assertNotNull((Object)symLink);
        SymbolicLinkResponderTest.assertEquals(SymbolicPage.class, symLink.getClass());
    }

    public void testSubmitGoodFormToAbsolutePath() throws Exception {
        this.request.addInput("linkName", (Object)"SymLink");
        this.request.addInput("linkPath", (Object)".PageTwo");
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        this.checkPageOneRedirectToProperties(response);
        WikiPage symLink = this.pageOne.getChildPage("SymLink");
        SymbolicLinkResponderTest.assertNotNull((Object)symLink);
        SymbolicLinkResponderTest.assertEquals(SymbolicPage.class, symLink.getClass());
    }

    public void testSubmitGoodFormToSubChild() throws Exception {
        this.request.addInput("linkName", (Object)"SymLink");
        this.request.addInput("linkPath", (Object)">ChildOne");
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        this.checkPageOneRedirectToProperties(response);
        SymbolicPage symLink = (SymbolicPage)this.pageOne.getChildPage("SymLink");
        SymbolicLinkResponderTest.assertNotNull((Object)symLink);
        SymbolicLinkResponderTest.assertEquals(SymbolicPage.class, symLink.getClass());
    }

    public void testSubmitGoodFormToSibling() throws Exception {
        this.request.addInput("linkName", (Object)"SymTwo");
        this.request.addInput("linkPath", (Object)"PageTwo");
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        this.checkPageOneRedirectToProperties(response);
        WikiPage symLink = this.pageOne.getChildPage("SymTwo");
        SymbolicLinkResponderTest.assertNotNull((Object)symLink);
        SymbolicLinkResponderTest.assertEquals(SymbolicPage.class, symLink.getClass());
    }

    public void testSubmitGoodFormToBackwardRelative() throws Exception {
        this.request.setResource("PageTwo.ChildTwo");
        this.request.addInput("linkName", (Object)"SymLink");
        this.request.addInput("linkPath", (Object)"<PageTwo.ChildThree");
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        this.checkChildTwoRedirectToProperties(response);
        WikiPage symLink = this.childTwo.getChildPage("SymLink");
        SymbolicLinkResponderTest.assertNotNull((Object)symLink);
        SymbolicLinkResponderTest.assertEquals(SymbolicPage.class, symLink.getClass());
    }

    public void testRemoval() throws Exception {
        PageData data = this.pageOne.getData();
        WikiPageProperty symLinks = data.getProperties().set("SymbolicLinks");
        symLinks.set("SymLink", "PageTwo");
        this.pageOne.commit(data);
        SymbolicLinkResponderTest.assertNotNull((Object)this.pageOne.getChildPage("SymLink"));
        this.request.addInput("removal", (Object)"SymLink");
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        this.checkPageOneRedirectToProperties(response);
        SymbolicLinkResponderTest.assertNull((Object)this.pageOne.getChildPage("SymLink"));
    }

    public void testRename() throws Exception {
        PageData data = this.pageOne.getData();
        WikiPageProperty symLinks = data.getProperties().set("SymbolicLinks");
        symLinks.set("SymLink", "PageTwo");
        this.pageOne.commit(data);
        SymbolicLinkResponderTest.assertNotNull((Object)this.pageOne.getChildPage("SymLink"));
        this.request.addInput("rename", (Object)"SymLink");
        this.request.addInput("newname", (Object)"NewLink");
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        this.checkPageOneRedirectToProperties(response);
        SymbolicLinkResponderTest.assertNotNull((Object)this.pageOne.getChildPage("NewLink"));
    }

    public void testNoPageAtPath() throws Exception {
        this.request.addInput("linkName", (Object)"SymLink");
        this.request.addInput("linkPath", (Object)"NonExistingPage");
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        SymbolicLinkResponderTest.assertEquals((int)404, (int)response.getStatus());
        String content = ((SimpleResponse)response).getContent();
        SymbolicLinkResponderTest.assertSubString((String)"doesn't exist", (String)content);
        SymbolicLinkResponderTest.assertSubString((String)"Error Occured", (String)content);
    }

    public void testAddFailWhenPageAlreadyHasChild() throws Exception {
        this.pageOne.addChildPage("SymLink");
        this.request.addInput("linkName", (Object)"SymLink");
        this.request.addInput("linkPath", (Object)"PageTwo");
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        SymbolicLinkResponderTest.assertEquals((int)412, (int)response.getStatus());
        String content = ((SimpleResponse)response).getContent();
        SymbolicLinkResponderTest.assertSubString((String)"already has a child named SymLink", (String)content);
        SymbolicLinkResponderTest.assertSubString((String)"Error Occured", (String)content);
    }

    public void testSubmitFormForLinkToExternalRoot() throws Exception {
        FileUtil.createDir((String)"testDir");
        FileUtil.createDir((String)"testDir/ExternalRoot");
        this.request.addInput("linkName", (Object)"SymLink");
        this.request.addInput("linkPath", (Object)"file://testDir/ExternalRoot");
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        this.checkPageOneRedirectToProperties(response);
        WikiPage symLink = this.pageOne.getChildPage("SymLink");
        SymbolicLinkResponderTest.assertNotNull((Object)symLink);
        SymbolicLinkResponderTest.assertEquals(SymbolicPage.class, symLink.getClass());
        WikiPage realPage = ((SymbolicPage)symLink).getRealPage();
        SymbolicLinkResponderTest.assertEquals(FileSystemPage.class, realPage.getClass());
        SymbolicLinkResponderTest.assertEquals((String)"testDir/ExternalRoot", (String)((FileSystemPage)realPage).getFileSystemPath());
    }

    public void testSubmitFormForLinkToExternalRootThatsMissing() throws Exception {
        this.request.addInput("linkName", (Object)"SymLink");
        this.request.addInput("linkPath", (Object)"file://testDir/ExternalRoot");
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        SymbolicLinkResponderTest.assertEquals((int)404, (int)response.getStatus());
        String content = ((SimpleResponse)response).getContent();
        SymbolicLinkResponderTest.assertSubString((String)"Cannot create link to the file system path, <b>file://testDir/ExternalRoot</b>.", (String)content);
        SymbolicLinkResponderTest.assertSubString((String)"Error Occured", (String)content);
    }

    private void checkPageOneRedirectToProperties(Response response) {
        SymbolicLinkResponderTest.assertEquals((int)303, (int)response.getStatus());
        SymbolicLinkResponderTest.assertEquals((String)response.getHeader("Location"), (String)"PageOne?properties");
    }

    private void checkChildTwoRedirectToProperties(Response response) {
        SymbolicLinkResponderTest.assertEquals((int)303, (int)response.getStatus());
        SymbolicLinkResponderTest.assertEquals((String)response.getHeader("Location"), (String)"PageTwo.ChildTwo?properties");
    }
}

