/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.responders.files.RenameFileResponder;
import fitnesse.testutil.FitNesseUtil;
import java.io.File;
import junit.framework.TestCase;
import util.FileUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class RenameFileResponderTest
extends TestCase {
    private MockRequest request;
    private FitNesseContext context;

    public void setUp() {
        this.request = new MockRequest();
        this.context = FitNesseUtil.makeTestContext(null);
        FileUtil.makeDir((String)this.context.getRootPagePath());
    }

    public void tearDown() throws Exception {
        FileUtil.deleteFileSystemDirectory((String)this.context.getRootPagePath());
    }

    public void testMakeResponse() throws Exception {
        File file = new File(this.context.getRootPagePath() + "/testfile");
        RenameFileResponderTest.assertTrue((boolean)file.createNewFile());
        RenameFileResponder responder = new RenameFileResponder();
        this.request.addInput("filename", (Object)"testfile");
        this.request.addInput("newName", (Object)"newName");
        this.request.setResource("");
        Response response = responder.makeResponse(this.context, (Request)this.request);
        RenameFileResponderTest.assertFalse((boolean)file.exists());
        RenameFileResponderTest.assertTrue((boolean)new File(this.context.getRootPagePath() + "/newName").exists());
        RenameFileResponderTest.assertEquals((int)303, (int)response.getStatus());
        RenameFileResponderTest.assertEquals((String)"/", (String)response.getHeader("Location"));
    }

    public void testRenameWithTrailingSpace() throws Exception {
        File file = new File(this.context.getRootPagePath() + "/testfile");
        RenameFileResponderTest.assertTrue((boolean)file.createNewFile());
        RenameFileResponder responder = new RenameFileResponder();
        this.request.addInput("filename", (Object)"testfile");
        this.request.addInput("newName", (Object)"new Name With Space ");
        this.request.setResource("");
        responder.makeResponse(this.context, (Request)this.request);
        RenameFileResponderTest.assertFalse((boolean)file.exists());
        RenameFileResponderTest.assertTrue((boolean)new File(this.context.getRootPagePath() + "/new Name With Space").exists());
    }
}

