/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.components.ReferenceRenamer;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.refactoring.RefactorException;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperty;
import java.util.List;

public abstract class PageMovementResponder
implements SecureResponder {
    protected String oldNameOfPageToBeMoved;
    protected WikiPage oldRefactoredPage;
    protected WikiPage newParentPage;
    protected WikiPagePath newParentPath;

    protected abstract boolean getAndValidateNewParentPage(FitNesseContext var1, Request var2);

    protected abstract boolean getAndValidateRefactoringParameters(Request var1);

    protected abstract ReferenceRenamer getReferenceRenamer(FitNesseContext var1);

    protected abstract String getNewPageName();

    protected abstract String getErrorMessageHeader();

    protected abstract void execute() throws RefactorException;

    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        if (!this.getAndValidateRefactoredPage(context, request)) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        if (!this.getAndValidateNewParentPage(context, request)) {
            return this.makeErrorMessageResponder(this.newParentPath == null ? "null" : this.newParentPath.toString() + " does not exist.").makeResponse(context, request);
        }
        if (!this.getAndValidateRefactoringParameters(request)) {
            return this.makeErrorMessageResponder("").makeResponse(context, request);
        }
        if (this.targetPageExists()) {
            return this.makeErrorMessageResponder(this.makeLink(this.getNewPageName()) + " already exists").makeResponse(context, request);
        }
        if (request.hasInput("refactorReferences")) {
            this.getReferenceRenamer(context).renameReferences();
        }
        this.execute();
        SimpleResponse response = new SimpleResponse();
        response.redirect(this.createRedirectionUrl(this.newParentPage, this.getNewPageName()));
        return response;
    }

    protected boolean getAndValidateRefactoredPage(FitNesseContext context, Request request) {
        PageCrawler crawler = context.root.getPageCrawler();
        this.oldNameOfPageToBeMoved = request.getResource();
        WikiPagePath path = PathParser.parse((String)this.oldNameOfPageToBeMoved);
        this.oldRefactoredPage = crawler.getPage(context.root, path);
        return this.oldRefactoredPage != null;
    }

    private Responder makeErrorMessageResponder(String message) {
        return new ErrorResponder(this.getErrorMessageHeader() + "<br/>" + message);
    }

    private boolean targetPageExists() {
        return this.newParentPage.hasChildPage(this.getNewPageName());
    }

    protected String makeLink(String page) {
        return HtmlUtil.makeLink((String)page, (String)page).html();
    }

    protected String createRedirectionUrl(WikiPage newParent, String newName) {
        PageCrawler crawler = newParent.getPageCrawler();
        if (crawler.isRoot(newParent)) {
            return newName;
        }
        return PathParser.render((WikiPagePath)crawler.getFullPath(newParent).addNameToEnd(newName));
    }

    protected void movePage(WikiPage movedPage, WikiPage newParentPage, String pageName) throws RefactorException {
        if (this.isSymlinkedPage(movedPage)) {
            if (this.isSymlinkedPage(movedPage.getParent())) {
                throw new RefactorException("Can not move symlink page when parent page is also a symlink");
            }
            WikiPage referencedPage = ((SymbolicPage)movedPage).getRealPage();
            this.removeSymlink(movedPage);
            this.createSymlink(referencedPage, newParentPage, pageName);
        } else {
            PageData pageData = movedPage.getData();
            WikiPage targetPage = newParentPage.addChildPage(pageName);
            targetPage.commit(pageData);
            this.moveChildren(movedPage, targetPage);
            WikiPage parentOfMovedPage = movedPage.getParent();
            parentOfMovedPage.removeChildPage(movedPage.getName());
        }
    }

    protected void moveChildren(WikiPage movedPage, WikiPage newParentPage) throws RefactorException {
        List children = movedPage.getChildren();
        for (WikiPage page : children) {
            this.movePage(page, newParentPage, page.getName());
        }
    }

    private boolean isSymlinkedPage(WikiPage page) {
        return page instanceof SymbolicPage;
    }

    private void removeSymlink(WikiPage movedPage) {
        WikiPage parent = movedPage.getParent();
        PageData data = parent.getData();
        WikiPageProperty symLinks = data.getProperties().getProperty("SymbolicLinks");
        symLinks.remove(movedPage.getName());
        parent.commit(data);
    }

    private void createSymlink(WikiPage referencedPage, WikiPage newParentPage, String pageName) {
        WikiPagePath fullPath;
        PageData newParentData = newParentPage.getData();
        WikiPageProperty symLinks = newParentData.getProperties().getProperty("SymbolicLinks");
        if (this.isChildOf(referencedPage, this.oldRefactoredPage)) {
            WikiPagePath relativePath = PathParser.parse((String)this.oldRefactoredPage.getPageCrawler().getRelativeName(this.oldRefactoredPage.getParent(), referencedPage));
            fullPath = newParentPage.getPageCrawler().getFullPathOfChild(this.newParentPage, relativePath);
        } else {
            fullPath = referencedPage.getPageCrawler().getFullPath(referencedPage);
        }
        fullPath.makeAbsolute();
        symLinks.set(pageName, PathParser.render((WikiPagePath)fullPath));
        newParentPage.commit(newParentData);
    }

    private boolean isChildOf(WikiPage childPage, WikiPage parentPage) {
        PageCrawler crawler = parentPage.getPageCrawler();
        String childPath = PathParser.render((WikiPagePath)crawler.getFullPath(childPage));
        String parentPath = PathParser.render((WikiPagePath)crawler.getFullPath(parentPage));
        return childPath.startsWith(parentPath);
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

