/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.SuiteFilter;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SuiteFilterTestCase {
    private WikiPage root;
    private PageCrawler crawler;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        PageData data = this.root.getData();
        this.root.commit(data);
    }

    private WikiPage addTestPage(WikiPage page, String name, String content) throws Exception {
        WikiPage testPage = this.crawler.addPage(page, PathParser.parse((String)name), content);
        PageData data = testPage.getData();
        data.setAttribute("Test");
        testPage.commit(data);
        return testPage;
    }

    private WikiPage addSuitePage(WikiPage page, String name, String content) throws Exception {
        WikiPage suitePage = this.crawler.addPage(page, PathParser.parse((String)name), content);
        PageData data = suitePage.getData();
        data.setAttribute("Suite");
        suitePage.commit(data);
        return suitePage;
    }

    @Test
    public void testPrunesTests() throws Exception {
        SuiteFilter filter = new SuiteFilter(null, null, null, null);
        WikiPage prunedTest = this.addTestPage(this.root, "PrunedTest", "Pruned Test");
        PageData data = prunedTest.getData();
        data.setAttribute("Prune");
        prunedTest.commit(data);
        Assert.assertFalse((boolean)filter.isMatchingTest(prunedTest));
        WikiPage test = this.addTestPage(this.root, "TestPage", "Test test");
        Assert.assertTrue((boolean)filter.isMatchingTest(test));
    }

    @Test
    public void testPrunesNonTests() throws Exception {
        SuiteFilter filter = new SuiteFilter(null, null, null, null);
        Assert.assertFalse((boolean)filter.isMatchingTest(this.root));
    }

    @Test
    public void testPrunesSuites() throws Exception {
        SuiteFilter filter = new SuiteFilter(null, null, null, null);
        WikiPage prunedSuite = this.crawler.addPage(this.root, PathParser.parse((String)"MySuite"), "the suite");
        PageData data = prunedSuite.getData();
        data.setAttribute("Prune");
        data.setAttribute("Suite");
        prunedSuite.commit(data);
        Assert.assertFalse((boolean)filter.getFilterForTestsInSuite(prunedSuite).hasMatchingTests());
        Assert.assertTrue((boolean)filter.getFilterForTestsInSuite(this.root).hasMatchingTests());
    }

    @Test
    public void testTestRequiresTag() throws Exception {
        SuiteFilter filter = new SuiteFilter("good", null, null, "");
        WikiPage goodTest = this.addTestPage(this.root, "GoodTest", "Good Test");
        PageData data = goodTest.getData();
        data.setAttribute("Suites", "good");
        goodTest.commit(data);
        Assert.assertTrue((boolean)filter.isMatchingTest(goodTest));
        WikiPage notGoodTest = this.addTestPage(this.root, "NotGoodTest", "Not Good Test");
        Assert.assertFalse((boolean)filter.isMatchingTest(notGoodTest));
    }

    @Test
    public void testTestRequiresAllTagsWithIntersect() throws Exception {
        SuiteFilter filter = new SuiteFilter(null, null, "good, better", "");
        WikiPage goodTest = this.addTestPage(this.root, "GoodTest", "Good Test");
        PageData data = goodTest.getData();
        data.setAttribute("Suites", "good, better, best");
        goodTest.commit(data);
        Assert.assertTrue((boolean)filter.isMatchingTest(goodTest));
        WikiPage notGoodTest = this.addTestPage(this.root, "NotGoodTest", "Not Good Test");
        PageData data2 = notGoodTest.getData();
        data2.setAttribute("Suites", "good, bad");
        notGoodTest.commit(data2);
        Assert.assertFalse((boolean)filter.isMatchingTest(notGoodTest));
    }

    @Test
    public void testSuiteWithTag() throws Exception {
        SuiteFilter filter = new SuiteFilter("good", null, null, null);
        WikiPage goodSuite = this.crawler.addPage(this.root, PathParser.parse((String)"MySuite"), "the suite");
        PageData data = goodSuite.getData();
        data.setAttribute("Suite");
        data.setAttribute("Suites", "good");
        goodSuite.commit(data);
        WikiPage goodSuiteTest = this.addTestPage(goodSuite, "GoodTest", "Good Test");
        Assert.assertTrue((boolean)filter.getFilterForTestsInSuite(goodSuite).isMatchingTest(goodSuiteTest));
        Assert.assertFalse((boolean)filter.getFilterForTestsInSuite(this.root).isMatchingTest(goodSuiteTest));
    }

    @Test
    public void testSuiteWithTagWithIntersect() throws Exception {
        SuiteFilter filter = new SuiteFilter(null, null, "good, better", null);
        WikiPage goodSuite = this.crawler.addPage(this.root, PathParser.parse((String)"MySuite"), "the suite");
        PageData data = goodSuite.getData();
        data.setAttribute("Suite");
        data.setAttribute("Suites", "good, better");
        goodSuite.commit(data);
        WikiPage goodSuiteTest = this.addTestPage(goodSuite, "GoodTest", "Good Test");
        Assert.assertTrue((boolean)filter.getFilterForTestsInSuite(goodSuite).isMatchingTest(goodSuiteTest));
        Assert.assertFalse((boolean)filter.getFilterForTestsInSuite(this.root).isMatchingTest(goodSuiteTest));
    }

    @Test
    public void testChecksStartFilter() throws Exception {
        WikiPage bobSuite = this.addSuitePage(this.root, "BobsTests", "B tests");
        WikiPage testPage = this.addTestPage(bobSuite, "MyTest", "my test");
        SuiteFilter andyFilter = new SuiteFilter(null, null, null, "AndyTest");
        Assert.assertTrue((boolean)andyFilter.isMatchingTest(testPage));
        SuiteFilter andyFilter2 = new SuiteFilter(null, null, null, "AndyTest.TestsA.FirstTest");
        Assert.assertTrue((boolean)andyFilter2.isMatchingTest(testPage));
        SuiteFilter bobsFilter = new SuiteFilter(null, null, null, "BobsTests");
        Assert.assertTrue((boolean)bobsFilter.isMatchingTest(testPage));
        SuiteFilter sisterMatchFilter = new SuiteFilter(null, null, null, "BobsTests.CharlesTest");
        Assert.assertTrue((boolean)sisterMatchFilter.isMatchingTest(testPage));
        SuiteFilter exactMatchFilter = new SuiteFilter(null, null, null, "BobsTests.MyTest");
        Assert.assertTrue((boolean)exactMatchFilter.isMatchingTest(testPage));
        SuiteFilter tooMuchFilter = new SuiteFilter(null, null, null, "BobsTests.MyTest.AnotherTest");
        Assert.assertFalse((boolean)tooMuchFilter.isMatchingTest(testPage));
        SuiteFilter sisterNotMatchFilter = new SuiteFilter(null, null, null, "BobsTests.PaulTest.TestingFirst");
        Assert.assertFalse((boolean)sisterNotMatchFilter.isMatchingTest(testPage));
        SuiteFilter carlyFilter = new SuiteFilter(null, null, null, "ZzzsTests.CarlyFirstTest");
        Assert.assertFalse((boolean)carlyFilter.isMatchingTest(testPage));
    }

    @Test
    public void testChecksNotMatchFilterTest() throws Exception {
        SuiteFilter filter = new SuiteFilter(null, "bad", null, null);
        WikiPage failTest = this.addTestPage(this.root, "BadTest", "Bad Test");
        PageData data = failTest.getData();
        data.setAttribute("Suites", "bad");
        failTest.commit(data);
        Assert.assertFalse((boolean)filter.isMatchingTest(failTest));
        WikiPage passTest = this.addTestPage(this.root, "PassTest", "Pass Test");
        Assert.assertTrue((boolean)filter.isMatchingTest(passTest));
    }

    @Test
    public void testChecksNotMatchFilterSuite() throws Exception {
        SuiteFilter filter = new SuiteFilter(null, "bad", null, null);
        WikiPage failSuite = this.addTestPage(this.root, "FailSuite", "Bad Test");
        PageData data = failSuite.getData();
        data.setAttribute("Suites", "bad");
        data.setAttribute("Suite");
        failSuite.commit(data);
        Assert.assertFalse((boolean)filter.getFilterForTestsInSuite(failSuite).hasMatchingTests());
    }

    @Test
    public void testFilterDescription() throws Exception {
        SuiteFilter filter = new SuiteFilter("good", "bad", null, "FirstTest");
        Assert.assertEquals((Object)"matches 'good' & doesn't match 'bad' & starts with test 'FirstTest'", (Object)filter.toString());
    }

    @Test
    public void testFilterDescriptionWithIntersect() throws Exception {
        SuiteFilter filter = new SuiteFilter(null, "bad", "good, better", "FirstTest");
        Assert.assertEquals((Object)"matches all of 'good, better' & doesn't match 'bad' & starts with test 'FirstTest'", (Object)filter.toString());
    }
}

