/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.responders.run.SuiteResponder;
import fitnesse.responders.run.TestResponderTest;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.fit.FitSocketReceiver;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.Clock;
import util.DateAlteringClock;
import util.DateTimeUtil;
import util.RegexTestCase;
import util.XmlUtil;

public class SuiteResponderTest {
    private static final String TEST_TIME = "12/5/2008 01:19:00";
    private MockRequest request;
    private SuiteResponder responder;
    private WikiPage root;
    private WikiPage suite;
    private FitNesseContext context;
    private FitSocketReceiver receiver;
    private PageCrawler crawler;
    private String suitePageName;
    private final String fitPassFixture = "|!-fitnesse.testutil.PassFixture-!|\n";
    private final String fitFailFixture = "|!-fitnesse.testutil.FailFixture-!|\n";
    private final String simpleSlimDecisionTable = "!define TEST_SYSTEM {slim}\n|!-DT:fitnesse.slim.test.TestSlim-!|\n|string|get string arg?|\n|wow|wow|\n";

    @Before
    public void setUp() throws Exception {
        this.suitePageName = "SuitePage";
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        PageData data = this.root.getData();
        data.setContent(this.classpathWidgets());
        this.root.commit(data);
        this.suite = this.crawler.addPage(this.root, PathParser.parse((String)this.suitePageName), "This is the test suite\n");
        this.addTestToSuite("TestOne", "|!-fitnesse.testutil.PassFixture-!|\n");
        this.request = new MockRequest();
        this.request.setResource(this.suitePageName);
        this.responder = new SuiteResponder();
        this.responder.setFastTest(true);
        this.responder.page = this.suite;
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.receiver = new FitSocketReceiver(0, this.context.socketDealer);
        new DateAlteringClock(DateTimeUtil.getDateFromString((String)TEST_TIME)).freeze();
    }

    @After
    public void restoreDefaultClock() {
        Clock.restoreDefaultClock();
    }

    private WikiPage addTestToSuite(String name, String content) throws Exception {
        return this.addTestPage(this.suite, name, content);
    }

    private WikiPage addTestPage(WikiPage page, String name, String content) throws Exception {
        WikiPage testPage = this.crawler.addPage(page, PathParser.parse((String)name), content);
        PageData data = testPage.getData();
        data.setAttribute("Test");
        testPage.commit(data);
        return testPage;
    }

    @After
    public void tearDown() throws Exception {
        this.receiver.close();
        FitNesseUtil.destroyTestContext();
    }

    private String runSuite() throws Exception {
        int port = this.receiver.receiveSocket();
        FitNesseContext localContext = FitNesseUtil.makeTestContext((FitNesseContext)this.context, (int)port);
        Response response = this.responder.makeResponse(localContext, (Request)this.request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(response);
        String results = sender.sentData();
        return results;
    }

    @Test
    public void testWithOneTest() throws Exception {
        String results = this.runSuite();
        RegexTestCase.assertSubString((String)"href=\\\"#TestOne1\\\"", (String)results);
        RegexTestCase.assertSubString((String)"1 right", (String)results);
        RegexTestCase.assertSubString((String)"id=\"TestOne1\"", (String)results);
        RegexTestCase.assertSubString((String)" href=\"SuitePage.TestOne\"", (String)results);
        RegexTestCase.assertSubString((String)"PassFixture", (String)results);
    }

    @Test
    public void testPageWithXref() throws Exception {
        PageData data = this.suite.getData();
        data.setContent("!see XrefOne\r\n!see XrefTwo\n!see XrefThree\n");
        this.suite.commit(data);
        this.addTestPage(this.root, "XrefOne", "|!-fitnesse.testutil.PassFixture-!|\n");
        this.addTestPage(this.root, "XrefTwo", "|!-fitnesse.testutil.PassFixture-!|\n");
        String results = this.runSuite();
        RegexTestCase.assertSubString((String)"href=\\\"#XrefOne2\\\"", (String)results);
        RegexTestCase.assertSubString((String)"href=\\\"#XrefTwo3\\\"", (String)results);
    }

    @Test
    public void testWithTwoTests() throws Exception {
        this.addTestToSuite("TestTwo", "|!-fitnesse.testutil.FailFixture-!|\n\n|!-fitnesse.testutil.FailFixture-!|\n");
        String results = this.runSuite();
        RegexTestCase.assertSubString((String)"href=\\\"#TestOne1\\\"", (String)results);
        RegexTestCase.assertSubString((String)"href=\\\"#TestTwo2\\\"", (String)results);
        RegexTestCase.assertSubString((String)"1 right", (String)results);
        RegexTestCase.assertSubString((String)"2 wrong", (String)results);
        RegexTestCase.assertSubString((String)"id=\"TestOne1\"", (String)results);
        RegexTestCase.assertSubString((String)"id=\"TestTwo2\"", (String)results);
        RegexTestCase.assertSubString((String)"PassFixture", (String)results);
        RegexTestCase.assertSubString((String)"FailFixture", (String)results);
    }

    @Test
    public void testWithPrunedPage() throws Exception {
        WikiPage pageTwo = this.addTestToSuite("TestTwo", "|!-fitnesse.testutil.FailFixture-!|\n\n|!-fitnesse.testutil.FailFixture-!|\n");
        PageData data = pageTwo.getData();
        data.setAttribute("Prune");
        pageTwo.commit(data);
        String results = this.runSuite();
        RegexTestCase.assertSubString((String)"href=\\\"#TestOne1\\\"", (String)results);
        RegexTestCase.assertNotSubString((String)"href=\\\"#TestTwo2\\\"", (String)results);
        RegexTestCase.assertSubString((String)"1 right", (String)results);
        RegexTestCase.assertSubString((String)"0 wrong", (String)results);
        RegexTestCase.assertSubString((String)"id=\"TestOne1\"", (String)results);
        RegexTestCase.assertNotSubString((String)"id=\"TestTwo2\"", (String)results);
        RegexTestCase.assertSubString((String)"PassFixture", (String)results);
        RegexTestCase.assertNotSubString((String)"FailFixture", (String)results);
    }

    @Test
    public void testSuiteWithEmptyPage() throws Exception {
        this.suite = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteWithEmptyPage"), "This is the empty page test suite\n");
        this.addTestPage(this.suite, "TestThatIsEmpty", "");
        this.request.setResource("SuiteWithEmptyPage");
        this.runSuite();
        WikiPagePath errorLogPath = PathParser.parse((String)"ErrorLogs.SuiteWithEmptyPage");
        WikiPage errorLog = this.crawler.getPage(this.root, errorLogPath);
        PageData data = errorLog.getData();
        String errorLogContent = data.getContent();
        RegexTestCase.assertNotSubString((String)"Exception", (String)errorLogContent);
    }

    @Test
    public void testSuiteWithOneTestWithoutTable() throws Exception {
        this.addTestToSuite("TestWithoutTable", "This test has not table");
        this.addTestToSuite("TestTwo", "|!-fitnesse.testutil.PassFixture-!|\n");
        this.addTestToSuite("TestThree", "|!-fitnesse.testutil.PassFixture-!|\n");
        String results = this.runSuite();
        RegexTestCase.assertSubString((String)"TestOne", (String)results);
        RegexTestCase.assertSubString((String)"TestTwo", (String)results);
        RegexTestCase.assertSubString((String)"TestThree", (String)results);
        RegexTestCase.assertSubString((String)"TestWithoutTable", (String)results);
    }

    @Test
    public void testExitCodeHeader() throws Exception {
        String results = this.runSuite();
        RegexTestCase.assertSubString((String)"Exit-Code: 0", (String)results);
    }

    @Test
    public void exitCodeHeaderIsErrorCount() throws Exception {
        this.addTestToSuite("TestFailingTest", "|!-fitnesse.testutil.FailFixture-!|\n");
        String results = this.runSuite();
        RegexTestCase.assertSubString((String)"Exit-Code: 1", (String)results);
    }

    @Test
    public void testNoExitCodeHeaderIfNotChunked() throws Exception {
        this.responder.turnOffChunking();
        String results = this.runSuite();
        RegexTestCase.assertFalse((boolean)results.contains("Exit-Code: 0"));
    }

    @Test
    public void testExecutionStatusAppears() throws Exception {
        String results = this.runSuite();
        RegexTestCase.assertHasRegexp((String)"Tests Executed OK", (String)results);
    }

    @Test
    public void testTestSummaryInformationIncludesPageSummary() throws Exception {
        String results = this.runSuite();
        RegexTestCase.assertHasRegexp((String)".*?Test Pages:.*?&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.*?Assertions:.*?", (String)results);
    }

    @Test
    public void testFormatTestSummaryInformation() throws Exception {
        String results = this.runSuite();
        RegexTestCase.assertHasRegexp((String)".*?<strong>Test Pages:</strong>.*?<strong>Assertions:</strong>.*?", (String)results);
    }

    private String classpathWidgets() {
        return "!path classes\n!path lib/dummy.jar\n";
    }

    @Test
    public void testNonMatchingSuiteFilter() throws Exception {
        this.addTestPagesWithSuiteProperty();
        this.request.setQueryString("suiteFilter=xxx");
        String results = this.runSuite();
        RegexTestCase.assertDoesntHaveRegexp((String)".*href=\\\"#TestOne\\\".*", (String)results);
        RegexTestCase.assertDoesntHaveRegexp((String)".*href=\\\"#TestTwo\\\".*", (String)results);
        RegexTestCase.assertDoesntHaveRegexp((String)".*href=\\\"#TestThree\\\".*", (String)results);
    }

    @Test
    public void testSimpleMatchingSuiteQuery() throws Exception {
        this.addTestPagesWithSuiteProperty();
        this.request.setQueryString("suiteFilter=foo");
        String results = this.runSuite();
        RegexTestCase.assertDoesntHaveRegexp((String)".*href=\\\"#TestOne.*", (String)results);
        RegexTestCase.assertSubString((String)"href=\\\"#TestTwo1\\\"", (String)results);
        RegexTestCase.assertDoesntHaveRegexp((String)".*href=\\\"#TestThree.*", (String)results);
    }

    @Test
    public void testSecondMatchingSuiteQuery() throws Exception {
        this.addTestPagesWithSuiteProperty();
        this.request.setQueryString("suiteFilter=smoke");
        String results = this.runSuite();
        RegexTestCase.assertDoesntHaveRegexp((String)".*href=\\\"#TestOne.*", (String)results);
        RegexTestCase.assertDoesntHaveRegexp((String)".*href=\\\"#TestTwo.*", (String)results);
        RegexTestCase.assertSubString((String)"href=\\\"#TestThree1\\\"", (String)results);
    }

    @Test
    public void multipleSuiteQuery() throws Exception {
        this.addTestPagesWithSuiteProperty();
        this.request.setQueryString("suiteFilter=smoke,foo");
        String results = this.runSuite();
        RegexTestCase.assertDoesntHaveRegexp((String)"#TestOne", (String)results);
        RegexTestCase.assertHasRegexp((String)"#TestTwo", (String)results);
        RegexTestCase.assertHasRegexp((String)"#TestThree", (String)results);
    }

    @Test
    public void exculdeSuiteQuery() throws Exception {
        this.addTestPagesWithSuiteProperty();
        this.request.setQueryString("excludeSuiteFilter=foo");
        String results = this.runSuite();
        RegexTestCase.assertHasRegexp((String)"#TestOne", (String)results);
        RegexTestCase.assertDoesntHaveRegexp((String)"#TestTwo", (String)results);
        RegexTestCase.assertHasRegexp((String)"#TestThree", (String)results);
    }

    @Test
    public void testFirstTest() throws Exception {
        this.addTestPagesWithSuiteProperty();
        this.request.setQueryString("firstTest=TestThree");
        String results = this.runSuite();
        RegexTestCase.assertDoesntHaveRegexp((String)"#TestOne", (String)results);
        RegexTestCase.assertHasRegexp((String)"#TestTwo", (String)results);
        RegexTestCase.assertHasRegexp((String)"#TestThree", (String)results);
    }

    @Test
    public void testFirstTestWholePath() throws Exception {
        this.addTestPagesWithSuiteProperty();
        this.request.setQueryString("firstTest=SuitePage.TestThree");
        String results = this.runSuite();
        RegexTestCase.assertDoesntHaveRegexp((String)"#TestOne", (String)results);
        RegexTestCase.assertHasRegexp((String)"#TestTwo", (String)results);
        RegexTestCase.assertHasRegexp((String)"#TestThree", (String)results);
    }

    @Test
    public void testTagsShouldBeInheritedFromSuite() throws Exception {
        PageData suiteData = this.suite.getData();
        suiteData.setAttribute("Suites", "tag");
        this.suite.commit(suiteData);
        this.addTestToSuite("TestInheritsTag", "|!-fitnesse.testutil.PassFixture-!|\n");
        this.request.setQueryString("suiteFilter=tag");
        String results = this.runSuite();
        RegexTestCase.assertHasRegexp((String)"#TestInheritsTag", (String)results);
    }

    private void addTestPagesWithSuiteProperty() throws Exception {
        WikiPage test2 = this.addTestToSuite("TestTwo", "|!-fitnesse.testutil.PassFixture-!|\n");
        WikiPage test3 = this.addTestToSuite("TestThree", "|!-fitnesse.testutil.PassFixture-!|\n");
        PageData data2 = test2.getData();
        PageData data3 = test3.getData();
        data2.setAttribute("Suites", "foo");
        data3.setAttribute("Suites", "bar, smoke");
        test2.commit(data2);
        test3.commit(data3);
    }

    @Test
    public void testCanMixSlimAndFitTests() throws Exception {
        this.addTestToSuite("SlimTest", "!define TEST_SYSTEM {slim}\n|!-DT:fitnesse.slim.test.TestSlim-!|\n|string|get string arg?|\n|wow|wow|\n");
        String results = this.runSuite();
        RegexTestCase.assertHasRegexp((String)"<td>fitnesse.testutil.PassFixture</td>", (String)results);
        RegexTestCase.assertHasRegexp((String)"<td><span class=\"pass\">wow</span></td>", (String)results);
        RegexTestCase.assertHasRegexp((String)"<h3>fit:fit.FitServer</h3>", (String)results);
        RegexTestCase.assertHasRegexp((String)"<h3>slim:fitnesse.slim.SlimService", (String)results);
    }

    @Test
    public void xmlFormat() throws Exception {
        this.responder.turnOffChunking();
        this.request.addInput("format", (Object)"xml");
        this.addTestToSuite("SlimTest", "!define TEST_SYSTEM {slim}\n|!-DT:fitnesse.slim.test.TestSlim-!|\n|string|get string arg?|\n|wow|wow|\n");
        String results = this.runSuite();
        Document testResultsDocument = TestResponderTest.XmlTestUtilities.getXmlDocumentFromResults((String)results);
        Element testResultsElement = testResultsDocument.getDocumentElement();
        Assert.assertEquals((Object)"testResults", (Object)testResultsElement.getNodeName());
        NodeList resultList = testResultsElement.getElementsByTagName("result");
        Assert.assertEquals((long)2L, (long)resultList.getLength());
        for (int elementIndex = 0; elementIndex < 2; ++elementIndex) {
            Element testResult = (Element)resultList.item(elementIndex);
            String pageName = XmlUtil.getTextValue((Element)testResult, (String)"relativePageName");
            RegexTestCase.assertSubString((String)(pageName + "?pageHistory&resultDate="), (String)XmlUtil.getTextValue((Element)testResult, (String)"pageHistoryLink"));
            if ("SlimTest".equals(pageName)) {
                TestResponderTest.XmlTestUtilities.assertCounts((Element)testResult, (String)"1", (String)"0", (String)"0", (String)"0");
                continue;
            }
            if ("TestOne".equals(pageName)) {
                TestResponderTest.XmlTestUtilities.assertCounts((Element)testResult, (String)"1", (String)"0", (String)"0", (String)"0");
                continue;
            }
            Assert.fail((String)pageName);
        }
        Element finalCounts = XmlUtil.getElementByTagName((Element)testResultsElement, (String)"finalCounts");
        TestResponderTest.XmlTestUtilities.assertCounts((Element)finalCounts, (String)"2", (String)"0", (String)"0", (String)"0");
    }

    @Test
    public void normalSuiteRunWithThreePassingTestsProducesSuiteResultFile() throws Exception {
        File xmlResultsFile = this.expectedXmlResultsFile();
        if (xmlResultsFile.exists()) {
            xmlResultsFile.delete();
        }
        this.addTestToSuite("SlimTestOne", "!define TEST_SYSTEM {slim}\n|!-DT:fitnesse.slim.test.TestSlim-!|\n|string|get string arg?|\n|wow|wow|\n");
        this.addTestToSuite("SlimTestTwo", "!define TEST_SYSTEM {slim}\n|!-DT:fitnesse.slim.test.TestSlim-!|\n|string|get string arg?|\n|wow|wow|\n");
        this.runSuite();
        FileInputStream xmlResultsStream = new FileInputStream(xmlResultsFile);
        XmlUtil.newDocument((InputStream)xmlResultsStream);
        xmlResultsStream.close();
        xmlResultsFile.delete();
    }

    @Test
    public void NoHistory_avoidsProducingSuiteResultFile() throws Exception {
        File xmlResultsFile = this.expectedXmlResultsFile();
        if (xmlResultsFile.exists()) {
            xmlResultsFile.delete();
        }
        this.request.addInput("nohistory", (Object)"true");
        this.addTestToSuite("SlimTestOne", "!define TEST_SYSTEM {slim}\n|!-DT:fitnesse.slim.test.TestSlim-!|\n|string|get string arg?|\n|wow|wow|\n");
        this.addTestToSuite("SlimTestTwo", "!define TEST_SYSTEM {slim}\n|!-DT:fitnesse.slim.test.TestSlim-!|\n|string|get string arg?|\n|wow|wow|\n");
        this.runSuite();
        RegexTestCase.assertFalse((boolean)xmlResultsFile.exists());
    }

    @Test
    public void Includehtml_producesHTMLResultsInXMLSuite() throws Exception {
        this.request.addInput("format", (Object)"xml");
        this.request.addInput("includehtml", (Object)"true");
        this.addTestToSuite("SlimTestOne", "!define TEST_SYSTEM {slim}\n|!-DT:fitnesse.slim.test.TestSlim-!|\n|string|get string arg?|\n|wow|wow|\n");
        this.addTestToSuite("SlimTestTwo", "!define TEST_SYSTEM {slim}\n|!-DT:fitnesse.slim.test.TestSlim-!|\n|string|get string arg?|\n|wow|wow|\n");
        String results = this.runSuite();
        RegexTestCase.assertSubString((String)"<content>", (String)results);
    }

    private File expectedXmlResultsFile() {
        TestSummary counts = new TestSummary(3, 0, 0, 0);
        String resultsFileName = String.format("%s/SuitePage/20081205011900_%d_%d_%d_%d.xml", this.context.getTestHistoryDirectory(), counts.getRight(), counts.getWrong(), counts.getIgnores(), counts.getExceptions());
        File xmlResultsFile = new File(resultsFileName);
        return xmlResultsFile;
    }

    @Test
    public void normalSuiteRunProducesIndivualTestHistoryFile() throws Exception {
        TestSummary counts = new TestSummary(1, 0, 0, 0);
        String resultsFileName = String.format("%s/SuitePage.SlimTest/20081205011900_%d_%d_%d_%d.xml", this.context.getTestHistoryDirectory(), counts.getRight(), counts.getWrong(), counts.getIgnores(), counts.getExceptions());
        File xmlResultsFile = new File(resultsFileName);
        if (xmlResultsFile.exists()) {
            xmlResultsFile.delete();
        }
        this.addTestToSuite("SlimTest", "!define TEST_SYSTEM {slim}\n|!-DT:fitnesse.slim.test.TestSlim-!|\n|string|get string arg?|\n|wow|wow|\n");
        this.runSuite();
        Assert.assertTrue((String)resultsFileName, (boolean)xmlResultsFile.exists());
        FileInputStream xmlResultsStream = new FileInputStream(xmlResultsFile);
        XmlUtil.newDocument((InputStream)xmlResultsStream);
        xmlResultsStream.close();
        xmlResultsFile.delete();
    }

    @Test
    public void exitCodeHeaderIsErrorCountForXml() throws Exception {
        this.request.addInput("format", (Object)"xml");
        this.addTestToSuite("TestFailingTest", "|!-fitnesse.testutil.FailFixture-!|\n");
        String results = this.runSuite();
        RegexTestCase.assertSubString((String)"Exit-Code: 1", (String)results);
    }
}

