/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.responders.run.SuiteSpecificationRunner;
import fitnesse.testsystems.slim.HtmlTable;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.Table;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SuiteSpecificationRunnerTest {
    private MockRequest request;
    private SuiteSpecificationRunner runner;
    private WikiPage root;
    private FitNesseContext context;
    private PageCrawler crawler;
    private String suitePageName;

    @Before
    public void setUp() throws Exception {
        this.suitePageName = "SuitePage";
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.crawler.addPage(this.root, PathParser.parse((String)"TestPageOne"), "TestPageOne has some testing content and a child");
        WikiPage child = this.crawler.addPage(this.root, PathParser.parse((String)"TestPageOne.ChildPage"), "ChildPage is a child of TestPageOne");
        PageData data = child.getData();
        data.setAttribute("Test");
        child.commit(data);
        this.crawler.addPage(this.root, PathParser.parse((String)"TestPageTwo"), "TestPageTwo has a bit of content too");
        this.request = new MockRequest();
        this.request.setResource(this.suitePageName);
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.runner = new SuiteSpecificationRunner(this.root);
    }

    @Test
    public void shouldBeAbleToGetAListOfTestPagesGivenATitleAndRootPage() throws Exception {
        this.runner.titleRegEx = "Test";
        this.runner.findPageMatches();
        Assert.assertEquals((long)2L, (long)this.runner.testPageList.size());
    }

    @Test
    public void shouldBeAbleToGetAListOfTestPagesGivenAContentAndRootPage() throws Exception {
        this.runner.contentRegEx = "child";
        this.runner.findPageMatches();
        Assert.assertEquals((long)2L, (long)this.runner.testPageList.size());
    }

    @Test
    public void shouldNotGetAPageMoreThanOnce() throws Exception {
        this.runner.titleRegEx = "Test";
        this.runner.findPageMatches();
        Assert.assertEquals((long)2L, (long)this.runner.testPageList.size());
        this.runner.titleRegEx = "";
        this.runner.contentRegEx = "child";
        this.runner.findPageMatches();
        Assert.assertEquals((long)3L, (long)this.runner.testPageList.size());
    }

    @Test
    public void canSeeIfItIsASpecifcationsTable() throws Exception {
        String page = "<table><tr><td>Suite</td></tr><tr><td>Page</td><td>TestPageOne</td></tr><tr><td></td></tr></table>";
        HtmlTableScanner scanner = new HtmlTableScanner(page);
        HtmlTable table = scanner.getTable(0);
        Assert.assertTrue((boolean)SuiteSpecificationRunner.isASuiteSpecificationsTable((Table)table));
        page = "<table><tr><td>no suite</td></tr><tr><td>Page</td><td>TestPageOne</td></tr></table>";
        scanner = new HtmlTableScanner(page);
        table = scanner.getTable(0);
        Assert.assertFalse((boolean)SuiteSpecificationRunner.isASuiteSpecificationsTable((Table)table));
    }

    @Test
    public void cannTellIfItIsASuiteSpecificationsPage() throws Exception {
        String page = "<table><tr><td>Suite</td></tr><tr><td>Page</td><td>TestPageOne</td></tr><tr><td></td></tr></table>";
        Assert.assertTrue((boolean)SuiteSpecificationRunner.isASuiteSpecificationsPage((String)page));
        page = "<table><tr><td>Suite</td></tr><tr><td>Page</td><td>TestPageOne</td></tr></table>";
        Assert.assertFalse((boolean)SuiteSpecificationRunner.isASuiteSpecificationsPage((String)page));
    }

    @Test
    public void shouldBeAbleToParseASmallTableAndGetThePageName() throws Exception {
        String page = "<table><tr><td>Suite</td></tr><tr><td>Page</td><td>TestPageOne</td></tr><tr><td></td></tr></table>";
        HtmlTableScanner scanner = new HtmlTableScanner(page);
        HtmlTable table = scanner.getTable(0);
        Assert.assertTrue((boolean)this.runner.getImportantTableInformation((Table)table));
        Assert.assertEquals((Object)"TestPageOne", (Object)this.runner.searchRoot.getName());
        Assert.assertEquals((long)0L, (long)this.runner.testPageList.size());
    }

    @Test
    public void gettingTableContentShouldFailIfPageHasTablesWithWrongFormat() throws Exception {
        String page = "<table>badTable</table>";
        Assert.assertFalse((boolean)this.runner.getPageListFromPageContent(page));
        page = "<table><tr><td>ThisTableIsTooSmall</td></tr></table>";
        Assert.assertFalse((boolean)this.runner.getPageListFromPageContent(page));
        page = "<table><tr><td>NotASuite</td></tr><tr><td>But it is</td><td>The right Size</td></tr><tr><td></td></tr></table>";
        Assert.assertFalse((boolean)this.runner.getPageListFromPageContent(page));
    }

    @Test
    public void shouldBeAbleToGetTheTitleRegExFromATable() throws Exception {
        String page = "<table><tr><td>Suite</td></tr><tr><td>Page</td><td>TestPageOne</td></tr><tr><td>Title</td><td>ChildPage</td></tr></table>";
        HtmlTableScanner scanner = new HtmlTableScanner(page);
        HtmlTable table = scanner.getTable(0);
        Assert.assertTrue((boolean)this.runner.getImportantTableInformation((Table)table));
        Assert.assertEquals((Object)"TestPageOne", (Object)this.runner.searchRoot.getName());
        Assert.assertEquals((Object)"ChildPage", (Object)this.runner.titleRegEx);
    }

    @Test
    public void shouldBeAbleToGetTheContentRegExFromTable() throws Exception {
        String page = "<table><tr><td>Suite</td></tr><tr><td>Page</td><td>TestPageOne</td></tr><tr><td>Content</td><td>has.*content</td></tr></table>";
        HtmlTableScanner scanner = new HtmlTableScanner(page);
        HtmlTable table = scanner.getTable(0);
        Assert.assertTrue((boolean)this.runner.getImportantTableInformation((Table)table));
        Assert.assertEquals((Object)"has.*content", (Object)this.runner.contentRegEx);
    }

    @Test
    public void shouldGetPagesFromPageContent() throws Exception {
        String page = "<table><tr><td>Suite</td></tr><tr><td>Title</td><td>Test</td></tr><tr><td>Content</td><td>has.*content</td></tr></table>";
        Assert.assertTrue((boolean)this.runner.getPageListFromPageContent(page));
        Assert.assertEquals((long)2L, (long)this.runner.testPageList.size());
    }

    @Test
    public void canGetPagesFromMultipleTables() throws Exception {
        String page = "<table><tr><td>Suite</td></tr><tr><td>Title</td><td>Test</td></tr><tr><td></td><td></td></tr></table>";
        page = page + "<table><tr><td>Suite</td></tr><tr><td>Content</td><td>child</td></tr><tr><td></td><td></td></tr></table>";
        Assert.assertTrue((boolean)this.runner.getPageListFromPageContent(page));
        Assert.assertEquals((long)3L, (long)this.runner.testPageList.size());
    }

    @Test
    public void shouldntIncludeSuitesInThePageList() throws Exception {
        WikiPage testSuitePage = this.crawler.addPage(this.root, PathParser.parse((String)"SuitePageOne"));
        PageData data = testSuitePage.getData();
        data.setAttribute("Suite");
        testSuitePage.commit(data);
        String page = "<table><tr><td>Suite</td></tr><tr><td>Title</td><td>One</td></tr><tr><td>Content</td><td></td></tr></table>";
        Assert.assertTrue((boolean)this.runner.getPageListFromPageContent(page));
        Assert.assertEquals((long)1L, (long)this.runner.testPageList.size());
    }
}

