/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.ExecutionReport;
import fitnesse.responders.run.TestExecutionReport;
import fitnesse.testsystems.TestSummary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import util.XmlUtil;

public class TestExecutionReport
extends ExecutionReport {
    public List<TestResult> results = new ArrayList();

    public TestExecutionReport() {
    }

    public TestExecutionReport(InputStream input) throws IOException, SAXException {
        this.xmlDoc = XmlUtil.newDocument((InputStream)input);
        this.unpackXml();
    }

    public TestExecutionReport(String string) throws IOException, SAXException {
        this.xmlDoc = XmlUtil.newDocument((String)string);
        this.unpackXml();
    }

    public TestExecutionReport(Document xmlDocument) {
        super(xmlDocument);
        this.unpackXml();
    }

    public TestExecutionReport read(File file) throws IOException, SAXException {
        this.xmlDoc = XmlUtil.newDocument((File)file);
        this.unpackXml();
        return this;
    }

    protected void unpackResults(Element testResults) {
        NodeList xmlResults = testResults.getElementsByTagName("result");
        for (int resultIndex = 0; resultIndex < xmlResults.getLength(); ++resultIndex) {
            this.unpackResult(xmlResults, resultIndex);
        }
    }

    private void unpackResult(NodeList xmlResults, int resultIndex) {
        Element xmlResult = (Element)xmlResults.item(resultIndex);
        TestResult result = new TestResult();
        this.results.add(result);
        result.content = XmlUtil.getTextValue((Element)xmlResult, (String)"content");
        result.right = XmlUtil.getTextValue((Element)xmlResult, (String)"right");
        result.wrong = XmlUtil.getTextValue((Element)xmlResult, (String)"wrong");
        result.ignores = XmlUtil.getTextValue((Element)xmlResult, (String)"ignores");
        result.exceptions = XmlUtil.getTextValue((Element)xmlResult, (String)"exceptions");
        result.relativePageName = XmlUtil.getTextValue((Element)xmlResult, (String)"relativePageName");
        result.tags = XmlUtil.getTextValue((Element)xmlResult, (String)"tags");
        result.runTimeInMillis = XmlUtil.getTextValue((Element)xmlResult, (String)"runTimeInMillis");
        this.unpackTables(xmlResult, result);
        Element xmlInstructions = XmlUtil.getElementByTagName((Element)xmlResult, (String)"instructions");
        if (xmlInstructions != null) {
            this.unpackInstructions(result, xmlInstructions);
        }
    }

    private void unpackInstructions(TestResult result, Element xmlInstructions) {
        NodeList xmlInstructionResults = xmlInstructions.getElementsByTagName("instructionResult");
        for (int instructionIndex = 0; instructionIndex < xmlInstructionResults.getLength(); ++instructionIndex) {
            Element instructionElement = (Element)xmlInstructionResults.item(instructionIndex);
            String instruction = XmlUtil.getTextValue((Element)instructionElement, (String)"instruction");
            String slimResult = XmlUtil.getTextValue((Element)instructionElement, (String)"slimResult");
            InstructionResult instructionResult = new InstructionResult();
            instructionResult.instruction = instruction;
            instructionResult.slimResult = slimResult;
            result.instructions.add(instructionResult);
            this.unpackExpectations(instructionElement, instructionResult);
        }
    }

    private void unpackExpectations(Element instructionElement, InstructionResult instructionResult) {
        NodeList xmlExpectations = instructionElement.getElementsByTagName("expectation");
        for (int expectationIndex = 0; expectationIndex < xmlExpectations.getLength(); ++expectationIndex) {
            Element expectationElement = (Element)xmlExpectations.item(expectationIndex);
            Expectation expectation = new Expectation();
            instructionResult.addExpectation(expectation);
            expectation.status = XmlUtil.getTextValue((Element)expectationElement, (String)"status");
            expectation.instructionId = XmlUtil.getTextValue((Element)expectationElement, (String)"instructionId");
            expectation.col = XmlUtil.getTextValue((Element)expectationElement, (String)"col");
            expectation.row = XmlUtil.getTextValue((Element)expectationElement, (String)"row");
            expectation.type = XmlUtil.getTextValue((Element)expectationElement, (String)"type");
            expectation.actual = XmlUtil.getTextValue((Element)expectationElement, (String)"actual");
            expectation.expected = XmlUtil.getTextValue((Element)expectationElement, (String)"expected");
            expectation.evaluationMessage = XmlUtil.getTextValue((Element)expectationElement, (String)"evaluationMessage");
        }
    }

    private void unpackTables(Element xmlResult, TestResult result) {
        NodeList tables = xmlResult.getElementsByTagName("tables");
        for (int tableIndex = 0; tableIndex < tables.getLength(); ++tableIndex) {
            Element xmlTable = (Element)tables.item(tableIndex);
            String tableName = XmlUtil.getTextValue((Element)xmlTable, (String)"name");
            Table table = new Table(tableName);
            result.tables.add(table);
            this.unpackTable(xmlTable, table);
        }
    }

    private void unpackTable(Element xmlTable, Table table) {
        NodeList xmlRows = xmlTable.getElementsByTagName("row");
        for (int rowIndex = 0; rowIndex < xmlRows.getLength(); ++rowIndex) {
            Element xmlRow = (Element)xmlRows.item(rowIndex);
            this.unpackRow(table, xmlRow);
        }
    }

    private void unpackRow(Table table, Element xmlRow) {
        Row row = new Row();
        table.add((Object)row);
        NodeList xmlCols = xmlRow.getElementsByTagName("col");
        for (int colIndex = 0; colIndex < xmlCols.getLength(); ++colIndex) {
            Element xmlCol = (Element)xmlCols.item(colIndex);
            String colText = XmlUtil.getElementText((Element)xmlCol);
            row.add((Object)colText);
        }
    }

    public List<TestResult> getResults() {
        return this.results;
    }

    public void toXml(Writer writer, VelocityEngine velocityEngine) {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("response", (Object)this);
        Template template = velocityEngine.getTemplate("testResults.vm");
        template.merge((Context)velocityContext, writer);
    }

    public TestSummary getAssertionCounts() {
        TestSummary assertionCounts = new TestSummary();
        for (TestResult result : this.results) {
            assertionCounts.add(result.getTestSummary());
        }
        return assertionCounts;
    }

    public String getContentsOfReport(int reportNumber) {
        return ((TestResult)this.results.get(reportNumber)).getContent();
    }
}

