/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.responders.run.TestExecutionReport;
import fitnesse.testsystems.TestSummary;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestExecutionReportTest {
    private TestExecutionReport expected;
    private FitNesseContext context;
    private TestExecutionReport actual;
    private TestExecutionReport.TestResult result;

    @Before
    public void setup() throws Exception {
        this.expected = new TestExecutionReport();
        this.makeHeader();
        this.context = FitNesseUtil.makeTestContext((WikiPage)InMemoryPage.makeRoot((String)"RooT"));
    }

    private void makeHeader() {
        this.expected.version = "version";
        this.expected.finalCounts = new TestSummary(1, 2, 3, 4);
        this.expected.rootPath = "rootPath";
    }

    private String reportToXml(TestExecutionReport report) throws Exception {
        StringWriter writer = new StringWriter();
        report.toXml((Writer)writer, this.context.pageFactory.getVelocityEngine());
        writer.close();
        return writer.toString();
    }

    private void serializeAndDeserialize() throws Exception {
        String xmlReport = this.reportToXml(this.expected);
        this.actual = new TestExecutionReport((InputStream)new ByteArrayInputStream(xmlReport.getBytes()));
    }

    private void addDummyResult() {
        this.result = new TestExecutionReport.TestResult();
        this.result.content = "content";
        this.result.right = "1";
        this.result.wrong = "2";
        this.result.ignores = "3";
        this.result.exceptions = "4";
        this.result.relativePageName = "relativePageName";
        this.result.tags = "tags";
        this.result.runTimeInMillis = "234";
        this.expected.results.add(this.result);
    }

    @Test
    public void headerCanBeSerializedAndDeserialized() throws Exception {
        this.serializeAndDeserialize();
        Assert.assertEquals((Object)this.expected.getVersion(), (Object)this.actual.getVersion());
        Assert.assertEquals((Object)this.expected.getFinalCounts(), (Object)this.actual.getFinalCounts());
        Assert.assertEquals((Object)this.expected.getRootPath(), (Object)this.actual.getRootPath());
    }

    @Test
    public void simpleResultCanBeSerializedAndDeserialized() throws Exception {
        this.addDummyResult();
        this.serializeAndDeserialize();
        Assert.assertEquals((long)1L, (long)this.actual.getResults().size());
        Assert.assertEquals((Object)"234", (Object)((TestExecutionReport.TestResult)this.actual.getResults().get((int)0)).runTimeInMillis);
    }

    @Test
    public void getAssertions() throws Exception {
        this.addDummyResult();
        Assert.assertEquals((Object)this.expected.getAssertionCounts(), (Object)new TestSummary(1, 2, 3, 4));
    }

    @Test
    public void tablesShouldBeDeserialized() throws Exception {
        this.addTablesToResult();
        this.serializeAndDeserialize();
        List tables = ((TestExecutionReport.TestResult)this.actual.results.get((int)0)).tables;
        Assert.assertEquals((long)1L, (long)tables.size());
        TestExecutionReport.Table table = (TestExecutionReport.Table)tables.get(0);
        Assert.assertEquals((long)2L, (long)table.size());
        TestExecutionReport.Row r0 = (TestExecutionReport.Row)table.get(0);
        Assert.assertEquals((long)1L, (long)r0.size());
        Assert.assertEquals((Object)"r0c0", (Object)r0.get(0));
        TestExecutionReport.Row r1 = (TestExecutionReport.Row)table.get(1);
        Assert.assertEquals((long)2L, (long)r1.size());
        Assert.assertEquals((Object)"r1c0", (Object)r1.get(0));
        Assert.assertEquals((Object)"r1c1", (Object)r1.get(1));
    }

    private void addTablesToResult() {
        this.addDummyResult();
        TestExecutionReport.Table table = new TestExecutionReport.Table("table");
        TestExecutionReport.Row r0 = new TestExecutionReport.Row();
        table.add((Object)r0);
        r0.add((Object)"r0c0");
        TestExecutionReport.Row r1 = new TestExecutionReport.Row();
        r1.add((Object)"r1c0");
        r1.add((Object)"r1c1");
        table.add((Object)r1);
        this.result.tables.add(table);
    }

    @Test
    public void instructionsShouldBeDeserialized() throws Exception {
        this.addDummyResult();
        this.addInstructionsToResult();
        this.serializeAndDeserialize();
        List instructions = ((TestExecutionReport.TestResult)this.actual.results.get((int)0)).instructions;
        Assert.assertEquals((long)2L, (long)instructions.size());
        TestExecutionReport.InstructionResult ir1 = (TestExecutionReport.InstructionResult)instructions.get(0);
        TestExecutionReport.InstructionResult ir2 = (TestExecutionReport.InstructionResult)instructions.get(1);
        Assert.assertEquals((Object)"instruction1", (Object)ir1.instruction);
        Assert.assertEquals((Object)"slimResult1", (Object)ir1.slimResult);
        List expectations1 = ir1.getExpectations();
        Assert.assertEquals((long)2L, (long)expectations1.size());
        TestExecutionReport.Expectation e11 = (TestExecutionReport.Expectation)expectations1.get(0);
        TestExecutionReport.Expectation e12 = (TestExecutionReport.Expectation)expectations1.get(1);
        Assert.assertEquals((Object)"s1", (Object)e11.status);
        Assert.assertEquals((Object)"id1", (Object)e11.instructionId);
        Assert.assertEquals((Object)"c1", (Object)e11.col);
        Assert.assertEquals((Object)"r1", (Object)e11.row);
        Assert.assertEquals((Object)"t1", (Object)e11.type);
        Assert.assertEquals((Object)"a1", (Object)e11.actual);
        Assert.assertEquals((Object)"e1", (Object)e11.expected);
        Assert.assertEquals((Object)"m1", (Object)e11.evaluationMessage);
        Assert.assertEquals((Object)"s2", (Object)e12.status);
        Assert.assertEquals((Object)"id2", (Object)e12.instructionId);
        Assert.assertEquals((Object)"c2", (Object)e12.col);
        Assert.assertEquals((Object)"r2", (Object)e12.row);
        Assert.assertEquals((Object)"t2", (Object)e12.type);
        Assert.assertNull((Object)e12.actual);
        Assert.assertNull((Object)e12.expected);
        Assert.assertNull((Object)e12.evaluationMessage);
        Assert.assertEquals((Object)"instruction2", (Object)ir2.instruction);
        Assert.assertEquals((Object)"slimResult2", (Object)ir2.slimResult);
        Assert.assertEquals((long)0L, (long)ir2.getExpectations().size());
    }

    private void addInstructionsToResult() {
        TestExecutionReport.InstructionResult instruction1 = new TestExecutionReport.InstructionResult();
        instruction1.instruction = "instruction1";
        instruction1.slimResult = "slimResult1";
        TestExecutionReport.Expectation e1 = new TestExecutionReport.Expectation();
        instruction1.addExpectation(e1);
        e1.status = "s1";
        e1.instructionId = "id1";
        e1.col = "c1";
        e1.row = "r1";
        e1.type = "t1";
        e1.actual = "a1";
        e1.expected = "e1";
        e1.evaluationMessage = "m1";
        TestExecutionReport.Expectation e2 = new TestExecutionReport.Expectation();
        instruction1.addExpectation(e2);
        e2.status = "s2";
        e2.instructionId = "id2";
        e2.col = "c2";
        e2.row = "r2";
        e2.type = "t2";
        this.result.instructions.add(instruction1);
        TestExecutionReport.InstructionResult instruction2 = new TestExecutionReport.InstructionResult();
        instruction2.instruction = "instruction2";
        instruction2.slimResult = "slimResult2";
        this.result.instructions.add(instruction2);
    }
}

