/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.responders.run.formatters.InteractiveFormatter;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.IOException;
import util.TimeMeasurement;

public abstract class SuiteHtmlFormatter
extends InteractiveFormatter {
    private TestSummary pageCounts = new TestSummary();
    private static final String TEST_SUMMARIES_ID = "test-summaries";
    private int currentTest = 0;
    private String testSystemFullName = null;
    private boolean printedTestOutput = false;
    private int totalTests = 1;
    private TimeMeasurement latestTestTime;
    private String testSummariesId = "test-summaries";

    public SuiteHtmlFormatter(FitNesseContext context, WikiPage page) {
        super(context, page);
    }

    public SuiteHtmlFormatter(FitNesseContext context) {
        super(context, null);
    }

    public void announceNumberTestsToRun(int testsToRun) {
        super.announceNumberTestsToRun(testsToRun);
        this.totalTests = testsToRun != 0 ? testsToRun : 1;
    }

    public void announceStartNewTest(String relativeName, String fullPathName) {
        ++this.currentTest;
        this.updateSummaryDiv(this.getProgressHtml(relativeName));
        this.maybeWriteTestOutputDiv();
        this.maybeWriteTestSystem();
        this.writeTestOuputDiv(relativeName, fullPathName);
    }

    private void writeTestOuputDiv(String relativeName, String fullPathName) {
        HtmlTag pageNameBar = HtmlUtil.makeDivTag((String)"test_output_name");
        HtmlTag anchor = HtmlUtil.makeLink((String)fullPathName, (String)relativeName);
        anchor.addAttribute("id", relativeName + this.currentTest);
        anchor.addAttribute("class", "test_name");
        HtmlTag title = new HtmlTag("h3", (HtmlElement)anchor);
        HtmlTag topLink = HtmlUtil.makeLink((String)"#test-summaries", (String)"Top");
        topLink.addAttribute("class", "top_of_page");
        pageNameBar.add((HtmlElement)title);
        pageNameBar.add((HtmlElement)topLink);
        this.writeData(pageNameBar.html());
        this.writeData("<div class=\"alternating_block\">");
    }

    private void maybeWriteTestOutputDiv() {
        if (!this.printedTestOutput) {
            HtmlTag outputTitle = new HtmlTag("h2", "Test Output");
            this.writeData(outputTitle.html());
            this.printedTestOutput = true;
        }
    }

    private void maybeWriteTestSystem() {
        if (this.testSystemFullName != null) {
            HtmlTag systemTitle = new HtmlTag("h2", String.format("Test System: %s", this.testSystemFullName));
            this.writeData(systemTitle.html());
            this.testSystemFullName = null;
        }
    }

    public void newTestStarted(TestPage testPage, TimeMeasurement timeMeasurement) throws IOException {
        super.newTestStarted(testPage, timeMeasurement);
        PageCrawler pageCrawler = this.getPage().getPageCrawler();
        WikiPagePath fullPath = pageCrawler.getFullPath(testPage.getSourcePage());
        String fullPathName = PathParser.render((WikiPagePath)fullPath);
        this.announceStartNewTest(this.getRelativeName(), fullPathName);
    }

    private String getProgressHtml(String relativeName) {
        float percentFinished = (this.currentTest - 1) * 1000 / this.totalTests;
        percentFinished /= 10.0f;
        String text = "Running tests ... (" + this.currentTest + "/" + this.totalTests + ")";
        text = text.replaceAll(" ", "&nbsp;");
        HtmlTag progressDiv = new HtmlTag("div", text);
        ExecutionResult cssClass = this.currentTest == 1 ? ExecutionResult.PASS : ExecutionResult.getExecutionResult((String)relativeName, (TestSummary)this.pageCounts);
        progressDiv.addAttribute("id", "progressBar");
        progressDiv.addAttribute("class", cssClass.toString());
        progressDiv.addAttribute("style", "width:" + percentFinished + "%");
        return progressDiv.html();
    }

    public void processTestResults(String relativeName, TestSummary testSummary) throws IOException {
        this.finishOutputForTest();
        this.getAssertionCounts().add(testSummary);
        HtmlTag tag = new HtmlTag("li");
        tag.add((HtmlElement)HtmlUtil.makeSpanTag((String)("results " + ExecutionResult.getExecutionResult((String)relativeName, (TestSummary)testSummary)), (String)testSummary.toString()));
        HtmlTag link = HtmlUtil.makeLink((String)("#" + relativeName + this.currentTest), (String)relativeName);
        link.addAttribute("class", "link");
        tag.add((HtmlElement)link);
        if (this.latestTestTime != null) {
            tag.add((HtmlElement)HtmlUtil.makeSpanTag((String)"", (String)String.format("(%.03f seconds)", this.latestTestTime.elapsedSeconds())));
        }
        this.pageCounts.tallyPageCounts(ExecutionResult.getExecutionResult((String)relativeName, (TestSummary)testSummary, (boolean)this.wasInterupted()));
        HtmlTag insertScript = HtmlUtil.makeAppendElementScript((String)this.testSummariesId, (String)tag.html());
        this.writeData(insertScript.html());
    }

    private void finishOutputForTest() {
        this.writeData("</div>" + HtmlTag.endl);
    }

    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) throws IOException {
        this.latestTestTime = totalTimeMeasurement;
        this.removeStopTestLink();
        this.publishAndAddLog();
        this.maybeMakeErrorNavigatorVisible();
        this.finishWritingOutput();
        this.close();
        super.allTestingComplete(totalTimeMeasurement);
    }

    public void testOutputChunk(String output) throws IOException {
        this.writeData(output);
    }

    public void testComplete(TestPage testPage, TestSummary testSummary, TimeMeasurement timeMeasurement) throws IOException {
        super.testComplete(testPage, testSummary, timeMeasurement);
        this.latestTestTime = timeMeasurement;
        this.processTestResults(this.getRelativeName(testPage), testSummary);
    }

    public void errorOccured() {
        this.latestTestTime = null;
        super.errorOccured();
    }

    public void testSystemStarted(TestSystem testSystem, String testSystemName, String testRunner) {
        this.testSystemFullName = (testSystemName + ":" + testRunner).replaceAll("\\\\", "/");
        this.testSummariesId = "test-system-" + testSystemName;
        String tag = String.format("<h3>%s</h3>\n<ul id=\"%s\"></ul>", this.testSystemFullName, this.testSummariesId);
        HtmlTag insertScript = HtmlUtil.makeAppendElementScript((String)TEST_SUMMARIES_ID, (String)tag);
        this.writeData(insertScript.html());
    }

    protected String makeSummaryContent() {
        String summaryContent = "<strong>Test Pages:</strong> " + this.pageCounts.toString() + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        summaryContent = this.latestTestTime != null ? summaryContent + String.format("<strong>Assertions:</strong> %s (%.03f seconds)", this.getAssertionCounts(), this.latestTestTime.elapsedSeconds()) : summaryContent + String.format("<strong>Assertions:</strong> %s ", this.getAssertionCounts());
        return summaryContent;
    }

    public void finishWritingOutput() throws IOException {
        this.writeData(this.testSummary());
        super.finishWritingOutput();
    }
}

