/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.TagGroup;
import fitnesse.responders.run.formatters.InteractiveFormatter;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageUtil;
import java.io.IOException;
import util.TimeMeasurement;

public abstract class TestHtmlFormatter
extends InteractiveFormatter {
    protected TimeMeasurement latestTestTime;

    public TestHtmlFormatter(FitNesseContext context, WikiPage page) {
        super(context, page);
    }

    public TestHtmlFormatter(FitNesseContext context) {
        super(context, null);
    }

    public void newTestStarted(TestPage testPage, TimeMeasurement timeMeasurement) throws IOException {
        super.newTestStarted(testPage, timeMeasurement);
        this.writeData(WikiPageUtil.getHeaderPageHtml((WikiPage)this.getPage()));
    }

    public void testSystemStarted(TestSystem testSystem, String testSystemName, String testRunner) {
    }

    public void testComplete(TestPage testPage, TestSummary testSummary, TimeMeasurement timeMeasurement) throws IOException {
        super.testComplete(testPage, testSummary, timeMeasurement);
        this.latestTestTime = timeMeasurement;
        this.processTestResults(this.getRelativeName(testPage), testSummary);
    }

    public void processTestResults(String relativeName, TestSummary testSummary) throws IOException {
        this.getAssertionCounts().add(testSummary);
    }

    public void testOutputChunk(String output) throws IOException {
        this.writeData(output);
    }

    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) throws IOException {
        super.allTestingComplete(totalTimeMeasurement);
        this.removeStopTestLink();
        this.publishAndAddLog();
        this.maybeMakeErrorNavigatorVisible();
        this.finishWritingOutput();
        this.close();
    }

    protected void finishWritingOutput() throws IOException {
        this.writeData(this.testSummary());
        super.finishWritingOutput();
    }

    protected String makeSummaryContent() {
        String summaryContent = this.latestTestTime != null ? String.format("<strong>Assertions:</strong> %s (%.03f seconds)", this.getAssertionCounts(), this.latestTestTime.elapsedSeconds()) : String.format("<strong>Assertions:</strong> %s ", this.getAssertionCounts());
        return summaryContent;
    }

    public int getErrorCount() {
        return this.getAssertionCounts().getWrong() + this.getAssertionCounts().getExceptions();
    }

    public void addMessageForBlankHtml() {
        TagGroup html = new TagGroup();
        HtmlTag h2 = new HtmlTag("h2");
        h2.add("Oops!  Did you forget to add to some content to this ?");
        html.add(h2.html());
        html.add(HtmlUtil.HR.html());
        this.writeData(html.html());
    }

    public void errorOccured() {
        this.latestTestTime = null;
        super.errorOccured();
    }
}

