/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.search;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.responders.search.ExecuteSearchPropertiesResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExecuteSearchPropertiesResponderTest
extends RegexTestCase {
    private WikiPage root;
    private PageCrawler crawler;
    private ExecuteSearchPropertiesResponder responder;
    private FitNesseContext context;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.crawler = this.root.getPageCrawler();
        this.responder = new ExecuteSearchPropertiesResponder();
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
    }

    @Test
    public void testResponseWithNoParametersWillReturnEmptyPage() throws Exception {
        MockRequest request = this.setupRequest();
        String content = this.invokeResponder(request);
        ExecuteSearchPropertiesResponderTest.assertSubString((String)"Search Page Properties Results", (String)content);
        ExecuteSearchPropertiesResponderTest.assertSubString((String)"No search properties", (String)content);
    }

    @Test
    public void testResponseWithNoMatchesWillReturnEmptyPageList() throws Exception {
        MockRequest request = this.setupRequest();
        request.addInput("PageType", (Object)"Suite,Static");
        String content = this.invokeResponder(request);
        ExecuteSearchPropertiesResponderTest.assertSubString((String)"No pages", (String)content);
    }

    @Test
    public void testResponseWithMatchesWillReturnPageList() throws Exception {
        MockRequest request = this.setupRequest();
        request.addInput("PageType", (Object)PageType.TEST.toString());
        String content = this.invokeResponder(request);
        String[] titles = new String[]{"Page", PageType.TEST.toString(), "PageOne"};
        this.assertOutputHasRowWithLink(content, titles);
        request.addInput("Suites", (Object)"filter1");
        content = this.invokeResponder(request);
        ExecuteSearchPropertiesResponderTest.assertHasRegexp((String)"result for your search", (String)content);
        String[] titles1 = new String[]{"Page", PageType.TEST.toString(), "Tags", "PageOne"};
        this.assertOutputHasRowWithLink(content, titles1);
        this.assertOutputHasRowWithLabels("filter1,filter2", new String[0]);
    }

    private String invokeResponder(MockRequest request) throws Exception {
        Response response = this.responder.makeResponse(this.context, (Request)request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(response);
        return sender.sentData();
    }

    private MockRequest setupRequest() throws Exception {
        WikiPage page = this.crawler.addPage(this.root, PathParser.parse((String)"PageOne"));
        PageData data = page.getData();
        data.setContent("some content");
        WikiPageProperties properties = data.getProperties();
        properties.set(PageType.TEST.toString(), "true");
        properties.set("Suites", "filter1,filter2");
        page.commit(data);
        MockRequest request = new MockRequest();
        request.setResource("PageOne");
        request.addInput("Action", (Object)"Any");
        request.addInput("Security", (Object)"Any");
        request.addInput("Special", (Object)"Any");
        return request;
    }

    private void assertOutputHasRowWithLink(String content, String ... titles) {
        for (String title : titles) {
            this.assertOutputHasRow(content, title, "a href.*");
        }
    }

    private void assertOutputHasRowWithLabels(String content, String ... labels) {
        for (String label : labels) {
            this.assertOutputHasRow(content, label, "label");
        }
    }

    private void assertOutputHasRow(String content, String title, String tagName) {
        ExecuteSearchPropertiesResponderTest.assertHasRegexp((String)("<table.*<tr.*<t[dh].*<" + tagName + ".*>.*" + title + ".*</" + tagName.split(" ")[0] + ">"), (String)content);
    }

    @Test
    public void testGetPageTypesFromInput() {
        this.assertPageTypesMatch(new PageType[]{PageType.TEST});
        this.assertPageTypesMatch(new PageType[]{PageType.TEST, PageType.STATIC});
        this.assertPageTypesMatch(new PageType[]{PageType.TEST, PageType.SUITE, PageType.STATIC});
    }

    private void assertPageTypesMatch(PageType ... pageTypes) {
        MockRequest request = new MockRequest();
        List<PageType> types = Arrays.asList(pageTypes);
        String commaSeparatedPageTypes = this.buildPageTypeListForRequest(pageTypes);
        request.addInput("PageType", (Object)commaSeparatedPageTypes);
        ExecuteSearchPropertiesResponderTest.assertEquals(types, (Object)this.responder.getPageTypesFromInput((Request)request));
    }

    private String buildPageTypeListForRequest(PageType ... pageTypes) {
        StringBuffer buffer = new StringBuffer();
        for (PageType type : pageTypes) {
            buffer.append(type.toString());
            buffer.append(',');
        }
        buffer.deleteCharAt(buffer.length() - 1);
        String commaSeparatedPageTypes = buffer.toString();
        return commaSeparatedPageTypes;
    }

    @Test
    public void testGetAttributesFromInput() {
        MockRequest request = new MockRequest();
        request.addInput("Action", (Object)"Edit");
        Map foundAttributes = this.responder.getAttributesFromInput((Request)request);
        ExecuteSearchPropertiesResponderTest.assertFalse((boolean)foundAttributes.containsKey("Version"));
        ExecuteSearchPropertiesResponderTest.assertTrue((boolean)foundAttributes.containsKey("Edit"));
        ExecuteSearchPropertiesResponderTest.assertTrue((boolean)((Boolean)foundAttributes.get("Edit")));
        request.addInput("Action", (Object)"Edit,Properties");
        foundAttributes = this.responder.getAttributesFromInput((Request)request);
        ExecuteSearchPropertiesResponderTest.assertTrue((boolean)((Boolean)foundAttributes.get("Properties")));
    }

    @Test
    public void testPageTypesAreOrEd() throws Exception {
        MockRequest request = this.setupRequest();
        request.addInput("PageType", (Object)"Test,Suite");
        String content = this.invokeResponder(request);
        String[] titles = new String[]{"Page", PageType.TEST.toString(), "PageOne"};
        this.assertOutputHasRowWithLink(content, titles);
        request.addInput("Suites", (Object)"filter1");
        content = this.invokeResponder(request);
        ExecuteSearchPropertiesResponderTest.assertHasRegexp((String)"result for your search", (String)content);
        String[] titles1 = new String[]{"Page", PageType.TEST.toString(), "Tags", "PageOne"};
        this.assertOutputHasRowWithLink(content, titles1);
        this.assertOutputHasRowWithLabels(content, new String[]{"filter1,filter2"});
    }

    @Test
    public void testPageMatchesWithObsoletePages() throws Exception {
        MockRequest request = this.setupRequestForObsoletePage();
        request.addInput("PageType", (Object)"Test,Suite");
        String content = this.invokeResponder(request);
        String[] titles = new String[]{"Page", PageType.TEST.toString(), "ObsoletePage"};
        this.assertOutputHasRowWithLink(content, titles);
        request.addInput("Special", (Object)"SetUp,TearDown");
        content = this.invokeResponder(request);
        ExecuteSearchPropertiesResponderTest.assertSubString((String)"No pages", (String)content);
    }

    private MockRequest setupRequestForObsoletePage() throws Exception {
        WikiPage page = this.crawler.addPage(this.root, PathParser.parse((String)"ObsoletePage"));
        PageData data = page.getData();
        data.setContent("some content");
        WikiPageProperties properties1 = data.getProperties();
        properties1.set(PageType.TEST.toString(), "true");
        properties1.set("Suites", "filter1,filter2");
        WikiPageProperties properties = properties1;
        properties.set("Prune", "true");
        page.commit(data);
        MockRequest request = this.setupRequest();
        request.setResource("ObsoletePage");
        return request;
    }

    public void testFindJustObsoletePages() throws Exception {
        MockRequest request = this.setupRequestForObsoletePage();
        request.addInput("PageType", (Object)"Test,Suite,Static");
        request.addInput("Special", (Object)"obsolete");
        String content = this.invokeResponder(request);
        String[] titles = new String[]{"ObsoletePage"};
        this.assertOutputHasRowWithLink(content, titles);
    }
}

