/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.FitNesseContext;
import fitnesse.responders.run.TestExecutionReport;
import fitnesse.responders.testHistory.HistoryComparer;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.velocity.app.VelocityEngine;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.FileUtil;
import util.RegexTestCase;

public class HistoryComparerTest {
    private HistoryComparer comparer;
    public FitNesseContext context;
    public WikiPage root;
    public String firstContent;
    public String secondContent;

    @Before
    public void setUp() throws Exception {
        this.comparer = new /* Unavailable Anonymous Inner Class!! */;
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.firstContent = this.getContentWith("pass");
        this.secondContent = this.getContentWith("fail");
        HistoryComparer.resultContent = new ArrayList();
        this.comparer.firstTableResults = new ArrayList();
        this.comparer.secondTableResults = new ArrayList();
        this.comparer.matchedTables = new ArrayList();
    }

    @Test
    public void shouldBeAbleToHandleANonexistentFile() throws Exception {
        String content = this.comparer.getFileContent("TestFolder/TestFile");
        Assert.assertNull((Object)content);
    }

    @Test
    public void shouldBeAbleToGrabTwoFilesToBeCompared() throws Exception {
        FileUtil.createFile((String)"TestFolder/FileOne", (String)"this is file one");
        FileUtil.createFile((String)"TestFolder/FileTwo", (String)"this is file two");
        this.comparer.compare("TestFolder/FileOne", "TestFolder/FileTwo");
        Assert.assertEquals((Object)"this is file one", (Object)this.comparer.firstFileContent);
        Assert.assertEquals((Object)"this is file two", (Object)this.comparer.secondFileContent);
        FileUtil.deleteFileSystemDirectory((String)"TestFolder");
    }

    @Test
    public void shouldKnowIfTheTwoFilesAreTheSameFile() throws Exception {
        FileUtil.createFile((String)"TestFolder/FileOne", (String)"this is file one");
        boolean compareWorked = this.comparer.compare("TestFolder/FileOne", "TestFolder/FileOne");
        Assert.assertFalse((boolean)compareWorked);
        FileUtil.deleteFileSystemDirectory((String)"TestFolder");
    }

    @Test
    public void shouldCompareTwoSetsOfTables() throws Exception {
        this.comparer.firstFileContent = "<table><tr><td>x</td></tr></table><table><tr><td>y</td></tr></table>";
        this.comparer.secondFileContent = "<table><tr><td>x</td></tr></table><table><tr><td>y</td></tr></table>";
        Assert.assertTrue((boolean)this.comparer.grabAndCompareTablesFromHtml());
        Assert.assertEquals((long)2L, (long)this.comparer.getResultContent().size());
        Assert.assertEquals((Object)"pass", this.comparer.getResultContent().get(0));
        Assert.assertEquals((Object)"pass", this.comparer.getResultContent().get(1));
    }

    @Test
    public void shouldCompareUnevenAmountsOfTables() throws Exception {
        this.comparer.firstFileContent = "<table><tr><td>x</td></tr></table><table><tr><td>y</td></tr></table>";
        this.comparer.secondFileContent = "<table><tr><td>x</td></tr></table>";
        Assert.assertTrue((boolean)this.comparer.grabAndCompareTablesFromHtml());
        Assert.assertEquals((long)2L, (long)HistoryComparer.resultContent.size());
        Assert.assertEquals((Object)"pass", HistoryComparer.resultContent.get(0));
        Assert.assertEquals((Object)"fail", HistoryComparer.resultContent.get(1));
    }

    @Test
    public void findMatchScoreByFirstIndex() throws Exception {
        this.comparer.matchedTables.add(new HistoryComparer.MatchedPair(Integer.valueOf(1), Integer.valueOf(2), 1.1));
        this.comparer.matchedTables.add(new HistoryComparer.MatchedPair(Integer.valueOf(3), Integer.valueOf(4), 1.0));
        Assert.assertEquals((double)1.1, (double)this.comparer.findScoreByFirstTableIndex(1), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)this.comparer.findScoreByFirstTableIndex(3), (double)1.0E-4);
    }

    @Test
    public void shouldBeAbleToFindMatchScoreByFirstIndexAndReturnAPercentString() throws Exception {
        this.comparer.matchedTables.add(new HistoryComparer.MatchedPair(Integer.valueOf(1), Integer.valueOf(2), 1.1));
        this.comparer.matchedTables.add(new HistoryComparer.MatchedPair(Integer.valueOf(3), Integer.valueOf(4), 1.0));
        RegexTestCase.assertSubString((String)"91.67", (String)this.comparer.findScoreByFirstTableIndexAsStringAsPercent(1));
        RegexTestCase.assertSubString((String)"83.33", (String)this.comparer.findScoreByFirstTableIndexAsStringAsPercent(3));
    }

    @Test
    public void shouldBeAbleToTellIfTableListsWereACompleteMatch() throws Exception {
        Assert.assertFalse((boolean)this.comparer.allTablesMatch());
        this.comparer.firstTableResults.add("A");
        this.comparer.firstTableResults.add("B");
        this.comparer.secondTableResults.add("A");
        this.comparer.secondTableResults.add("B");
        this.comparer.matchedTables.add(new HistoryComparer.MatchedPair(Integer.valueOf(0), Integer.valueOf(0), 1.2));
        this.comparer.matchedTables.add(new HistoryComparer.MatchedPair(Integer.valueOf(1), Integer.valueOf(1), 1.0));
        Assert.assertFalse((boolean)this.comparer.allTablesMatch());
        this.comparer.matchedTables.remove(new HistoryComparer.MatchedPair(Integer.valueOf(1), Integer.valueOf(1), 1.0));
        this.comparer.matchedTables.add(new HistoryComparer.MatchedPair(Integer.valueOf(1), Integer.valueOf(1), 1.2));
        Assert.assertTrue((boolean)this.comparer.allTablesMatch());
        this.comparer.firstTableResults.add("C");
        Assert.assertFalse((boolean)this.comparer.allTablesMatch());
    }

    @Test
    public void shouldBeAbleToLineUpMisMatchedTables() throws Exception {
        this.comparer.firstTableResults.add("A");
        this.comparer.firstTableResults.add("B");
        this.comparer.firstTableResults.add("C");
        this.comparer.firstTableResults.add("D");
        this.comparer.secondTableResults.add("X");
        this.comparer.secondTableResults.add("Y");
        this.comparer.secondTableResults.add("B");
        this.comparer.secondTableResults.add("Z");
        this.comparer.secondTableResults.add("D");
        this.comparer.matchedTables.add(new HistoryComparer.MatchedPair(Integer.valueOf(1), Integer.valueOf(2), 1.0));
        this.comparer.matchedTables.add(new HistoryComparer.MatchedPair(Integer.valueOf(3), Integer.valueOf(4), 1.0));
        this.comparer.lineUpTheTables();
        Assert.assertEquals((Object)"A", this.comparer.firstTableResults.get(0));
        Assert.assertEquals((Object)"<table><tr><td></td></tr></table>", this.comparer.firstTableResults.get(1));
        Assert.assertEquals((Object)"B", this.comparer.firstTableResults.get(2));
        Assert.assertEquals((Object)"D", this.comparer.firstTableResults.get(4));
        Assert.assertEquals((Object)"X", this.comparer.secondTableResults.get(0));
        Assert.assertEquals((Object)"D", this.comparer.secondTableResults.get(4));
    }

    @Test
    public void shouldBeAbleToLineUpMoreMisMatchedTables() throws Exception {
        this.comparer.firstTableResults.add("A");
        this.comparer.firstTableResults.add("B");
        this.comparer.firstTableResults.add("C");
        this.comparer.firstTableResults.add("D");
        this.comparer.secondTableResults.add("B");
        this.comparer.secondTableResults.add("X");
        this.comparer.secondTableResults.add("Y");
        this.comparer.secondTableResults.add("Z");
        this.comparer.secondTableResults.add("D");
        this.comparer.secondTableResults.add("shouldMatchWithBlank");
        this.comparer.matchedTables.add(new HistoryComparer.MatchedPair(Integer.valueOf(1), Integer.valueOf(0), 1.0));
        this.comparer.matchedTables.add(new HistoryComparer.MatchedPair(Integer.valueOf(3), Integer.valueOf(4), 1.0));
        this.comparer.lineUpTheTables();
        Assert.assertEquals((Object)"A", this.comparer.firstTableResults.get(0));
        Assert.assertEquals((Object)"B", this.comparer.firstTableResults.get(1));
        Assert.assertEquals((Object)"<table><tr><td></td></tr></table>", this.comparer.firstTableResults.get(3));
        Assert.assertEquals((Object)"<table><tr><td></td></tr></table>", this.comparer.firstTableResults.get(4));
        Assert.assertEquals((Object)"D", this.comparer.firstTableResults.get(5));
        Assert.assertEquals((Object)"<table><tr><td></td></tr></table>", this.comparer.firstTableResults.get(6));
        Assert.assertEquals((Object)"<table><tr><td></td></tr></table>", this.comparer.secondTableResults.get(0));
        Assert.assertEquals((Object)"B", this.comparer.secondTableResults.get(1));
        Assert.assertEquals((Object)"Y", this.comparer.secondTableResults.get(3));
        Assert.assertEquals((Object)"Z", this.comparer.secondTableResults.get(4));
        Assert.assertEquals((Object)"D", this.comparer.secondTableResults.get(5));
        Assert.assertEquals((Object)"shouldMatchWithBlank", this.comparer.secondTableResults.get(6));
    }

    @Test
    public void shouldGuarenteeThatBothResultFilesAreTheSameLength() throws Exception {
        this.comparer.firstTableResults.add("A");
        this.comparer.firstTableResults.add("B");
        this.comparer.firstTableResults.add("C");
        this.comparer.firstTableResults.add("D");
        this.comparer.secondTableResults.add("X");
        this.comparer.secondTableResults.add("Y");
        this.comparer.lineUpTheTables();
        Assert.assertEquals((long)this.comparer.firstTableResults.size(), (long)this.comparer.secondTableResults.size());
        Assert.assertEquals((Object)"<table><tr><td></td></tr></table>", this.comparer.secondTableResults.get(2));
        Assert.assertEquals((Object)"<table><tr><td></td></tr></table>", this.comparer.secondTableResults.get(3));
    }

    @Test
    public void shouldAddBlankRowsForUnmatchedTables() throws Exception {
        this.comparer.firstTableResults.add("A");
        this.comparer.firstTableResults.add("B");
        this.comparer.firstTableResults.add("C");
        this.comparer.firstTableResults.add("D");
        this.comparer.secondTableResults.add("X");
        this.comparer.secondTableResults.add("B");
        this.comparer.secondTableResults.add("Y");
        this.comparer.matchedTables.add(new HistoryComparer.MatchedPair(Integer.valueOf(1), Integer.valueOf(1), 1.0));
        this.comparer.lineUpTheTables();
        this.comparer.addBlanksToUnmatchingRows();
        Assert.assertEquals((long)this.comparer.firstTableResults.size(), (long)this.comparer.secondTableResults.size());
        Assert.assertEquals((Object)"A", this.comparer.firstTableResults.get(0));
        Assert.assertEquals((Object)"<table><tr><td></td></tr></table>", this.comparer.firstTableResults.get(1));
        Assert.assertEquals((Object)"B", this.comparer.firstTableResults.get(2));
        Assert.assertEquals((Object)"C", this.comparer.firstTableResults.get(3));
        Assert.assertEquals((Object)"<table><tr><td></td></tr></table>", this.comparer.firstTableResults.get(4));
        Assert.assertEquals((Object)"D", this.comparer.firstTableResults.get(5));
        Assert.assertEquals((Object)"<table><tr><td></td></tr></table>", this.comparer.secondTableResults.get(0));
        Assert.assertEquals((Object)"X", this.comparer.secondTableResults.get(1));
        Assert.assertEquals((Object)"B", this.comparer.secondTableResults.get(2));
        Assert.assertEquals((Object)"<table><tr><td></td></tr></table>", this.comparer.secondTableResults.get(3));
        Assert.assertEquals((Object)"Y", this.comparer.secondTableResults.get(4));
        Assert.assertEquals((Object)"<table><tr><td></td></tr></table>", this.comparer.secondTableResults.get(5));
    }

    @Test
    public void shouldHaveCorrectPassFailResults() throws Exception {
        this.comparer.firstTableResults.add("A");
        this.comparer.firstTableResults.add("B");
        this.comparer.firstTableResults.add("C");
        this.comparer.firstTableResults.add("D");
        this.comparer.secondTableResults.add("X");
        this.comparer.secondTableResults.add("B");
        this.comparer.secondTableResults.add("Y");
        this.comparer.secondTableResults.add("D");
        this.comparer.matchedTables.add(new HistoryComparer.MatchedPair(Integer.valueOf(1), Integer.valueOf(1), 1.2));
        this.comparer.matchedTables.add(new HistoryComparer.MatchedPair(Integer.valueOf(3), Integer.valueOf(3), 1.2));
        this.comparer.lineUpTheTables();
        this.comparer.addBlanksToUnmatchingRows();
        this.comparer.makePassFailResultsFromMatches();
        Assert.assertEquals((Object)"fail", HistoryComparer.resultContent.get(0));
        Assert.assertEquals((Object)"fail", HistoryComparer.resultContent.get(1));
        Assert.assertEquals((Object)"pass", HistoryComparer.resultContent.get(2));
        Assert.assertEquals((Object)"fail", HistoryComparer.resultContent.get(3));
        Assert.assertEquals((Object)"fail", HistoryComparer.resultContent.get(4));
        Assert.assertEquals((Object)"pass", HistoryComparer.resultContent.get(5));
    }

    @Test
    public void compareShouldGetReportHtmlAndSetResultContentWithPassIfTheFilesWereTheSame() throws Exception {
        HistoryComparer comparer = new HistoryComparer();
        FileUtil.createFile((String)"TestFolder/FirstFile", (String)this.firstContent);
        FileUtil.createFile((String)"TestFolder/SecondFile", (String)this.firstContent);
        boolean worked = comparer.compare("TestFolder/FirstFile", "TestFolder/SecondFile");
        Assert.assertTrue((boolean)worked);
        String expectedResult = "pass";
        Assert.assertEquals((Object)expectedResult, HistoryComparer.resultContent.get(0));
        Assert.assertEquals((Object)expectedResult, HistoryComparer.resultContent.get(1));
    }

    @Test
    public void compareShouldGetReportFileHtmlAndSetResultContentWithFailIfTheFilesDiffer() throws Exception {
        HistoryComparer comparer = new HistoryComparer();
        FileUtil.createFile((String)"TestFolder/FirstFile", (String)this.firstContent);
        FileUtil.createFile((String)"TestFolder/SecondFile", (String)this.secondContent);
        boolean worked = comparer.compare("TestFolder/FirstFile", "TestFolder/SecondFile");
        Assert.assertTrue((boolean)worked);
        Assert.assertEquals((Object)"pass", HistoryComparer.resultContent.get(0));
        Assert.assertEquals((Object)"fail", HistoryComparer.resultContent.get(1));
    }

    public String generateHtmlFromWiki(String passOrFail) throws Exception {
        PageCrawler crawler = this.root.getPageCrawler();
        String pageText = "|myTable|\nLa la\n|NewTable|\n|!style_" + passOrFail + "(a)|b|c|\n" + "La la la";
        WikiPage myPage = crawler.addPage(this.root, PathParser.parse((String)"MyPage"), pageText);
        PageData myData = myPage.getData();
        String html = myData.getHtml();
        return html;
    }

    private String getContentWith(String passOrFail) throws Exception {
        TestExecutionReport report = new TestExecutionReport();
        TestExecutionReport.TestResult result = new TestExecutionReport.TestResult();
        result.right = "2";
        result.wrong = "0";
        result.ignores = "0";
        result.exceptions = "0";
        result.content = this.generateHtmlFromWiki(passOrFail);
        result.relativePageName = "testPageOne";
        report.results.add(result);
        StringWriter writer = new StringWriter();
        VelocityEngine engine = this.context.pageFactory.getVelocityEngine();
        report.toXml((Writer)writer, engine);
        return ((Object)writer).toString();
    }

    @After
    public void tearDown() {
        FileUtil.deleteFileSystemDirectory((String)"TestFolder");
    }
}

