/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.responders.testHistory.PageHistory;
import fitnesse.responders.testHistory.PageHistoryReader;
import fitnesse.responders.testHistory.TestResultRecord;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestSummary;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class PageHistory
extends PageHistoryReader {
    private int failures = 0;
    private int passes = 0;
    private Date minDate = null;
    private Date maxDate = null;
    private int maxAssertions = 0;
    private BarGraph barGraph;
    private String fullPageName;
    private final HashMap<Date, TestResultRecord> testResultMap = new HashMap();
    private HashMap<Date, File> pageFiles = new HashMap();

    public PageHistory(File pageDirectory) {
        this.fullPageName = pageDirectory.getName();
        try {
            this.readHistoryFromPageDirectory(pageDirectory);
            this.compileBarGraph();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void compileBarGraph() {
        ArrayList dates = new ArrayList(this.testResultMap.keySet());
        Collections.sort(dates, this.reverseChronologicalDateComparator());
        this.barGraph = new BarGraph();
        for (int i = 0; i < dates.size() && i < 20; ++i) {
            Date date = (Date)dates.get(i);
            this.barGraph.addSummary(date, this.get(date));
        }
    }

    private Comparator<Date> reverseChronologicalDateComparator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    void processTestFile(TestResultRecord record) throws ParseException {
        Date date = record.getDate();
        this.addTestResult(record, date);
        this.countResult(record);
        this.setMinMaxDate(date);
        this.setMaxAssertions(record);
        this.pageFiles.put(date, record.getFile());
    }

    private void addTestResult(TestResultRecord record, Date date) {
        Date keyDate = this.trimMilliseconds(date);
        this.testResultMap.put(date, record);
    }

    private Date trimMilliseconds(Date date) {
        long milliseconds = date.getTime();
        long seconds = milliseconds / 1000L;
        return new Date(seconds * 1000L);
    }

    public String getPageFileName(Date date) {
        if (this.pageFiles.get(date) != null) {
            return ((File)this.pageFiles.get(date)).getName();
        }
        return null;
    }

    private void setMaxAssertions(TestResultRecord summary) {
        int assertions = summary.getRight() + summary.getWrong() + summary.getExceptions();
        this.maxAssertions = Math.max(this.maxAssertions, assertions);
    }

    private void setMinMaxDate(Date date) {
        if (this.minDate == null) {
            this.minDate = this.maxDate = date;
        } else if (date.getTime() > this.maxDate.getTime()) {
            this.maxDate = date;
        } else if (date.getTime() < this.minDate.getTime()) {
            this.minDate = date;
        }
    }

    private void countResult(TestResultRecord summary) {
        ExecutionResult result = ExecutionResult.getExecutionResult((String)summary.getWikiPageName(), (TestSummary)summary);
        if (result == ExecutionResult.FAIL || result == ExecutionResult.ERROR) {
            ++this.failures;
        } else {
            ++this.passes;
        }
    }

    public int getFailures() {
        return this.failures;
    }

    public int getPasses() {
        return this.passes;
    }

    public Date getMinDate() {
        return new Date(this.minDate.getTime());
    }

    public Date getMaxDate() {
        return new Date(this.maxDate.getTime());
    }

    public BarGraph getBarGraph() {
        return this.barGraph;
    }

    public int size() {
        return this.testResultMap.size();
    }

    public TestResultRecord get(Date key) {
        return (TestResultRecord)this.testResultMap.get(this.trimMilliseconds(key));
    }

    public int maxAssertions() {
        return this.maxAssertions;
    }

    public SortedSet<Date> datesInChronologicalOrder() {
        Set dates = this.testResultMap.keySet();
        TreeSet<Date> sortedDates = new TreeSet<Date>(Collections.reverseOrder());
        sortedDates.addAll(dates);
        return sortedDates;
    }

    public PassFailBar getPassFailBar(Date date, int maxUnits) {
        TestResultRecord summary = this.get(date);
        int fail = summary.getWrong() + summary.getExceptions();
        double unitsPerAssertion = (double)maxUnits / (double)this.maxAssertions;
        int unitsForThisTest = (int)Math.round((double)(fail + summary.getRight()) * unitsPerAssertion);
        double doubleFailUnits = (double)fail * unitsPerAssertion;
        int failUnits = (int)doubleFailUnits;
        if (Math.abs(doubleFailUnits - (double)failUnits) > 0.001) {
            ++failUnits;
        }
        int passUnits = unitsForThisTest - failUnits;
        return new PassFailBar(this, summary.getRight(), fail, passUnits, failUnits);
    }

    public String getFullPageName() {
        return this.fullPageName;
    }

    public Date getLatestDate() {
        Set dateSet = this.testResultMap.keySet();
        ArrayList dates = new ArrayList(dateSet);
        Collections.sort(dates);
        return (Date)dates.get(dates.size() - 1);
    }

    public static String formatDate(String format, Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(format, Locale.US);
        return fmt.format(date);
    }
}

