/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.responders.testHistory.HistoryComparer;
import fitnesse.responders.testHistory.TableListComparer;
import fitnesse.testsystems.slim.HtmlTable;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.Table;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableListComparerTest {
    private TableListComparer comparer;

    @Before
    public void setUp() {
        HtmlTableScanner leftHandScanner = new HtmlTableScanner("<table>empty</table>");
        HtmlTableScanner rightHandScanner = new HtmlTableScanner("<table>empty</table>");
        this.comparer = new TableListComparer(leftHandScanner, rightHandScanner);
    }

    @Test
    public void shouldOnlyUseTheBestMatchForTheFirstTable() throws Exception {
        this.comparer.saveMatch(1, 1, 1.0);
        this.comparer.saveMatch(1, 2, 1.1);
        this.comparer.sortMatchesByScore();
        this.comparer.saveOnlyTheBestMatches();
        Assert.assertEquals((double)1.1, (double)((HistoryComparer.MatchedPair)this.comparer.tableMatches.get((int)0)).matchScore, (double)0.01);
    }

    @Test
    public void shouldOnlyReplaceAMatchIfThereIsNoBetterMatchForEitherTable() throws Exception {
        this.comparer.saveMatch(1, 1, 1.0);
        this.comparer.saveMatch(3, 2, 1.2);
        this.comparer.saveMatch(1, 2, 1.1);
        this.comparer.sortMatchesByScore();
        this.comparer.saveOnlyTheBestMatches();
        Assert.assertEquals((double)1.2, (double)((HistoryComparer.MatchedPair)this.comparer.tableMatches.get((int)0)).matchScore, (double)0.001);
        Assert.assertEquals((double)1.0, (double)((HistoryComparer.MatchedPair)this.comparer.tableMatches.get((int)1)).matchScore, (double)0.001);
        Assert.assertEquals((long)2L, (long)this.comparer.tableMatches.size());
    }

    @Test
    public void shouldRemoveOldMatchesIfBetterOnesAreFound() throws Exception {
        this.comparer.tableMatches.add(new HistoryComparer.MatchedPair(Integer.valueOf(1), Integer.valueOf(1), 1.0));
        this.comparer.tableMatches.add(new HistoryComparer.MatchedPair(Integer.valueOf(3), Integer.valueOf(2), 1.0));
        this.comparer.saveMatch(1, 2, 1.1);
        this.comparer.sortMatchesByScore();
        this.comparer.saveOnlyTheBestMatches();
        Assert.assertEquals((double)1.1, (double)((HistoryComparer.MatchedPair)this.comparer.tableMatches.get((int)0)).matchScore, (double)0.001);
        Assert.assertEquals((long)1L, (long)this.comparer.tableMatches.size());
    }

    @Test
    public void shouldReplaceOldMatchForSecondTableEvenIfThereIsNoMatchForFirstTable() throws Exception {
        this.comparer.tableMatches.add(new HistoryComparer.MatchedPair(Integer.valueOf(3), Integer.valueOf(2), 1.0));
        this.comparer.saveMatch(1, 2, 1.1);
        this.comparer.sortMatchesByScore();
        this.comparer.saveOnlyTheBestMatches();
        Assert.assertEquals((double)1.1, (double)((HistoryComparer.MatchedPair)this.comparer.tableMatches.get((int)0)).matchScore, (double)0.001);
        Assert.assertEquals((long)1L, (long)this.comparer.tableMatches.size());
    }

    @Test
    public void shouldGetAScoreBackFromCompareTables() throws Exception {
        String table1text = "<table><tr><td>x</td></tr></table>";
        HtmlTable table1 = new HtmlTableScanner(table1text).getTable(0);
        String table2text = "<table><tr><td>x</td></tr></table>";
        HtmlTable table2 = new HtmlTableScanner(table2text).getTable(0);
        double score = this.comparer.compareTables((Table)table1, (Table)table2);
        Assert.assertEquals((double)1.2, (double)score, (double)0.01);
    }

    @Test
    public void shouldCompareTwoSimpleEqualTables() throws Exception {
        String table1text = "<table><tr><td>x</td></tr></table>";
        HtmlTable table1 = new HtmlTableScanner(table1text).getTable(0);
        String table2text = "<table><tr><td>x</td></tr></table>";
        HtmlTable table2 = new HtmlTableScanner(table2text).getTable(0);
        Assert.assertTrue((boolean)this.comparer.theTablesMatch(this.comparer.compareTables((Table)table1, (Table)table2)));
    }

    @Test
    public void shouldCompareTwoSimpleUnequalTables() throws Exception {
        String table1text = "<table><tr><td>x</td></tr></table>";
        HtmlTable table1 = new HtmlTableScanner(table1text).getTable(0);
        String table2text = "<table><tr><td>y</td></tr></table>";
        HtmlTable table2 = new HtmlTableScanner(table2text).getTable(0);
        Assert.assertFalse((boolean)this.comparer.theTablesMatch(this.comparer.compareTables((Table)table1, (Table)table2)));
    }

    @Test
    public void shouldCompareTwoDifferentlySizedTables() throws Exception {
        String table1text = "<table><tr><td>x</td></tr></table>";
        HtmlTable table1 = new HtmlTableScanner(table1text).getTable(0);
        String table2text = "<table><tr><td>x</td><td>y</td></tr></table>";
        HtmlTable table2 = new HtmlTableScanner(table2text).getTable(0);
        Assert.assertFalse((boolean)this.comparer.theTablesMatch(this.comparer.compareTables((Table)table1, (Table)table2)));
    }

    @Test
    public void shouldIgnoreCollapsedTables() throws Exception {
        String table1text = "<table><tr><td>has collapsed table</td></tr><tr class=\"scenario-detail\"><td><table><tr><td>bleh1</td></tr></table></td></tr></table>";
        String table2text = "<table><tr><td>has collapsed table</td></tr><tr class=\"scenario-detail\"><td><table><tr><td>HAHA</td></tr></table></td></tr></table>";
        HtmlTable table1 = new HtmlTableScanner(table1text).getTable(0);
        HtmlTable table2 = new HtmlTableScanner(table2text).getTable(0);
        double score = this.comparer.compareTables((Table)table1, (Table)table2);
        Assert.assertEquals((double)1.2, (double)score, (double)0.01);
        Assert.assertTrue((boolean)this.comparer.theTablesMatch(score));
    }

    @Test
    public void shouldCheckTheMatchScoreToSeeIfTablesMatch() throws Exception {
        double score = 1.0;
        Assert.assertTrue((boolean)this.comparer.theTablesMatch(score));
        score = 0.79;
        Assert.assertFalse((boolean)this.comparer.theTablesMatch(score));
        score = 1.1;
        Assert.assertTrue((boolean)this.comparer.theTablesMatch(score));
    }

    @Test
    public void shouldKeepTheBestScoreForATableEvenIfItIsHasABetterMatchItCantKeep() throws Exception {
        this.comparer.tableMatches.add(new HistoryComparer.MatchedPair(Integer.valueOf(6), Integer.valueOf(6), 1.0));
        this.comparer.saveMatch(6, 7, 1.1);
        this.comparer.saveMatch(7, 7, 1.2);
        this.comparer.sortMatchesByScore();
        this.comparer.saveOnlyTheBestMatches();
        Assert.assertEquals((double)1.2, (double)((HistoryComparer.MatchedPair)this.comparer.tableMatches.get((int)0)).matchScore, (double)0.001);
        Assert.assertEquals((double)1.0, (double)((HistoryComparer.MatchedPair)this.comparer.tableMatches.get((int)1)).matchScore, (double)0.001);
        Assert.assertEquals((long)2L, (long)this.comparer.tableMatches.size());
    }

    @Test
    public void shouldBeAbleToOrderTheMatchesHighestToLowest() throws Exception {
        this.comparer.tableMatches.add(new HistoryComparer.MatchedPair(Integer.valueOf(6), Integer.valueOf(6), 1.0));
        this.comparer.tableMatches.add(new HistoryComparer.MatchedPair(Integer.valueOf(5), Integer.valueOf(5), 0.9));
        this.comparer.tableMatches.add(new HistoryComparer.MatchedPair(Integer.valueOf(4), Integer.valueOf(4), 1.1));
        this.comparer.tableMatches.add(new HistoryComparer.MatchedPair(Integer.valueOf(7), Integer.valueOf(7), 1.05));
        this.comparer.sortMatchesByScore();
        Assert.assertEquals((double)1.1, (double)((HistoryComparer.MatchedPair)this.comparer.tableMatches.get((int)0)).matchScore, (double)0.001);
        Assert.assertEquals((double)1.05, (double)((HistoryComparer.MatchedPair)this.comparer.tableMatches.get((int)1)).matchScore, (double)0.001);
        Assert.assertEquals((double)1.0, (double)((HistoryComparer.MatchedPair)this.comparer.tableMatches.get((int)2)).matchScore, (double)0.001);
        Assert.assertEquals((double)0.9, (double)((HistoryComparer.MatchedPair)this.comparer.tableMatches.get((int)3)).matchScore, (double)0.001);
    }

    @Test
    public void shouldBeAbleToOrderTheMatchesByTableIndex() throws Exception {
        this.comparer.tableMatches.add(new HistoryComparer.MatchedPair(Integer.valueOf(6), Integer.valueOf(6), 1.0));
        this.comparer.tableMatches.add(new HistoryComparer.MatchedPair(Integer.valueOf(5), Integer.valueOf(5), 0.9));
        this.comparer.tableMatches.add(new HistoryComparer.MatchedPair(Integer.valueOf(4), Integer.valueOf(4), 1.1));
        this.comparer.tableMatches.add(new HistoryComparer.MatchedPair(Integer.valueOf(7), Integer.valueOf(7), 1.05));
        this.comparer.sortMatchesByTableIndex();
        Assert.assertEquals((long)4L, (long)((HistoryComparer.MatchedPair)this.comparer.tableMatches.get((int)0)).first);
    }
}

