/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.versions;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.responders.versions.VersionComparer;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VersionComparerResponder
implements Responder {
    private VersionComparer comparer;
    private String firstVersion;
    private String secondVersion;
    private FitNesseContext context;
    public boolean testing;
    private String resource;

    public VersionComparerResponder(VersionComparer comparer) {
        this.comparer = comparer;
    }

    public VersionComparerResponder() {
        this(new VersionComparer());
    }

    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        WikiPagePath path;
        this.resource = request.getResource();
        PageCrawler pageCrawler = context.root.getPageCrawler();
        WikiPage page = pageCrawler.getPage(context.root, path = PathParser.parse((String)this.resource));
        if (page == null) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        this.context = context;
        this.getVersionsFromRequest(request);
        if (this.firstVersion.equals("") && this.secondVersion.equals("")) {
            String message = String.format("Compare Failed because no Input Files were given. Select one or two please.", new Object[0]);
            return this.makeErrorResponse(context, request, message);
        }
        PageData firstVersionData = page.getDataVersion(this.firstVersion);
        PageData secondVersionData = this.secondVersion.equals("") ? page.getData() : page.getDataVersion(this.secondVersion);
        this.comparer.compare(this.firstVersion, firstVersionData.getContent(), this.secondVersion.equals("") ? "latest" : this.secondVersion, secondVersionData.getContent());
        return this.makeValidResponse(request);
    }

    private boolean getVersionsFromRequest(Request request) {
        this.firstVersion = "";
        this.secondVersion = "";
        Map inputs = request.getMap();
        Set keys = inputs.keySet();
        return this.setFileNames(keys);
    }

    private boolean setFileNames(Set<String> keys) {
        List<String> sortedkeys = Arrays.asList(keys.toArray(new String[keys.size()]));
        Collections.sort(sortedkeys);
        for (String key : sortedkeys) {
            if (!key.contains("Version_") || !this.setFileNames(key)) continue;
            return false;
        }
        return !this.firstVersion.equals("") && !this.secondVersion.equals("");
    }

    private boolean setFileNames(String key) {
        if (this.firstVersion.equals("")) {
            this.firstVersion = key.substring(key.indexOf("_") + 1);
        } else if (this.secondVersion.equals("")) {
            this.secondVersion = key.substring(key.indexOf("_") + 1);
        } else {
            return true;
        }
        return false;
    }

    private Response makeErrorResponse(FitNesseContext context, Request request, String message) {
        return new ErrorResponder(message).makeResponse(context, request);
    }

    private Response makeValidResponse(Request request) {
        HtmlPage page = this.context.pageFactory.newPage();
        page.setTitle("Version Comparison");
        page.setPageTitle(this.makePageTitle(request.getResource()));
        page.setNavTemplate("compareVersionsNav.vm");
        page.put("localPath", (Object)request.getResource());
        page.put("original", (Object)this.firstVersion);
        page.put("revised", (Object)(this.secondVersion.equals("") ? "latest" : this.secondVersion));
        if (!this.testing) {
            page.put("differences", (Object)this.comparer.getDifferences());
            page.setMainTemplate("compareVersions");
        }
        SimpleResponse response = new SimpleResponse();
        response.setContent(page.html());
        return response;
    }

    private PageTitle makePageTitle(String resource) {
        String tags = "";
        if (this.context.root != null) {
            WikiPagePath path = PathParser.parse((String)resource);
            PageCrawler crawler = this.context.root.getPageCrawler();
            WikiPage wikiPage = crawler.getPage(this.context.root, path);
            if (wikiPage != null) {
                PageData pageData = wikiPage.getData();
                tags = pageData.getAttribute("Suites");
            }
        }
        return new PageTitle("Version Compare", PathParser.parse((String)resource), tags);
    }
}

