/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.versions;

import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.versions.VersionSelectionResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import java.util.HashSet;
import java.util.List;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class VersionSelectionResponderTest
extends RegexTestCase {
    private WikiPage page;
    private WikiPage root;

    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.page = this.root.getPageCrawler().addPage(this.root, PathParser.parse((String)"PageOne"), "some content");
        PageData data = this.page.getData();
        WikiPageProperties properties = data.getProperties();
        properties.set("Suites", "Page One tags");
        this.page.commit(data);
        FitNesseUtil.makeTestContext((WikiPage)this.root);
    }

    public void tearDown() throws Exception {
    }

    public void testGetVersionsList() throws Exception {
        HashSet<VersionInfo> set = new HashSet<VersionInfo>();
        VersionInfo v1 = new VersionInfo("1-12345678901234");
        VersionInfo v2 = new VersionInfo("2-45612345678901");
        VersionInfo v3 = new VersionInfo("3-11112345678901");
        VersionInfo v4 = new VersionInfo("4-12212345465679");
        set.add(v1);
        set.add(v2);
        set.add(v3);
        set.add(v4);
        PageData data = new PageData(this.page);
        data.addVersions(set);
        List list = VersionSelectionResponder.getVersionsList((PageData)data);
        VersionSelectionResponderTest.assertEquals((Object)v3, list.get(3));
        VersionSelectionResponderTest.assertEquals((Object)v4, list.get(2));
        VersionSelectionResponderTest.assertEquals((Object)v1, list.get(1));
        VersionSelectionResponderTest.assertEquals((Object)v2, list.get(0));
    }

    public void testMakeReponder() throws Exception {
        MockRequest request = new MockRequest();
        request.setResource("PageOne");
        VersionSelectionResponder responder = new VersionSelectionResponder();
        SimpleResponse response = (SimpleResponse)responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)request);
        String content = response.getContent();
        VersionSelectionResponderTest.assertSubString((String)"<a", (String)content);
        VersionSelectionResponderTest.assertSubString((String)"?responder=viewVersion", (String)content);
        VersionSelectionResponderTest.assertNotSubString((String)"$version", (String)content);
        VersionSelectionResponderTest.assertSubString((String)"<h5> Page One tags</h5>", (String)content);
    }
}

