/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fitnesse.http.Request;
import fitnesse.runner.CachingResultFormatter;
import fitnesse.runner.FormattingOption;
import fitnesse.runner.PageResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import util.FileUtil;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class FormattingOptionTest
extends RegexTestCase {
    private ByteArrayOutputStream output;
    private FormattingOption option;
    private CachingResultFormatter formatter;
    private PageResult result1;
    private PageResult result2;
    private TestSummary finalSummary;
    private int port = 1999;

    public void setUp() throws Exception {
        this.output = new ByteArrayOutputStream();
    }

    public void tearDown() throws Exception {
        new File("testOutput.txt").delete();
    }

    public void testConstruction() throws Exception {
        this.option = new FormattingOption("mock", "stdout", (OutputStream)this.output, "localhost", 8081, "SomePage");
        FormattingOptionTest.assertEquals((String)"mock", (String)this.option.format);
        FormattingOptionTest.assertSame((Object)this.output, (Object)this.option.output);
        FormattingOptionTest.assertEquals((String)"localhost", (String)this.option.host);
        FormattingOptionTest.assertEquals((int)8081, (int)this.option.port);
        FormattingOptionTest.assertEquals((String)"SomePage", (String)this.option.rootPath);
    }

    public void testConstructionWithFile() throws Exception {
        this.option = new FormattingOption("mock", "testOutput.txt", (OutputStream)this.output, "localhost", 8081, "SomePage");
        FormattingOptionTest.assertEquals(FileOutputStream.class, this.option.output.getClass());
        this.option.output.write("sample data".getBytes());
        this.option.output.close();
        FormattingOptionTest.assertEquals((String)"sample data", (String)FileUtil.getFileContent((String)"testOutput.txt"));
    }

    public void testRawResults() throws Exception {
        this.sampleFormatter();
        this.option = new FormattingOption("raw", "stdout", (OutputStream)this.output, "localhost", this.port, "SomePage");
        this.option.process(this.formatter.getResultStream(), this.formatter.getByteCount());
        String content = this.output.toString();
        FormattingOptionTest.assertSubString((String)this.result1.toString(), (String)content);
        FormattingOptionTest.assertSubString((String)this.result2.toString(), (String)content);
    }

    public void testRequest() throws Exception {
        this.option = new FormattingOption("mock", "stdout", (OutputStream)this.output, "localhost", 8081, "SomePage");
        String requestString = this.option.buildRequest((InputStream)new ByteArrayInputStream("test results".getBytes()), 12).getText();
        Request request = new Request((InputStream)new ByteArrayInputStream(requestString.getBytes()));
        request.parse();
        FormattingOptionTest.assertEquals((String)"POST /SomePage HTTP/1.1", (String)request.getRequestLine());
        FormattingOptionTest.assertTrue((boolean)request.getHeader("Content-Type").toString().startsWith("multipart"));
        FormattingOptionTest.assertEquals((Object)"localhost:8081", (Object)request.getHeader("Host"));
        FormattingOptionTest.assertEquals((Object)"format", (Object)request.getInput("responder"));
        FormattingOptionTest.assertEquals((Object)"mock", (Object)request.getInput("format"));
        FormattingOptionTest.assertEquals((Object)"test results", (Object)request.getInput("results"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTheWholeDeal() throws Exception {
        this.sampleFormatter();
        FitNesseUtil.startFitnesse((WikiPage)InMemoryPage.makeRoot((String)"RooT"));
        try {
            this.option = new FormattingOption("mock", "stdout", (OutputStream)this.output, "localhost", this.port, "");
            this.option.process(this.formatter.getResultStream(), this.formatter.getByteCount());
        }
        finally {
            FitNesseUtil.stopFitnesse();
        }
        String result = this.output.toString();
        FormattingOptionTest.assertSubString((String)"Mock Results", (String)result);
        FormattingOptionTest.assertSubString((String)this.result1.toString(), (String)result);
        FormattingOptionTest.assertSubString((String)this.result2.toString(), (String)result);
    }

    private void sampleFormatter() throws Exception {
        this.formatter = new CachingResultFormatter();
        this.result1 = new PageResult("ResultOne", new TestSummary(1, 2, 3, 4), "result one content");
        this.result2 = new PageResult("ResultTwo", new TestSummary(4, 3, 2, 1), "result two content");
        this.finalSummary = new TestSummary(5, 5, 5, 5);
        this.formatter.acceptResult(this.result1);
        this.formatter.acceptResult(this.result2);
        this.formatter.acceptFinalCount(this.finalSummary);
    }
}

