/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.StatementExecutorInterface;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.ListUtility;

public abstract class HashWidgetConversionTestBase {
    private static final String OTHER_INSTANCE = "otherInstance";
    private static final String MY_INSTANCE = "myInstance";
    protected StatementExecutorInterface statementExecutor;

    @Before
    public void setUp() throws Exception {
        this.statementExecutor = this.createStatementExecutor();
        this.createMapReceptorInstance();
    }

    protected abstract StatementExecutorInterface createStatementExecutor() throws Exception;

    protected void createMapReceptorInstance() throws Exception {
        this.statementExecutor.create(MY_INSTANCE, this.mapReceptorClassName(), new Object[0]);
    }

    protected abstract String mapReceptorClassName();

    protected abstract String mapConstructorClassName();

    private void assertConvertsTo(String string, List<Object> list) throws Exception {
        Assert.assertEquals((Object)"true", (Object)this.statementExecutor.call(MY_INSTANCE, "setMap", new Object[]{string}));
        Assert.assertEquals(list, (Object)this.statementExecutor.call(MY_INSTANCE, "query", new Object[0]));
        this.statementExecutor.create(OTHER_INSTANCE, this.mapConstructorClassName(), new Object[]{string});
        Assert.assertEquals(list, (Object)this.statementExecutor.call(OTHER_INSTANCE, "query", new Object[0]));
    }

    @Test
    public void fromEmptyString_shouldCreateEmptyMap() throws Exception {
        this.assertConvertsTo("", ListUtility.list());
    }

    @Test
    public void fromGarbageString_shouldCreateEmptyMap() throws Exception {
        this.assertConvertsTo("sdfwewdfsdfwefsdfsdfswe", ListUtility.list());
    }

    @Test
    public void fromEmptyTable_shouldCreateEmptyMap() throws Exception {
        this.assertConvertsTo("<table></table>", ListUtility.list());
    }

    @Test
    public void fromTableWithNoColumns_shouldCreateEmptyMap() throws Exception {
        this.assertConvertsTo("<table><tr></tr><tr></tr></table>", ListUtility.list());
    }

    @Test
    public void fromTableWithOneColumn_shouldCreateEmptyMap() throws Exception {
        this.assertConvertsTo("<table><tr><td>0</td></tr></table>", ListUtility.list());
    }

    @Test
    public void fromTableWithMoreThanTwoColumns_shouldCreateEmptyMap() throws Exception {
        this.assertConvertsTo("<table><tr>  <td>0</td>  <td>0</td>  <td>0</td></tr></table>", ListUtility.list());
    }

    @Test
    public void fromTableWithTwoColumnsAndOneRow_shouldCreateMapWithOneEntry() throws Exception {
        this.assertConvertsTo("<table><tr>  <td>name</td>  <td>Bob</td></tr></table>", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"name", "Bob"})}));
    }

    @Test
    public void fromTableWithTwoColumnsAndTwoRows_shouldCreateMapWithTwoEntries() throws Exception {
        this.assertConvertsTo("<table><tr>  <td>name</td>  <td>Bob</td></tr><tr>  <td>address</td>  <td>here</td></tr></table>", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"address", "here"}), ListUtility.list((String[])new String[]{"name", "Bob"})}));
    }

    @Test
    public void fromTwoValidTables_shouldCreateEmptyMap() throws Exception {
        this.assertConvertsTo("<table><tr>  <td>name</td>  <td>Bob</td></tr></table><table><tr>  <td>name</td>  <td>Bob</td></tr></table>", ListUtility.list());
    }
}

