/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.SlimClient;
import fitnesse.slim.SlimError;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.InstructionExecutor;
import fitnesse.slim.protocol.SlimDeserializer;
import fitnesse.slim.protocol.SlimSerializer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.ListUtility;
import util.StreamReader;

/*
 * Exception performing whole class analysis ignored.
 */
public class SlimClient {
    public static double MINIMUM_REQUIRED_SLIM_VERSION = 0.3;
    public static final int NO_SLIM_SERVER_CONNECTION_FLAG = -32000;
    private Socket client;
    private StreamReader reader;
    private BufferedWriter writer;
    private String slimServerVersionMessage;
    private double slimServerVersion;
    private String hostName;
    private int port;

    public void close() throws IOException {
        this.reader.close();
        this.writer.close();
        this.client.close();
    }

    public SlimClient(String hostName, int port) {
        this.port = port;
        this.hostName = hostName;
    }

    public void connect() throws IOException {
        int tries = 0;
        while (!this.tryConnect()) {
            if (tries > 100) {
                throw new SlimError("Could not start Slim.");
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new SlimError("Wait for connection interrupted.");
            }
            ++tries;
        }
        this.reader = new StreamReader(this.client.getInputStream());
        this.writer = new BufferedWriter(new OutputStreamWriter(this.client.getOutputStream(), "UTF-8"));
        this.slimServerVersionMessage = this.reader.readLine();
        this.validateConnection();
    }

    private void validateConnection() {
        if (this.isConnected()) {
            this.slimServerVersion = Double.parseDouble(this.slimServerVersionMessage.replace("Slim -- V", ""));
        } else {
            this.slimServerVersion = -32000.0;
            System.out.println("Error reading Slim Version. Read the following: " + this.slimServerVersionMessage);
        }
    }

    private boolean tryConnect() {
        try {
            this.client = new Socket(this.hostName, this.port);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public double getServerVersion() {
        return this.slimServerVersion;
    }

    public boolean isConnected() {
        return this.slimServerVersionMessage.startsWith("Slim -- V");
    }

    public Map<String, Object> invokeAndGetResponse(List<Instruction> statements) throws IOException {
        if (statements.size() == 0) {
            return new HashMap<String, Object>();
        }
        String instructions = SlimSerializer.serialize((List)this.toList(statements));
        this.writeString(instructions);
        int resultLength = this.getLengthToRead();
        String results = null;
        results = this.reader.read(resultLength);
        List resultList = SlimDeserializer.deserialize((String)results);
        return SlimClient.resultToMap((List)resultList);
    }

    private List<Object> toList(List<Instruction> instructions) {
        ArrayList<Object> statementsAsList = new ArrayList<Object>(instructions.size());
        for (Instruction instruction : instructions) {
            1 executor = new /* Unavailable Anonymous Inner Class!! */;
            instruction.execute((InstructionExecutor)executor);
        }
        return statementsAsList;
    }

    private static void addArguments(List<Object> list, Object[] arguments) {
        for (Object arg : arguments) {
            list.add(arg);
        }
    }

    private int getLengthToRead() throws IOException {
        String resultLength = this.reader.read(6);
        this.reader.read(1);
        int length = 0;
        try {
            length = Integer.parseInt(resultLength);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Steam Read Failure. Can't read length of message from the server.  Possibly test aborted.  Last thing read: " + resultLength);
        }
        return length;
    }

    private void writeString(String string) throws IOException {
        String packet = String.format("%06d:%s", string.getBytes("UTF-8").length, string);
        this.writer.write(packet);
        this.writer.flush();
    }

    public void sendBye() throws IOException {
        this.writeString("bye");
    }

    public static Map<String, Object> resultToMap(List<? extends Object> slimResults) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object object : slimResults) {
            List resultList = ListUtility.uncheckedCast(Object.class, (Object)object);
            map.put((String)resultList.get(0), resultList.get(1));
        }
        return map;
    }

    static /* synthetic */ void access$000(List x0, Object[] x1) {
        SlimClient.addArguments((List)x0, (Object[])x1);
    }
}

