/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.converters;

import fitnesse.slim.Converter;
import org.apache.commons.lang.StringUtils;

public class EnumConverter<T extends Enum<T>>
implements Converter<T> {
    private final Class<T> enumClass;

    public EnumConverter(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public String toString(T o) {
        return ((Enum)o).name();
    }

    public T fromString(String name) {
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        try {
            return Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException e) {
            for (Enum value : (Enum[])this.enumClass.getEnumConstants()) {
                if (!value.toString().equals(name)) continue;
                return (T)value;
            }
            throw e;
        }
    }
}

