/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.instructions;

import fitnesse.slim.NameTranslator;
import fitnesse.slim.instructions.CallAndAssignInstruction;
import fitnesse.slim.instructions.InstructionExecutor;
import fitnesse.slim.instructions.InstructionResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.AdditionalAnswers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CallAndAssignInstructionTest {
    private static final String RESULT = "result";
    private InstructionExecutor executor;
    private NameTranslator nameTranslator;

    @Before
    public void setUp() throws Exception {
        this.executor = (InstructionExecutor)Mockito.mock(InstructionExecutor.class);
        this.nameTranslator = (NameTranslator)Mockito.mock(NameTranslator.class);
        Mockito.when((Object)this.executor.callAndAssign(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), new Object[]{Matchers.anyVararg()})).thenReturn((Object)RESULT);
        Mockito.when((Object)this.nameTranslator.translate(Matchers.anyString())).thenAnswer(AdditionalAnswers.returnsFirstArg());
    }

    @Test
    public void shouldTranslateMethodNameOnConstruction() {
        new CallAndAssignInstruction("id_1", "symbol", "instance", "method", new Object[]{"arg1", "arg2"}, this.nameTranslator);
        ((NameTranslator)Mockito.verify((Object)this.nameTranslator, (VerificationMode)Mockito.times((int)1))).translate("method");
    }

    @Test
    public void shouldCallExecutorOnExecution() throws Exception {
        CallAndAssignInstruction instruction = new CallAndAssignInstruction("id_1", "symbol", "instance", "method", new Object[]{"arg1", "arg2"}, this.nameTranslator);
        instruction.execute(this.executor);
        ((InstructionExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).callAndAssign("symbol", "instance", "method", new Object[]{"arg1", "arg2"});
    }

    @Test
    public void shouldReturnExecutionResults() {
        CallAndAssignInstruction instruction = new CallAndAssignInstruction("id_1", "symbol", "instance", "method", new Object[]{"arg1", "arg2"}, this.nameTranslator);
        InstructionResult result = instruction.execute(this.executor);
        Assert.assertEquals((Object)"id_1", (Object)result.getId());
        Assert.assertTrue((boolean)result.hasResult());
        Assert.assertFalse((boolean)result.hasError());
        Assert.assertEquals((Object)RESULT, (Object)result.getResult());
    }
}

