/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.instructions;

import fitnesse.slim.instructions.ImportInstruction;
import fitnesse.slim.instructions.InstructionExecutor;
import fitnesse.slim.instructions.InstructionResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ImportInstructionTest {
    private static final String ID = "id_1";
    private static final String RESULT = "OK";
    private InstructionExecutor executor;

    @Before
    public void setUp() throws Exception {
        this.executor = (InstructionExecutor)Mockito.mock(InstructionExecutor.class);
    }

    @Test
    public void shouldDelegateCallToExecutor() throws Exception {
        ImportInstruction instruction = new ImportInstruction(ID, "path");
        instruction.execute(this.executor);
        ((InstructionExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).addPath("path");
    }

    @Test
    public void shouldFormatReturnValues() {
        ImportInstruction instruction = new ImportInstruction(ID, "path");
        InstructionResult result = instruction.execute(this.executor);
        Assert.assertEquals((Object)ID, (Object)result.getId());
        Assert.assertFalse((boolean)result.hasError());
        Assert.assertTrue((boolean)result.hasResult());
        Assert.assertEquals((Object)RESULT, (Object)result.getResult());
    }
}

