/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.instructions;

import fitnesse.slim.instructions.InstructionExecutor;
import fitnesse.slim.instructions.InstructionResult;
import fitnesse.slim.instructions.MakeInstruction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MakeInstructionTest {
    private static final String ID = "id_1";
    private static final String RESULT = "OK";
    private InstructionExecutor executor;

    @Before
    public void setUp() throws Exception {
        this.executor = (InstructionExecutor)Mockito.mock(InstructionExecutor.class);
    }

    @Test
    public void shouldDelegateCallToExecutor() throws Exception {
        MakeInstruction instruction = new MakeInstruction(ID, "instance", "class", new Object[]{"arg1", "arg2"});
        instruction.execute(this.executor);
        ((InstructionExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).create("instance", "class", new Object[]{"arg1", "arg2"});
    }

    @Test
    public void shouldFormatReturnValues() {
        MakeInstruction instruction = new MakeInstruction(ID, "instance", "class", new Object[]{"arg1", "arg2"});
        InstructionResult result = instruction.execute(this.executor);
        Assert.assertEquals((Object)ID, (Object)result.getId());
        Assert.assertTrue((boolean)result.hasResult());
        Assert.assertFalse((boolean)result.hasError());
        Assert.assertEquals((Object)RESULT, (Object)result.getResult());
    }
}

