/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.protocol;

import fitnesse.slim.protocol.SlimDeserializer;
import fitnesse.slim.protocol.SlimSerializer;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.ListUtility;

public class SlimSerializerTest {
    private List<Object> list;

    @Before
    public void setUp() {
        this.list = new ArrayList();
    }

    @Test
    public void nullListSerialize() throws Exception {
        Assert.assertEquals((Object)"[000000:]", (Object)SlimSerializer.serialize((List)this.list));
    }

    @Test
    public void oneItemListSerialize() throws Exception {
        this.list.add("hello");
        Assert.assertEquals((Object)"[000001:000005:hello:]", (Object)SlimSerializer.serialize((List)this.list));
    }

    @Test
    public void twoItemListSerialize() throws Exception {
        this.list.add("hello");
        this.list.add("world");
        Assert.assertEquals((Object)"[000002:000005:hello:000005:world:]", (Object)SlimSerializer.serialize((List)this.list));
    }

    @Test
    public void serializeNestedList() throws Exception {
        ArrayList<String> sublist = new ArrayList<String>();
        sublist.add("element");
        this.list.add(sublist);
        Assert.assertEquals((Object)"[000001:000024:[000001:000007:element:]:]", (Object)SlimSerializer.serialize((List)this.list));
    }

    @Test
    public void serializeListWithNonString() throws Exception {
        String s = SlimSerializer.serialize((List)ListUtility.list((Object[])new Object[]{1}));
        this.list = SlimDeserializer.deserialize((String)s);
        Assert.assertEquals((Object)"1", this.list.get(0));
    }

    @Test
    public void serializeNullElement() throws Exception {
        List list = ListUtility.list();
        list.add(null);
        String s = SlimSerializer.serialize((List)list);
        Assert.assertEquals((Object)"[000001:000004:null:]", (Object)s);
    }
}

