/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.socketservice;

import fitnesse.socketservice.SocketServer;
import fitnesse.socketservice.SocketService;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;

public class SocketService {
    private ServerSocket serverSocket = null;
    private Thread serviceThread = null;
    private volatile boolean running = false;
    private SocketServer server = null;
    private LinkedList<Thread> threads = new LinkedList();
    private volatile boolean everRan = false;

    public SocketService(int port, SocketServer server) throws IOException {
        this.server = server;
        this.serverSocket = this.tryCreateServerSocket(port);
        this.serviceThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.serviceThread.start();
    }

    private ServerSocket tryCreateServerSocket(int port) throws IOException {
        ServerSocket socket;
        try {
            socket = new ServerSocket(port);
        }
        catch (BindException e) {
            System.out.println("Bind exception on port = " + port);
            throw e;
        }
        return socket;
    }

    public void close() throws IOException {
        this.waitForServiceThreadToStart();
        this.running = false;
        this.serverSocket.close();
        try {
            this.serviceThread.join();
            this.waitForServerThreads();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void waitForServiceThreadToStart() {
        if (this.everRan) {
            return;
        }
        while (!this.running) {
            Thread.yield();
        }
    }

    private void serviceThread() {
        this.running = true;
        this.everRan = true;
        while (this.running) {
            try {
                Socket s = this.serverSocket.accept();
                this.startServerThread(s);
            }
            catch (OutOfMemoryError e) {
                System.err.println("Can't create new thread.  Out of Memory.  Aborting");
                e.printStackTrace();
                System.exit(99);
            }
            catch (SocketException sox) {
                this.running = false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServerThread(Socket s) {
        Thread serverThread = new Thread((Runnable)new ServerRunner(this, s));
        LinkedList linkedList = this.threads;
        synchronized (linkedList) {
            this.threads.add(serverThread);
        }
        serverThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForServerThreads() throws InterruptedException {
        while (this.threads.size() > 0) {
            Thread t;
            LinkedList linkedList = this.threads;
            synchronized (linkedList) {
                if (this.threads.size() < 1) {
                    return;
                }
                t = (Thread)this.threads.getFirst();
            }
            t.join();
        }
    }

    static /* synthetic */ void access$000(SocketService x0) {
        x0.serviceThread();
    }

    static /* synthetic */ SocketServer access$100(SocketService x0) {
        return x0.server;
    }

    static /* synthetic */ LinkedList access$200(SocketService x0) {
        return x0.threads;
    }
}

