/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.socketservice;

import fitnesse.socketservice.EchoService;
import fitnesse.socketservice.HelloService;
import fitnesse.socketservice.SocketServer;
import fitnesse.socketservice.SocketService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class SocketServiceTest
extends TestCase {
    private int connections = 0;
    private SocketServer connectionCounter = new /* Unavailable Anonymous Inner Class!! */;
    private SocketService ss;
    private static final int portNumber = 1999;

    public void setUp() throws Exception {
        this.connections = 0;
    }

    public void tearDown() throws Exception {
    }

    public void testNoConnections() throws Exception {
        this.ss = new SocketService(1999, this.connectionCounter);
        this.ss.close();
        SocketServiceTest.assertEquals((int)0, (int)this.connections);
    }

    public void testOneConnection() throws Exception {
        this.ss = new SocketService(1999, this.connectionCounter);
        this.connect(1999);
        this.ss.close();
        SocketServiceTest.assertEquals((int)1, (int)this.connections);
    }

    public void testManyConnections() throws Exception {
        this.ss = new SocketService(1999, this.connectionCounter);
        for (int i = 0; i < 10; ++i) {
            this.connect(1999);
        }
        this.ss.close();
        SocketServiceTest.assertEquals((int)10, (int)this.connections);
    }

    public void testSendMessage() throws Exception {
        this.ss = new SocketService(1999, (SocketServer)new HelloService());
        Socket s = new Socket("localhost", 1999);
        BufferedReader br = SocketServer.StreamUtility.GetBufferedReader((Socket)s);
        String answer = br.readLine();
        s.close();
        this.ss.close();
        SocketServiceTest.assertEquals((String)"Hello", (String)answer);
    }

    public void testReceiveMessage() throws Exception {
        this.ss = new SocketService(1999, (SocketServer)new EchoService());
        Socket s = new Socket("localhost", 1999);
        BufferedReader br = SocketServer.StreamUtility.GetBufferedReader((Socket)s);
        PrintStream ps = SocketServer.StreamUtility.GetPrintStream((Socket)s);
        ps.println("MyMessage");
        String answer = br.readLine();
        s.close();
        this.ss.close();
        SocketServiceTest.assertEquals((String)"MyMessage", (String)answer);
    }

    public void testMultiThreaded() throws Exception {
        this.ss = new SocketService(1999, (SocketServer)new EchoService());
        Socket s = new Socket("localhost", 1999);
        BufferedReader br = SocketServer.StreamUtility.GetBufferedReader((Socket)s);
        PrintStream ps = SocketServer.StreamUtility.GetPrintStream((Socket)s);
        Socket s2 = new Socket("localhost", 1999);
        BufferedReader br2 = SocketServer.StreamUtility.GetBufferedReader((Socket)s2);
        PrintStream ps2 = SocketServer.StreamUtility.GetPrintStream((Socket)s2);
        ps2.println("MyMessage2");
        String answer2 = br2.readLine();
        s2.close();
        ps.println("MyMessage1");
        String answer = br.readLine();
        s.close();
        this.ss.close();
        SocketServiceTest.assertEquals((String)"MyMessage2", (String)answer2);
        SocketServiceTest.assertEquals((String)"MyMessage1", (String)answer);
    }

    private void connect(int port) {
        try {
            Socket s = new Socket("localhost", port);
            this.sleep(30);
            s.close();
        }
        catch (IOException e) {
            SocketServiceTest.fail((String)"could not connect");
        }
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ int access$008(SocketServiceTest x0) {
        return x0.connections++;
    }
}

