/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.responders.PageFactory;
import fitnesse.testsystems.ExecutionLog;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.HashMap;
import java.util.Map;

public class CompositeExecutionLog {
    private WikiPagePath errorLogPagePath;
    private PageCrawler crawler;
    private WikiPage root;
    private Map<String, ExecutionLog> logs = new HashMap();

    public CompositeExecutionLog(WikiPage testPage) {
        this.crawler = testPage.getPageCrawler();
        this.root = this.crawler.getRoot(testPage);
        this.errorLogPagePath = this.crawler.getFullPath(testPage).addNameToFront("ErrorLogs");
    }

    public void add(String testSystemName, ExecutionLog executionLog) {
        this.logs.put(testSystemName, executionLog);
    }

    public void publish(PageFactory pageFactory) {
        PageData pageData;
        String tags;
        WikiPagePath wpp;
        WikiPage wikiPage;
        String content = this.buildLogContent(pageFactory);
        WikiPage errorLogPage = this.crawler.addPage(this.root, this.errorLogPagePath);
        PageData data = errorLogPage.getData();
        if (this.root != null && (wikiPage = this.crawler.getPage(this.root, wpp = new WikiPagePath(this.errorLogPagePath.getRest()))) != null && (tags = (pageData = wikiPage.getData()).getAttribute("Suites")) != null && tags != "") {
            data.setAttribute("Suites", tags);
        }
        data.setContent(content);
        errorLogPage.commit(data);
    }

    private String buildLogContent(PageFactory pageFactory) {
        StringBuffer logContent = new StringBuffer();
        for (String testSystemName : this.logs.keySet()) {
            logContent.append(String.format("!3 !-%s-!\n", testSystemName));
            logContent.append(((ExecutionLog)this.logs.get(testSystemName)).buildLogContent(pageFactory));
        }
        return logContent.toString();
    }

    public String getErrorLogPageName() {
        return PathParser.render((WikiPagePath)this.errorLogPagePath);
    }

    public int exceptionCount() {
        int count = 0;
        for (ExecutionLog log : this.logs.values()) {
            count += log.exceptionCount();
        }
        return count;
    }

    public boolean hasCapturedOutput() {
        for (ExecutionLog log : this.logs.values()) {
            if (!log.hasCapturedOutput()) continue;
            return true;
        }
        return false;
    }
}

