/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.FitNesseContext;
import fitnesse.testsystems.CompositeExecutionLog;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.fit.FitTestSystem;
import fitnesse.testsystems.slim.HtmlSlimTestSystem;
import fitnesse.wiki.WikiPage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TestSystemGroup {
    private Map<TestSystem.Descriptor, TestSystem> testSystems = new HashMap();
    private FitNesseContext context;
    private WikiPage page;
    private TestSystemListener testSystemListener;
    private CompositeExecutionLog log;
    private boolean fastTest = false;
    private boolean manualStart = false;

    public TestSystemGroup(FitNesseContext context, WikiPage page, TestSystemListener listener) {
        this.context = context;
        this.page = page;
        this.testSystemListener = listener;
        this.log = new CompositeExecutionLog(page);
    }

    public CompositeExecutionLog getExecutionLog() {
        return this.log;
    }

    public void kill() throws IOException {
        for (TestSystem testSystem : this.testSystems.values()) {
            testSystem.kill();
        }
    }

    public void setFastTest(boolean fastTest) {
        this.fastTest = fastTest;
    }

    public void setManualStart(boolean manualStart) {
        this.manualStart = manualStart;
    }

    public boolean isSuccessfullyStarted() {
        for (TestSystem testSystem : this.testSystems.values()) {
            if (testSystem.isSuccessfullyStarted()) continue;
            return false;
        }
        return true;
    }

    public TestSystem startTestSystem(TestSystem.Descriptor descriptor, String classPath) throws IOException {
        TestSystem testSystem = null;
        if (!this.testSystems.containsKey(descriptor)) {
            testSystem = this.makeTestSystem(new TestSystem.Descriptor(descriptor, classPath));
            testSystem.setFastTest(this.fastTest);
            testSystem.setManualStart(this.manualStart);
            this.testSystems.put(descriptor, testSystem);
            testSystem.start();
            this.log.add(descriptor.getTestSystemName(), testSystem.getExecutionLog());
        }
        return testSystem;
    }

    private TestSystem makeTestSystem(TestSystem.Descriptor descriptor) {
        if ("slim".equalsIgnoreCase(TestSystem.getTestSystemType((String)descriptor.getTestSystemName()))) {
            return new HtmlSlimTestSystem(this.page, descriptor, this.testSystemListener);
        }
        return new FitTestSystem(this.context, this.page, descriptor, this.testSystemListener);
    }
}

