/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.FitNesse;
import fitnesse.FitNesseContext;
import fitnesse.responders.PageFactory;
import fitnesse.testsystems.TestSystem;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSystemTest {
    private FitNesseContext context;

    @Before
    public void setUp() {
        this.context = FitNesseUtil.makeTestContext();
    }

    @Test
    public void testCommandPatternCSharp() throws Exception {
        String specifiedPageText = "!define COMMAND_PATTERN {%m -r fitSharp.Slim.Service.Runner,fitsharp.dll %p}\n";
        WikiPage specifiedPage = this.makeTestPage(specifiedPageText);
        TestSystem.Descriptor defaultDescriptor2 = TestSystem.getDescriptor((WikiPage)specifiedPage, (PageFactory)this.context.pageFactory, (boolean)false);
        Assert.assertEquals((Object)"%m -r fitSharp.Slim.Service.Runner,fitsharp.dll %p", (Object)defaultDescriptor2.getCommandPattern());
        TestSystem.Descriptor defaultDescriptor3 = TestSystem.getDescriptor((WikiPage)specifiedPage, (PageFactory)this.context.pageFactory, (boolean)true);
        Assert.assertEquals((Object)"%m -r fitSharp.Slim.Service.Runner,fitsharp.dll %p", (Object)defaultDescriptor3.getCommandPattern());
    }

    @Test
    public void testCommandPatternJava() throws Exception {
        String pageText = "!define TEST_SYSTEM {slim}\n";
        WikiPage page = this.makeTestPage(pageText);
        TestSystem.Descriptor defaultDescriptor = TestSystem.getDescriptor((WikiPage)page, (PageFactory)this.context.pageFactory, (boolean)false);
        String sep = System.getProperty("path.separator");
        Assert.assertEquals((Object)("java -cp fitnesse.jar" + sep + "%p %m"), (Object)defaultDescriptor.getCommandPattern());
        TestSystem.Descriptor debugDescriptor = TestSystem.getDescriptor((WikiPage)page, (PageFactory)this.context.pageFactory, (boolean)true);
        Assert.assertEquals((Object)"java -Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=8000 -cp %p %m", (Object)debugDescriptor.getCommandPattern());
        String specifiedPageText = "!define COMMAND_PATTERN {java -specialParam -cp %p %m}\n!define REMOTE_DEBUG_COMMAND {java -remoteDebug -cp %p %m}";
        WikiPage specifiedPage = this.makeTestPage(specifiedPageText);
        TestSystem.Descriptor defaultDescriptor2 = TestSystem.getDescriptor((WikiPage)specifiedPage, (PageFactory)this.context.pageFactory, (boolean)false);
        Assert.assertEquals((Object)"java -specialParam -cp %p %m", (Object)defaultDescriptor2.getCommandPattern());
        TestSystem.Descriptor debugDescriptor2 = TestSystem.getDescriptor((WikiPage)specifiedPage, (PageFactory)this.context.pageFactory, (boolean)true);
        Assert.assertEquals((Object)"java -remoteDebug -cp %p %m", (Object)debugDescriptor2.getCommandPattern());
    }

    @Test
    public void testCommandPatternWithVariable() throws Exception {
        String specifiedPageText = "!define COMMAND_PATTERN (${MY_RUNNER} %p %m)\n!define MY_RUNNER {rubyslim}\n";
        WikiPage specifiedPage = this.makeTestPage(specifiedPageText);
        TestSystem.Descriptor myDescriptor = TestSystem.getDescriptor((WikiPage)specifiedPage, (PageFactory)this.context.pageFactory, (boolean)false);
        Assert.assertEquals((Object)"rubyslim %p %m", (Object)myDescriptor.getCommandPattern());
    }

    @Test
    public void testTestRunnerWithVariable() throws Exception {
        String specifiedPageText = "!define TEST_RUNNER (${MY_RUNNER}.rb)\n!define MY_RUNNER {rubyslim}\n";
        WikiPage specifiedPage = this.makeTestPage(specifiedPageText);
        TestSystem.Descriptor myDescriptor = TestSystem.getDescriptor((WikiPage)specifiedPage, (PageFactory)this.context.pageFactory, (boolean)false);
        Assert.assertEquals((Object)"rubyslim.rb", (Object)myDescriptor.getTestRunner());
    }

    @Test
    public void testRunnerCSharp() throws Exception {
        String specifiedPageText = "!define TEST_RUNNER {..\\fitnesse\\fitsharp\\Runner.exe}";
        WikiPage specifiedPage = this.makeTestPage(specifiedPageText);
        TestSystem.Descriptor defaultDescriptor2 = TestSystem.getDescriptor((WikiPage)specifiedPage, (PageFactory)this.context.pageFactory, (boolean)false);
        Assert.assertEquals((Object)"..\\fitnesse\\fitsharp\\Runner.exe", (Object)defaultDescriptor2.getTestRunner());
        TestSystem.Descriptor defaultDescriptor3 = TestSystem.getDescriptor((WikiPage)specifiedPage, (PageFactory)this.context.pageFactory, (boolean)true);
        Assert.assertEquals((Object)"..\\fitnesse\\fitsharp\\runnerw.exe", (Object)defaultDescriptor3.getTestRunner());
    }

    @Test
    public void testRunnerDefault() throws Exception {
        String pageText = "!define TEST_SYSTEM {slim}\n";
        WikiPage page = this.makeTestPage(pageText);
        TestSystem.Descriptor defaultDescriptor2 = TestSystem.getDescriptor((WikiPage)page, (PageFactory)this.context.pageFactory, (boolean)false);
        Assert.assertEquals((Object)"fitnesse.slim.SlimService", (Object)defaultDescriptor2.getTestRunner());
        TestSystem.Descriptor defaultDescriptor3 = TestSystem.getDescriptor((WikiPage)page, (PageFactory)this.context.pageFactory, (boolean)true);
        Assert.assertEquals((Object)"fitnesse.slim.SlimService", (Object)defaultDescriptor3.getTestRunner());
        String specifiedPageText = "!define REMOTE_DEBUG_RUNNER {Different runner}";
        WikiPage specifiedPage = this.makeTestPage(specifiedPageText);
        TestSystem.Descriptor specifiedDescriptor = TestSystem.getDescriptor((WikiPage)specifiedPage, (PageFactory)this.context.pageFactory, (boolean)true);
        Assert.assertEquals((Object)"Different runner", (Object)specifiedDescriptor.getTestRunner());
    }

    WikiPage makeTestPage(String pageText) throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        PageCrawler crawler = root.getPageCrawler();
        return crawler.addPage(root, PathParser.parse((String)"TestPage"), pageText);
    }

    @Test
    public void testTestRunnerWithRootPathVariable() throws Exception {
        String fitnesseRootpath = "/home/fitnesse";
        FitNesseContext context = FitNesseUtil.makeTestContext(null, (String)fitnesseRootpath, null, (int)80);
        new FitNesse(context, false);
        String specifiedPageText = "!define TEST_RUNNER (${FITNESSE_ROOTPATH}/rubyslim.rb)\n";
        WikiPage specifiedPage = this.makeTestPage(specifiedPageText);
        TestSystem.Descriptor myDescriptor = TestSystem.getDescriptor((WikiPage)specifiedPage, (PageFactory)context.pageFactory, (boolean)false);
        Assert.assertEquals((Object)(fitnesseRootpath + "/rubyslim.rb"), (Object)myDescriptor.getTestRunner());
    }

    @Test
    public void shouldReplaceMarkWithValue() {
        Assert.assertEquals((Object)"Hello world", (Object)TestSystem.replace((String)"Hello %p", (String)"%p", (String)"world"));
        Assert.assertEquals((Object)"/path/to/somewhere", (Object)TestSystem.replace((String)"/path/%p/somewhere", (String)"%p", (String)"to"));
        Assert.assertEquals((Object)"/path/to/somewhere", (Object)TestSystem.replace((String)"/path%p", (String)"%p", (String)"/to/somewhere"));
        Assert.assertEquals((Object)"\\path\\to\\somewhere", (Object)TestSystem.replace((String)"\\path\\%p\\somewhere", (String)"%p", (String)"to"));
        Assert.assertEquals((Object)"\\path\\to\\somewhere", (Object)TestSystem.replace((String)"\\path%p", (String)"%p", (String)"\\to\\somewhere"));
    }

    @Test
    public void shouldIncludeStandaloneJarByDefault() {
        Assert.assertEquals((Object)"fitnesse.jar", (Object)TestSystem.fitnesseJar((String)"fitnesse.jar"));
        Assert.assertEquals((Object)"fitnesse-20121220.jar", (Object)TestSystem.fitnesseJar((String)"fitnesse-20121220.jar"));
        Assert.assertEquals((Object)"fitnesse-standalone.jar", (Object)TestSystem.fitnesseJar((String)"fitnesse-standalone.jar"));
        Assert.assertEquals((Object)"fitnesse-standalone-20121220.jar", (Object)TestSystem.fitnesseJar((String)"fitnesse-standalone-20121220.jar"));
        Assert.assertEquals((Object)"fitnesse.jar", (Object)TestSystem.fitnesseJar((String)"fitnesse-book.jar"));
        Assert.assertEquals((Object)"fitnesse-standalone-20121220.jar", (Object)TestSystem.fitnesseJar((String)String.format("irrelevant.jar%1$sfitnesse-book.jar%1$sfitnesse-standalone-20121220.jar", System.getProperty("path.separator"))));
        Assert.assertEquals((Object)String.format("lib%sfitnesse-standalone.jar", File.separator), (Object)TestSystem.fitnesseJar((String)String.format("lib%sfitnesse-standalone.jar", File.separator)));
    }
}

