/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.fit;

import fitnesse.components.SocketDealer;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.fit.CommandRunningFitClient;
import fitnesse.testsystems.fit.FitClientTest;
import fitnesse.testsystems.fit.FitSocketReceiver;
import fitnesse.testsystems.fit.SimpleSocketDoner;
import fitnesse.testsystems.fit.SocketDoner;
import fitnesse.testsystems.slim.results.ExceptionResult;
import fitnesse.testsystems.slim.results.TestResult;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.util.MockSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import util.RegexTestCase;
import util.TimeMeasurement;

/*
 * Exception performing whole class analysis ignored.
 */
public class FitClientTest
extends RegexTestCase
implements TestSystemListener {
    private List<String> outputs = new ArrayList();
    private List<TestSummary> counts = new ArrayList();
    private CommandRunningFitClient client;
    private boolean exceptionOccurred = false;
    private int port = 9080;
    private FitSocketReceiver receiver;
    private SimpleSocketDoner doner;

    public void setUp() throws Exception {
        CommandRunningFitClient.TIMEOUT = 5000;
        this.client = new CommandRunningFitClient((TestSystemListener)this, this.port, new SocketDealer(), (CommandRunningFitClient.CommandRunningStrategy)new CommandRunningFitClient.OutOfProcessCommandRunner("java -cp classes fit.FitServer -v", null));
        this.receiver = new CustomFitSocketReceiver(this, this.port);
    }

    public void tearDown() throws Exception {
        this.receiver.close();
    }

    public void testOutputChunk(String output) {
        this.outputs.add(output);
    }

    public void testComplete(TestSummary testSummary) {
        this.counts.add(testSummary);
    }

    public void exceptionOccurred(Throwable e) {
        this.exceptionOccurred = true;
        try {
            this.client.kill();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void testAssertionVerified(Assertion assertion, TestResult testResult) {
    }

    public void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
    }

    public void testOneRunUsage() throws Exception {
        this.doSimpleRun();
        FitClientTest.assertFalse((boolean)this.exceptionOccurred);
        FitClientTest.assertEquals((int)1, (int)this.outputs.size());
        FitClientTest.assertEquals((int)1, (int)this.counts.size());
        FitClientTest.assertSubString((String)"class", (String)((String)this.outputs.get(0)));
        FitClientTest.assertEquals((int)1, (int)((TestSummary)this.counts.get(0)).getRight());
    }

    private void doSimpleRun() throws Exception {
        this.receiver.receiveSocket();
        this.client.start();
        Thread.sleep(100L);
        this.client.send("<html><table><tr><td>fitnesse.testutil.PassFixture</td></tr></table></html>");
        this.client.done();
        this.client.join();
    }

    public void testStandardError() throws Exception {
        this.client = new CommandRunningFitClient((TestSystemListener)this, this.port, new SocketDealer(), (CommandRunningFitClient.CommandRunningStrategy)new CommandRunningFitClient.OutOfProcessCommandRunner("java blah", null));
        this.client.start();
        Thread.sleep(100L);
        this.client.join();
        FitClientTest.assertTrue((boolean)this.exceptionOccurred);
        FitClientTest.assertSubString((String)"Error", (String)this.client.commandRunner.getError());
    }

    public void testDoesntwaitForTimeoutOnBadCommand() throws Exception {
        CommandRunningFitClient.TIMEOUT = 5000;
        TimeMeasurement measurement = new TimeMeasurement().start();
        this.client = new CommandRunningFitClient((TestSystemListener)this, this.port, new SocketDealer(), (CommandRunningFitClient.CommandRunningStrategy)new CommandRunningFitClient.OutOfProcessCommandRunner("java blah", null));
        this.client.start();
        Thread.sleep(50L);
        this.client.join();
        FitClientTest.assertTrue((boolean)this.exceptionOccurred);
        FitClientTest.assertTrue((measurement.elapsed() < (long)CommandRunningFitClient.TIMEOUT ? 1 : 0) != 0);
    }

    public void testOneRunWithManyTables() throws Exception {
        this.receiver.receiveSocket();
        this.client.start();
        this.client.send("<html><table><tr><td>fitnesse.testutil.PassFixture</td></tr></table><table><tr><td>fitnesse.testutil.FailFixture</td></tr></table><table><tr><td>fitnesse.testutil.ErrorFixture</td></tr></table></html>");
        this.client.done();
        this.client.join();
        FitClientTest.assertFalse((boolean)this.exceptionOccurred);
        FitClientTest.assertEquals((int)3, (int)this.outputs.size());
        FitClientTest.assertEquals((int)1, (int)this.counts.size());
        TestSummary count = (TestSummary)this.counts.get(0);
        FitClientTest.assertEquals((int)1, (int)count.getRight());
        FitClientTest.assertEquals((int)1, (int)count.getWrong());
        FitClientTest.assertEquals((int)1, (int)count.getExceptions());
    }

    public void testManyRuns() throws Exception {
        this.receiver.receiveSocket();
        this.client.start();
        this.client.send("<html><table><tr><td>fitnesse.testutil.PassFixture</td></tr></table></html>");
        this.client.send("<html><table><tr><td>fitnesse.testutil.FailFixture</td></tr></table></html>");
        this.client.send("<html><table><tr><td>fitnesse.testutil.ErrorFixture</td></tr></table></html>");
        this.client.done();
        this.client.join();
        FitClientTest.assertFalse((boolean)this.exceptionOccurred);
        FitClientTest.assertEquals((int)3, (int)this.outputs.size());
        FitClientTest.assertEquals((int)3, (int)this.counts.size());
        FitClientTest.assertEquals((int)1, (int)((TestSummary)this.counts.get(0)).getRight());
        FitClientTest.assertEquals((int)1, (int)((TestSummary)this.counts.get(1)).getWrong());
        FitClientTest.assertEquals((int)1, (int)((TestSummary)this.counts.get(2)).getExceptions());
    }

    public void testDonerIsNotifiedWhenFinished_success() throws Exception {
        this.doSimpleRun();
        FitClientTest.assertTrue((boolean)this.doner.finished);
    }

    public void testReadyForSending() throws Exception {
        CommandRunningFitClient.TIMEOUT = 5000;
        1 startThread = new /* Unavailable Anonymous Inner Class!! */;
        startThread.start();
        Thread.sleep(100L);
        FitClientTest.assertFalse((boolean)this.client.isSuccessfullyStarted());
        this.client.acceptSocketFrom((SocketDoner)new SimpleSocketDoner((Socket)new MockSocket("")));
        Thread.sleep(100L);
        FitClientTest.assertTrue((boolean)this.client.isSuccessfullyStarted());
        startThread.interrupt();
    }

    public void testUnicodeCharacters() throws Exception {
        this.receiver.receiveSocket();
        this.client.start();
        this.client.send("<html><table><tr><td>fitnesse.testutil.EchoFixture</td><td>\uba80\uba81\uba82\uba83</td></tr></table></html>");
        this.client.done();
        this.client.join();
        FitClientTest.assertFalse((boolean)this.exceptionOccurred);
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.outputs.iterator();
        while (iterator.hasNext()) {
            buffer.append((String)iterator.next());
        }
        FitClientTest.assertSubString((String)"\uba80\uba81\uba82\uba83", (String)buffer.toString());
    }

    static /* synthetic */ SimpleSocketDoner access$002(FitClientTest x0, SimpleSocketDoner x1) {
        x0.doner = x1;
        return x0.doner;
    }

    static /* synthetic */ SimpleSocketDoner access$000(FitClientTest x0) {
        return x0.doner;
    }

    static /* synthetic */ CommandRunningFitClient access$100(FitClientTest x0) {
        return x0.client;
    }
}

