/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.testsystems.slim.HtmlTable;
import fitnesse.testsystems.slim.HtmlTableScanner;
import java.util.Arrays;
import org.htmlparser.util.ParserException;
import org.junit.Assert;
import org.junit.Test;
import util.RegexTestCase;

public class HtmlTableScannerTest {
    private HtmlTableScanner ts;

    private void scan(String page) throws ParserException {
        this.ts = new HtmlTableScanner(page);
    }

    @Test
    public void canHandleEmptyInput() throws Exception {
        this.scan("");
        Assert.assertEquals((long)0L, (long)this.ts.getTableCount());
    }

    @Test
    public void canParseOneSimpleTable() throws Exception {
        this.scan("<table><tr><td>x</td></tr></table>");
        Assert.assertEquals((long)1L, (long)this.ts.getTableCount());
        HtmlTable t = this.ts.getTable(0);
        Assert.assertEquals((long)1L, (long)t.getRowCount());
        Assert.assertEquals((long)1L, (long)t.getColumnCountInRow(0));
        Assert.assertEquals((Object)"x", (Object)t.getCellContents(0, 0));
    }

    @Test
    public void canParseOneSimpleTableWithGunkAroundIt() throws Exception {
        this.scan("<body>Gunk<table>gunk  <tr> gunk     <td>x</td>gunk   </tr>gunk</table>gunk</body>");
        Assert.assertEquals((long)1L, (long)this.ts.getTableCount());
        HtmlTable t = this.ts.getTable(0);
        Assert.assertEquals((long)1L, (long)t.getRowCount());
        Assert.assertEquals((long)1L, (long)t.getColumnCountInRow(0));
        Assert.assertEquals((Object)"x", (Object)t.getCellContents(0, 0));
    }

    @Test
    public void canParseComplexTable() throws Exception {
        this.scan("  <table>  <th>    <td>Name</td>    <td>Address</td>  </th>  <tr>    <td>Bob</td>    <td>Here</td>  </tr></table>  ");
        Assert.assertEquals((long)1L, (long)this.ts.getTableCount());
        HtmlTable t = this.ts.getTable(0);
        Assert.assertEquals((long)2L, (long)t.getRowCount());
        Assert.assertEquals((long)2L, (long)t.getColumnCountInRow(0));
        Assert.assertEquals((long)2L, (long)t.getColumnCountInRow(1));
        Assert.assertEquals((Object)"Name", (Object)t.getCellContents(0, 0));
        Assert.assertEquals((Object)"Address", (Object)t.getCellContents(1, 0));
        Assert.assertEquals((Object)"Bob", (Object)t.getCellContents(0, 1));
        Assert.assertEquals((Object)"Here", (Object)t.getCellContents(1, 1));
    }

    @Test
    public void canParseMultipleTables() throws Exception {
        this.scan("<table><tr><td>1</td></tr></table><table><tr><td>2</td></tr></table>");
        Assert.assertEquals((long)2L, (long)this.ts.getTableCount());
        HtmlTable t1 = this.ts.getTable(0);
        HtmlTable t2 = this.ts.getTable(1);
        Assert.assertEquals((long)1L, (long)t1.getRowCount());
        Assert.assertEquals((long)1L, (long)t2.getRowCount());
        Assert.assertEquals((long)1L, (long)t1.getColumnCountInRow(0));
        Assert.assertEquals((long)1L, (long)t2.getColumnCountInRow(0));
        Assert.assertEquals((Object)"1", (Object)t1.getCellContents(0, 0));
        Assert.assertEquals((Object)"2", (Object)t2.getCellContents(0, 0));
    }

    @Test
    public void canSetCellContents() throws Exception {
        this.scan("<table><tr><td>x</td></tr></table>");
        HtmlTable t = this.ts.getTable(0);
        t.substitute(0, 0, "Wow");
        Assert.assertEquals((Object)"Wow", (Object)t.getCellContents(0, 0));
    }

    @Test
    public void canAppendCellToRow() throws Exception {
        this.scan("<table><tr><td>x</td></tr></table>");
        HtmlTable t = this.ts.getTable(0);
        t.addColumnToRow(0, "ray");
        Assert.assertEquals((Object)"ray", (Object)t.getCellContents(1, 0));
    }

    @Test
    public void canAddRow() throws Exception {
        this.scan("<table><tr><td>x</td></tr></table>");
        HtmlTable t = this.ts.getTable(0);
        t.addRow(Arrays.asList("y", "z"));
        Assert.assertEquals((Object)"y", (Object)t.getCellContents(0, 1));
        Assert.assertEquals((Object)"z", (Object)t.getCellContents(1, 1));
    }

    @Test
    public void canConvertBackToHtmlAfterAddingRows() throws Exception {
        this.scan("<table><tr><td>x</td></tr></table>");
        HtmlTable t = this.ts.getTable(0);
        t.addRow(Arrays.asList("y", "z"));
        RegexTestCase.assertHasRegexp((String)"<table><tr><td>x</td></tr><tr><td>y</td><td>z</td></tr></table>", (String)this.ts.toHtml().toLowerCase());
    }

    @Test
    public void canConvertGunkBackToHtml() throws Exception {
        String html = "gunk<body>gunk<table>gunk<tr>gunk<td>x</td>gunk<br>gunk</tr>gunk</table>gunk</body>";
        this.scan(html);
        RegexTestCase.assertHasRegexp((String)html, (String)this.ts.toHtml());
    }

    @Test
    public void nonBreakingSpaceInTableCellReturnsEmptyString() throws Exception {
        String html = "<table><tr><td>&nbsp;</td></tr></table>";
        this.scan(html);
        Assert.assertEquals((Object)"", (Object)this.ts.getTable(0).getCellContents(0, 0));
    }

    @Test
    public void tablesCanBeRepresentedAsStringLists() throws Exception {
        String html = "<table><tr><td>a</td><td>b</td></tr><tr><td>c</td><td>d</td></tr></table>";
        this.scan(html);
        Assert.assertEquals((Object)"[[a, b], [c, d]]", (Object)this.ts.getTable(0).toString());
    }

    @Test
    public void canExtractTablesFromHtml() throws Exception {
        String table1_fmt = "<body>GunkHeader gunk<table>gunk</table>gunk middle directions";
        String table2_fmt = "<table>gunk 2</table>gunk middle directions2";
        String table3_fmt = "<table>gunk 3</table>gunkend gunk</body>";
        String MULTI_TABLE_HTML = String.format(table1_fmt + table2_fmt + table3_fmt, "", "", "");
        this.scan(MULTI_TABLE_HTML);
        RegexTestCase.assertHasRegexp((String)(table1_fmt + table2_fmt + table3_fmt), (String)this.ts.toHtml(null, null));
        RegexTestCase.assertHasRegexp((String)table1_fmt, (String)this.ts.toHtml(null, this.ts.getTable(1)));
        RegexTestCase.assertHasRegexp((String)table2_fmt, (String)this.ts.toHtml(this.ts.getTable(1), this.ts.getTable(2)));
        RegexTestCase.assertHasRegexp((String)table3_fmt, (String)this.ts.toHtml(this.ts.getTable(2), null));
    }
}

