/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.slim.JavaSlimFactory;
import fitnesse.slim.SlimClient;
import fitnesse.slim.SlimError;
import fitnesse.slim.SlimFactory;
import fitnesse.slim.SlimService;
import fitnesse.testsystems.CommandRunner;
import fitnesse.testsystems.ExecutionLog;
import fitnesse.testsystems.MockCommandRunner;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.SlimTestContextImpl;
import fitnesse.testsystems.slim.SlimTestSystem;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.TableScanner;
import fitnesse.testsystems.slim.results.ExceptionResult;
import fitnesse.testsystems.slim.results.TestResult;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SlimTableFactory;
import fitnesse.testsystems.slim.tables.SyntaxError;
import fitnesse.wiki.ReadOnlyPageData;
import fitnesse.wiki.WikiPage;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class SlimTestSystem
extends TestSystem {
    public static final SlimTable START_OF_TEST = null;
    public static final SlimTable END_OF_TEST = null;
    private CommandRunner slimRunner;
    private SlimClient slimClient;
    private boolean started;
    private SlimTableFactory slimTableFactory = new SlimTableFactory();
    private SlimTestContextImpl testContext;
    private final SlimDescriptor descriptor;
    private boolean stopTestCalled;

    public SlimTestSystem(WikiPage page, TestSystem.Descriptor descriptor, TestSystemListener listener) {
        super(page, listener);
        this.descriptor = new SlimDescriptor(descriptor);
    }

    public SlimTestContext getTestContext() {
        return this.testContext;
    }

    public boolean isSuccessfullyStarted() {
        return this.started;
    }

    public void kill() throws IOException {
        if (this.slimRunner != null) {
            this.slimRunner.kill();
        }
        if (this.slimClient != null) {
            this.slimClient.close();
        }
    }

    public String buildCommand() {
        String slimArguments = this.buildArguments();
        String slimCommandPrefix = super.buildCommand((TestSystem.Descriptor)this.descriptor);
        return String.format("%s %s", slimCommandPrefix, slimArguments);
    }

    private String buildArguments() {
        int slimSocket = this.descriptor.getSlimPort();
        String slimFlags = this.descriptor.getSlimFlags();
        return String.format("%s %d", slimFlags, slimSocket);
    }

    public void start() throws IOException {
        String classPath = this.descriptor.getClassPath();
        String slimArguments = this.buildArguments();
        if (this.fastTest) {
            this.slimRunner = new MockCommandRunner();
            this.createSlimService(slimArguments);
        } else {
            this.slimRunner = this.manualStart ? new MockCommandRunner() : new CommandRunner(this.buildCommand(), "", this.createClasspathEnvironment(classPath));
        }
        this.setExecutionLog(new ExecutionLog(this.page, this.slimRunner));
        this.slimRunner.asynchronousStart();
        this.slimClient = new SlimClient(this.descriptor.determineSlimHost(), this.descriptor.getSlimPort());
        try {
            this.waitForConnection();
            this.started = true;
        }
        catch (SlimError e) {
            this.exceptionOccurred((Throwable)e);
        }
    }

    public void bye() throws IOException {
        this.slimClient.sendBye();
        if (!this.fastTest && !this.manualStart) {
            this.slimRunner.join();
        }
        if (this.fastTest) {
            this.slimRunner.kill();
        }
    }

    void createSlimService(String args) throws SocketException {
        while (!this.tryCreateSlimService(args)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean tryCreateSlimService(String args) throws SocketException {
        try {
            SlimService.parseCommandLine((String[])args.trim().split(" "));
            SlimService.startWithFactoryAsync((SlimFactory)new JavaSlimFactory());
            return true;
        }
        catch (SocketException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    void waitForConnection() {
        while (!this.isConnected()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isConnected() {
        try {
            this.slimClient.connect();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void runTests(TestPage pageToTest) throws IOException {
        this.initializeTest();
        this.checkForAndReportVersionMismatch((ReadOnlyPageData)pageToTest.getDecoratedData());
        this.processAllTablesOnPage(pageToTest);
        this.testComplete(this.testContext.getTestSummary());
    }

    private void initializeTest() {
        this.testContext = new SlimTestContextImpl();
    }

    private void checkForAndReportVersionMismatch(ReadOnlyPageData pageData) {
        double expectedVersionNumber = this.getExpectedSlimVersion(pageData);
        double serverVersionNumber = this.slimClient.getServerVersion();
        if (serverVersionNumber == -32000.0) {
            this.exceptionOccurred((Throwable)new SlimError("Slim Protocol Version Error: Server did not respond with a valid version number."));
        } else if (serverVersionNumber < expectedVersionNumber) {
            this.exceptionOccurred((Throwable)new SlimError(String.format("Slim Protocol Version Error: Expected V%s but was V%s", expectedVersionNumber, serverVersionNumber)));
        }
    }

    private double getExpectedSlimVersion(ReadOnlyPageData pageData) {
        double expectedVersionNumber = SlimClient.MINIMUM_REQUIRED_SLIM_VERSION;
        String pageSpecificSlimVersion = pageData.getVariable("SLIM_VERSION");
        if (pageSpecificSlimVersion != null) {
            try {
                double pageSpecificSlimVersionDouble;
                expectedVersionNumber = pageSpecificSlimVersionDouble = Double.parseDouble(pageSpecificSlimVersion);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return expectedVersionNumber;
    }

    protected abstract List<SlimTable> createSlimTables(TestPage var1);

    protected abstract String createHtmlResults(SlimTable var1, SlimTable var2);

    void processAllTablesOnPage(TestPage pageToTest) throws IOException {
        List allTables = this.createSlimTables(pageToTest);
        if (allTables.size() == 0) {
            String html = this.createHtmlResults(START_OF_TEST, END_OF_TEST);
            this.testOutputChunk(html);
        } else {
            ArrayList oneTableList = new ArrayList(1);
            for (int index = 0; index < allTables.size(); ++index) {
                SlimTable theTable = (SlimTable)allTables.get(index);
                SlimTable startWithTable = index == 0 ? START_OF_TEST : theTable;
                SlimTable nextTable = index + 1 < allTables.size() ? (SlimTable)allTables.get(index + 1) : END_OF_TEST;
                this.processTable(theTable);
                String html = this.createHtmlResults(startWithTable, nextTable);
                this.testOutputChunk(html);
            }
        }
    }

    private void processTable(SlimTable table) throws IOException {
        List assertions = this.createAssertions(table);
        Map instructionResults = !this.stopTestCalled ? this.slimClient.invokeAndGetResponse(Assertion.getInstructions((List)assertions)) : Collections.emptyMap();
        this.evaluateTables(assertions, instructionResults);
    }

    private List<Assertion> createAssertions(SlimTable table) {
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        try {
            assertions.addAll(table.getAssertions());
        }
        catch (SyntaxError e) {
            String tableName = table.getTable().getCellContents(0, 0);
            table.getTable().updateContent(0, 0, TestResult.fail((String)String.format("%s: <strong>Bad table! %s</strong>", tableName, e.getMessage())));
        }
        return assertions;
    }

    protected List<SlimTable> createSlimTables(TableScanner<? extends Table> tableScanner) {
        LinkedList<SlimTable> allTables = new LinkedList<SlimTable>();
        for (Table table : tableScanner) {
            this.createSlimTable(allTables, table);
        }
        return allTables;
    }

    private void createSlimTable(List<SlimTable> allTables, Table table) {
        String tableId = "" + allTables.size();
        SlimTable slimTable = this.slimTableFactory.makeSlimTable(table, tableId, (SlimTestContext)this.testContext);
        if (slimTable != null) {
            allTables.add(slimTable);
        }
    }

    static String translateExceptionMessage(String exceptionMessage) {
        String[] tokens = exceptionMessage.split(" ");
        if (tokens[0].equals("COULD_NOT_INVOKE_CONSTRUCTOR")) {
            return "Could not invoke constructor for " + tokens[1];
        }
        if (tokens[0].equals("NO_METHOD_IN_CLASS")) {
            return String.format("Method %s not found in %s", tokens[1], tokens[2]);
        }
        if (tokens[0].equals("NO_CONSTRUCTOR")) {
            return String.format("Could not find constructor for %s", tokens[1]);
        }
        if (tokens[0].equals("NO_CONVERTER_FOR_ARGUMENT_NUMBER")) {
            return String.format("No converter for %s", tokens[1]);
        }
        if (tokens[0].equals("NO_INSTANCE")) {
            return String.format("The instance %s does not exist", tokens[1]);
        }
        if (tokens[0].equals("NO_CLASS")) {
            return String.format("Could not find class %s", tokens[1]);
        }
        if (tokens[0].equals("MALFORMED_INSTRUCTION")) {
            return String.format("The instruction %s is malformed", exceptionMessage.substring(exceptionMessage.indexOf(" ") + 1));
        }
        return exceptionMessage;
    }

    public static String exceptionToString(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stringWriter);
        e.printStackTrace(pw);
        return "__EXCEPTION__:" + stringWriter.toString();
    }

    protected void evaluateTables(List<Assertion> assertions, Map<String, Object> instructionResults) {
        for (Assertion a : assertions) {
            try {
                String key = a.getInstruction().getId();
                Object returnValue = instructionResults.get(key);
                if (returnValue != null && returnValue instanceof String && ((String)returnValue).startsWith("__EXCEPTION__:")) {
                    ExceptionResult exceptionResult = this.makeExceptionResult(key, (String)returnValue);
                    if (exceptionResult.isStopTestException()) {
                        this.stopTestCalled = true;
                    }
                    if ((exceptionResult = a.getExpectation().evaluateException(exceptionResult)) == null) continue;
                    this.testExceptionOccurred(a, exceptionResult);
                    continue;
                }
                TestResult testResult = a.getExpectation().evaluateExpectation(returnValue);
                this.testAssertionVerified(a, testResult);
            }
            catch (Throwable ex) {
                this.exceptionOccurred(ex);
            }
        }
    }

    private ExceptionResult makeExceptionResult(String resultKey, String resultString) {
        ExceptionResult exceptionResult = new ExceptionResult(resultKey, resultString);
        return exceptionResult;
    }
}

