/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.testsystems.slim.tables.ComparatorUtil;
import org.junit.Assert;
import org.junit.Test;

public class ComparatorUtilTest {
    @Test
    public void trulyEqual() throws Exception {
        Assert.assertTrue((boolean)ComparatorUtil.approximatelyEqual((String)"3.0", (String)"3.0"));
    }

    @Test
    public void veryUnequal() throws Exception {
        Assert.assertFalse((boolean)ComparatorUtil.approximatelyEqual((String)"5", (String)"3"));
    }

    @Test
    public void isWithinPrecision() throws Exception {
        Assert.assertTrue((boolean)ComparatorUtil.approximatelyEqual((String)"3", (String)"2.5"));
    }

    @Test
    public void justTooBig() throws Exception {
        Assert.assertFalse((boolean)ComparatorUtil.approximatelyEqual((String)"3.000", (String)"3.0005"));
    }

    @Test
    public void justTooSmall() throws Exception {
        Assert.assertFalse((boolean)ComparatorUtil.approximatelyEqual((String)"3.0000", (String)"2.999949"));
    }

    @Test
    public void justSmallEnough() throws Exception {
        Assert.assertTrue((boolean)ComparatorUtil.approximatelyEqual((String)"-3.00", (String)"-2.995"));
    }

    @Test
    public void justBigEnough() throws Exception {
        Assert.assertTrue((boolean)ComparatorUtil.approximatelyEqual((String)"-3.000000", (String)"-3.000000499"));
    }

    @Test
    public void classicRoundUp() throws Exception {
        Assert.assertTrue((boolean)ComparatorUtil.approximatelyEqual((String)"3.05", (String)"3.049"));
    }
}

